/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.copying;

import com.oracle.graal.python.builtins.objects.cext.copying.SharedObject;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.io.TruffleProcessBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

final class ElfFile
extends SharedObject {
    private final PythonContext context;
    private final TruffleFile tempfile;

    private String getPatchelf() {
        return ElfFile.which(this.context, "patchelf").toString();
    }

    ElfFile(byte[] b, PythonContext context) throws IOException {
        this.context = context;
        this.tempfile = context.getEnv().createTempFile(null, null, ".so", new FileAttribute[0]);
        try (OutputStream os = this.tempfile.newOutputStream(new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE});){
            os.write(b);
        }
    }

    @Override
    public void setId(String newId) throws IOException, InterruptedException {
        TruffleProcessBuilder pb = ElfFile.newProcessBuilder(this.context);
        pb.command(new String[]{this.getPatchelf(), "--debug", "--set-soname", newId, this.tempfile.toString()});
        Process proc = pb.start();
        if (proc.waitFor() != 0) {
            throw new IOException("Failed to run `patchelf` command. Make sure you have it on your PATH or installed in your venv.");
        }
    }

    @Override
    public void changeOrAddDependency(String oldName, String newName) throws IOException, InterruptedException {
        TruffleProcessBuilder pb = ElfFile.newProcessBuilder(this.context);
        pb.command(new String[]{this.getPatchelf(), "--debug", "--remove-needed", oldName, this.tempfile.toString()});
        Process proc = pb.start();
        if (proc.waitFor() != 0) {
            throw new IOException("Failed to run `patchelf` command. Make sure you have it on your PATH or installed in your venv.");
        }
        pb.command(new String[]{this.getPatchelf(), "--debug", "--add-needed", newName, this.tempfile.toString()});
        proc = pb.start();
        if (proc.waitFor() != 0) {
            throw new IOException("Failed to run `patchelf` command. Make sure you have it on your PATH or installed in your venv.");
        }
    }

    @Override
    public void write(TruffleFile copy) throws IOException {
        this.tempfile.copy(copy, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES});
    }

    @Override
    public void close() throws IOException {
        this.tempfile.delete();
    }
}

