/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class CExtContext {
    public static final int METH_VARARGS = 1;
    public static final int METH_KEYWORDS = 2;
    public static final int METH_NOARGS = 4;
    public static final int METH_O = 8;
    public static final int METH_CLASS = 16;
    public static final int METH_STATIC = 32;
    public static final int METH_FASTCALL = 128;
    public static final int METH_METHOD = 512;
    private static final int CALL_CONVENTION_MASK = 655;
    private final PythonContext context;
    private final Object library;

    public CExtContext(PythonContext context, Object library) {
        this.context = context;
        this.library = library;
    }

    public final PythonContext getContext() {
        return this.context;
    }

    public final Object getLibrary() {
        return this.library;
    }

    public static boolean isMethVarargs(int flags) {
        return (flags & 0x28F) == 1;
    }

    public static boolean isMethVarargsWithKeywords(int flags) {
        return (flags & 0x28F) == 3;
    }

    public static boolean isMethNoArgs(int flags) {
        return (flags & 0x28F) == 4;
    }

    public static boolean isMethO(int flags) {
        return (flags & 0x28F) == 8;
    }

    public static boolean isMethFastcall(int flags) {
        return (flags & 0x28F) == 128;
    }

    public static boolean isMethFastcallWithKeywords(int flags) {
        return (flags & 0x28F) == 130;
    }

    public static boolean isMethMethod(int flags) {
        return (flags & 0x28F) == 642;
    }

    public static boolean isMethStatic(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isClassOrStaticMethod(int flags) {
        return flags > 0 && (flags & 0x30) != 0;
    }

    @CompilerDirectives.TruffleBoundary
    protected static TruffleString getBaseName(TruffleString name) {
        int len = TruffleString.CodePointLengthNode.getUncached().execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING);
        if (len == 1) {
            return name.equalsUncached((AbstractTruffleString)StringLiterals.T_DOT, PythonUtils.TS_ENCODING) ? StringLiterals.T_EMPTY_STRING : name;
        }
        int idx = name.lastIndexOfStringUncached((AbstractTruffleString)StringLiterals.T_DOT, len, 0, PythonUtils.TS_ENCODING);
        if (idx < 0) {
            return name;
        }
        if (idx == len - 1) {
            return StringLiterals.T_EMPTY_STRING;
        }
        return name.substringUncached(idx + 1, len - idx - 1, PythonUtils.TS_ENCODING, true);
    }

    @CompilerDirectives.TruffleBoundary
    protected static PException reportImportError(RuntimeException e, TruffleString name, TruffleString path) throws LoadCExtException.ImportException {
        StringBuilder sb = new StringBuilder();
        Object pythonCause = null;
        PException pcause = null;
        if (e instanceof PException) {
            Object excObj;
            pythonCause = excObj = ((PException)((Object)e)).getEscapedException();
            pcause = (PException)((Object)e);
            sb.append(LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode.getUncached().executeObject(excObj, SpecialMethodNames.T___REPR__));
        } else {
            sb.append(e.getMessage());
        }
        Throwable cause = e;
        while ((cause = cause.getCause()) != null) {
            if (e instanceof PException) {
                Object pythonException = ((PException)((Object)e)).getEscapedException();
                if (pythonCause != null) {
                    ExceptionNodes.SetCauseNode.executeUncached(pythonCause, pythonException);
                }
                pythonCause = pythonException;
                pcause = (PException)((Object)e);
            }
            if (cause.getMessage() == null) continue;
            sb.append(", ");
            sb.append(cause.getMessage());
        }
        Object[] args = new Object[]{path, sb.toString()};
        if (pythonCause != null) {
            throw new LoadCExtException.ImportException(pcause, name, path, ErrorMessages.CANNOT_LOAD, args);
        }
        throw new LoadCExtException.ImportException(null, name, path, ErrorMessages.CANNOT_LOAD, args);
    }

    @CompilerDirectives.TruffleBoundary
    public static PException wrapJavaException(Throwable e, Node raisingNode) {
        TruffleString message = PythonUtils.toTruffleStringUncached(e.getMessage());
        PBaseException excObject = PFactory.createBaseException(PythonLanguage.get(null), PythonBuiltinClassType.SystemError, message != null ? message : PythonUtils.toTruffleStringUncached(e.toString()), PythonUtils.EMPTY_OBJECT_ARRAY);
        return ExceptionUtils.wrapJavaException(e, raisingNode, excObject);
    }
}

