/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class DemultiplexingLogHandler
extends FileHandler {
    static final String PROPERTY_PATTERN = "oracle.jdbc.diagnostics.DemultiplexingLogHandler.pattern";
    static final String PROPERTY_LIMIT = "oracle.jdbc.diagnostics.DemultiplexingLogHandler.limit";
    static final String PROPERTY_COUNT = "oracle.jdbc.diagnostics.DemultiplexingLogHandler.count";
    static final String PROPERTY_APPEND = "oracle.jdbc.diagnostics.DemultiplexingLogHandler.append";
    static final String DEFAULT_PATTERN = "%h/ojdbc_%s.trc";
    static final String DEFAULT_APPEND = String.valueOf(false);
    static final String DEFAULT_LIMIT = String.valueOf(Integer.MAX_VALUE);
    static final String DEFAULT_COUNT = String.valueOf(1);
    String localPattern;
    boolean localAppend;
    int localLimit;
    int localCount;
    Hashtable<Object, Handler> handlerList = new Hashtable(50);

    public DemultiplexingLogHandler() throws IOException {
        super(DemultiplexingLogHandler.getFilename(DemultiplexingLogHandler.getProperty(PROPERTY_PATTERN, DEFAULT_PATTERN), "MAIN"), Integer.parseInt(DemultiplexingLogHandler.getProperty(PROPERTY_LIMIT, DEFAULT_LIMIT)), Integer.parseInt(DemultiplexingLogHandler.getProperty(PROPERTY_COUNT, DEFAULT_COUNT)), Boolean.getBoolean(DemultiplexingLogHandler.getProperty(PROPERTY_APPEND, DEFAULT_APPEND)));
    }

    public DemultiplexingLogHandler(String pattern) throws IOException {
        super(DemultiplexingLogHandler.getFilename(pattern, "MAIN"), Integer.parseInt(DemultiplexingLogHandler.getProperty(PROPERTY_LIMIT, DEFAULT_LIMIT)), Integer.parseInt(DemultiplexingLogHandler.getProperty(PROPERTY_COUNT, DEFAULT_COUNT)), Boolean.getBoolean(DemultiplexingLogHandler.getProperty(PROPERTY_APPEND, DEFAULT_APPEND)));
    }

    public DemultiplexingLogHandler(String pattern, boolean append) throws IOException {
        super(DemultiplexingLogHandler.getFilename(pattern, "MAIN"), Integer.parseInt(DemultiplexingLogHandler.getProperty(PROPERTY_LIMIT, DEFAULT_LIMIT)), Integer.parseInt(DemultiplexingLogHandler.getProperty(PROPERTY_COUNT, DEFAULT_COUNT)), append);
    }

    public DemultiplexingLogHandler(String pattern, int limit, int count) throws IOException {
        super(DemultiplexingLogHandler.getFilename(pattern, "MAIN"), limit, count, Boolean.getBoolean(DemultiplexingLogHandler.getProperty(PROPERTY_APPEND, DEFAULT_APPEND)));
    }

    public DemultiplexingLogHandler(String pattern, int limit, int count, boolean append) throws IOException {
        super(DemultiplexingLogHandler.getFilename(pattern, "MAIN"), limit, count, append);
    }

    void initValues() {
        this.localPattern = DemultiplexingLogHandler.getProperty(PROPERTY_PATTERN, DEFAULT_PATTERN);
        this.localLimit = Integer.parseInt(DemultiplexingLogHandler.getProperty(PROPERTY_LIMIT, DEFAULT_LIMIT));
        this.localCount = Integer.parseInt(DemultiplexingLogHandler.getProperty(PROPERTY_COUNT, DEFAULT_COUNT));
        this.localAppend = Boolean.getBoolean(DemultiplexingLogHandler.getProperty(PROPERTY_APPEND, DEFAULT_APPEND));
    }

    static final String getFilename(String pattern, String suffix) {
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        return pattern.replaceAll("%s", suffix).trim();
    }

    static String getProperty(String name, String defaultValue) {
        String property = LogManager.getLogManager().getProperty(name);
        return property != null ? property : defaultValue;
    }

    @Override
    public void publish(LogRecord record) {
        Object[] param = record.getParameters();
        if (param != null && param.length > 0) {
            Handler handler = this.handlerList.get(param[0]);
            if (handler == null) {
                if (this.localPattern == null) {
                    this.initValues();
                }
                try {
                    handler = new FileHandler(DemultiplexingLogHandler.getFilename(this.localPattern, (String)param[0]), this.localLimit, this.localCount, this.localAppend);
                    handler.setFormatter(this.getFormatter());
                    handler.setFilter(this.getFilter());
                    handler.setLevel(this.getLevel());
                    handler.setEncoding(this.getEncoding());
                    handler.setErrorManager(this.getErrorManager());
                }
                catch (IOException ea) {
                    this.reportError("Unable open FileHandler", ea, 0);
                }
                this.handlerList.put(param[0], handler);
            }
            handler.publish(record);
        } else {
            super.publish(record);
        }
    }

    @Override
    public void close() {
        for (Handler h2 : this.handlerList.values()) {
            h2.close();
        }
        super.close();
    }
}

