/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode_dsl;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;

public final class PBytecodeDSLGeneratorFunctionRootNode
extends PRootNode {
    private final PBytecodeDSLRootNode rootNode;
    private final TruffleString originalName;
    private final ConditionProfile isIterableCoroutine = ConditionProfile.create();

    public PBytecodeDSLGeneratorFunctionRootNode(PythonLanguage language, FrameDescriptor frameDescriptor, PBytecodeDSLRootNode rootNode, TruffleString originalName) {
        super(language, frameDescriptor);
        CompilerAsserts.neverPartOfCompilation();
        this.rootNode = rootNode;
        this.originalName = originalName;
    }

    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        PFunction generatorFunction = PArguments.getGeneratorFunction(arguments);
        assert (generatorFunction != null);
        if (this.rootNode.getCodeUnit().isGenerator()) {
            if (this.isIterableCoroutine.profile((generatorFunction.getCode().getFlags() & 0x100) != 0)) {
                return PFactory.createIterableCoroutine(this.rootNode.getLanguage(), generatorFunction.getName(), generatorFunction.getQualname(), this.rootNode, arguments);
            }
            return PFactory.createGenerator(this.rootNode.getLanguage(), generatorFunction.getName(), generatorFunction.getQualname(), this.rootNode, arguments);
        }
        if (this.rootNode.getCodeUnit().isCoroutine()) {
            return PFactory.createCoroutine(this.rootNode.getLanguage(), generatorFunction.getName(), generatorFunction.getQualname(), this.rootNode, arguments);
        }
        if (this.rootNode.getCodeUnit().isAsyncGenerator()) {
            return PNone.NONE;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Unknown generator/coroutine type");
    }

    public String getName() {
        return this.originalName.toJavaStringUncached();
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "<generator function root " + String.valueOf(this.originalName) + ">";
    }

    @Override
    public Signature getSignature() {
        return this.rootNode.getSignature();
    }

    @Override
    public boolean isPythonInternal() {
        return this.rootNode.isPythonInternal();
    }

    public SourceSection getSourceSection() {
        return this.rootNode.getSourceSection();
    }

    @Override
    protected byte[] extractCode() {
        return this.rootNode.extractCode();
    }

    public PBytecodeDSLRootNode getBytecodeRootNode() {
        return this.rootNode;
    }
}

