/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth;

import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.TLSClientAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class PKITLSClientAuthentication
extends TLSClientAuthentication {
    private final String certSubjectDN;

    public PKITLSClientAuthentication(ClientID clientID, SSLSocketFactory sslSocketFactory) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID, sslSocketFactory);
        this.certSubjectDN = null;
    }

    @Deprecated
    public PKITLSClientAuthentication(ClientID clientID, String certSubjectDN) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID, (X509Certificate)null);
        this.certSubjectDN = Objects.requireNonNull(certSubjectDN);
    }

    public PKITLSClientAuthentication(ClientID clientID, X509Certificate certificate) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID, certificate);
        this.certSubjectDN = certificate.getSubjectX500Principal().getName();
    }

    public String getClientX509CertificateSubjectDN() {
        return this.certSubjectDN;
    }

    public static PKITLSClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        Map params = httpRequest.getBodyAsFormParameters();
        String clientIDString = (String)MultivaluedMapUtils.getFirstValue(params, "client_id");
        if (StringUtils.isBlank(clientIDString)) {
            throw new ParseException("Missing client_id parameter");
        }
        if (httpRequest.getClientX509Certificate() == null) {
            throw new ParseException("Missing client X.509 certificate");
        }
        return new PKITLSClientAuthentication(new ClientID(clientIDString), httpRequest.getClientX509Certificate());
    }
}

