/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth;

import java.util.Date;
import java.util.List;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetails;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Audience;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Issuer;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.JWTID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Subject;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

public class JWTAuthenticationClaimsSet
extends JWTAssertionDetails {
    public JWTAuthenticationClaimsSet(ClientID clientID, Audience aud) {
        this(clientID, aud.toSingleAudienceList(), new Date(new Date().getTime() + 60000L), null, null, new JWTID());
    }

    public JWTAuthenticationClaimsSet(Issuer iss, ClientID clientID, Audience aud) {
        this(iss, clientID, aud.toSingleAudienceList(), new Date(new Date().getTime() + 60000L), null, null, new JWTID());
    }

    public JWTAuthenticationClaimsSet(ClientID clientID, List<Audience> aud, Date exp, Date nbf, Date iat, JWTID jti) {
        super(new Issuer(clientID.getValue()), new Subject(clientID.getValue()), aud, exp, nbf, iat, jti, null);
    }

    public JWTAuthenticationClaimsSet(Issuer iss, ClientID clientID, List<Audience> aud, Date exp, Date nbf, Date iat, JWTID jti) {
        super(iss, new Subject(clientID.getValue()), aud, exp, nbf, iat, jti, null);
    }

    public ClientID getClientID() {
        return new ClientID(this.getSubject());
    }

    public static JWTAuthenticationClaimsSet parse(JSONObject jsonObject) throws ParseException {
        JWTAssertionDetails assertion = JWTAssertionDetails.parse(jsonObject);
        return new JWTAuthenticationClaimsSet(assertion.getIssuer(), new ClientID(assertion.getSubject()), assertion.getAudience(), assertion.getExpirationTime(), assertion.getNotBeforeTime(), assertion.getIssueTime(), assertion.getJWTID());
    }

    public static JWTAuthenticationClaimsSet parse(JWTClaimsSet jwtClaimsSet) throws ParseException {
        return JWTAuthenticationClaimsSet.parse(JSONObjectUtils.toJSONObject(jwtClaimsSet));
    }
}

