/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.crl.CrlRevocationManager;

@SnowflakeJdbcInternalApi
public class SFExtendedCrlTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager exTrustManager;
    private final CrlRevocationManager revocationManager;

    public SFExtendedCrlTrustManager(CrlRevocationManager revocationManager, X509ExtendedTrustManager trustManager) {
        this.revocationManager = revocationManager;
        this.exTrustManager = trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.exTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.exTrustManager.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.exTrustManager.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.exTrustManager.checkServerTrusted(chain, authType);
        this.revocationManager.validateRevocationStatus(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.exTrustManager.checkServerTrusted(chain, authType, engine);
        this.revocationManager.validateRevocationStatus(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.exTrustManager.checkServerTrusted(chain, authType, socket);
        this.revocationManager.validateRevocationStatus(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.exTrustManager.getAcceptedIssuers();
    }
}

