/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.argument.ArgumentType;
import org.firebirdsql.gds.impl.argument.TypedArgument;

public final class StringArgument
extends TypedArgument {
    private static final EnumSet<ArgumentType> SUPPORTED_ARGUMENT_TYPES = EnumSet.of(ArgumentType.TraditionalDpb, ArgumentType.Wide, ArgumentType.StringSpb);
    private static final long serialVersionUID = -7980793147101287101L;
    private final String value;
    private final byte[] asBytes;
    private final Encoding encoding;

    @Deprecated
    public StringArgument(int type, ArgumentType argumentType, String value) {
        this(type, argumentType, value, EncodingFactory.getPlatformEncoding());
    }

    public StringArgument(int type, ArgumentType argumentType, String value, Encoding encoding) {
        super(type, argumentType);
        if (!SUPPORTED_ARGUMENT_TYPES.contains((Object)argumentType)) {
            throw new IllegalArgumentException("Invalid argument type: " + (Object)((Object)argumentType));
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Encoding is required");
        }
        if (value == null) {
            throw new IllegalArgumentException("String value should not be null");
        }
        this.value = value;
        this.asBytes = encoding.encodeToCharset(value);
        this.encoding = encoding;
        if (this.asBytes.length > argumentType.getMaxLength()) {
            throw new IllegalArgumentException(String.format("byte array derived from String value should not be longer than %d bytes, length was %d", argumentType.getMaxLength(), this.asBytes.length));
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.argumentType.writeLength(this.asBytes.length, outputStream);
        outputStream.write(this.asBytes);
    }

    @Override
    public int getLength() {
        return 1 + this.argumentType.getLengthSize() + this.asBytes.length;
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public int getValueAsInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    public void copyTo(ParameterBuffer buffer, Encoding stringEncoding) {
        buffer.addArgument(this.getType(), this.value, stringEncoding != null ? stringEncoding : this.encoding);
    }

    public int hashCode() {
        int result = 23;
        result = 41 * result + this.getType();
        result = 41 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StringArgument)) {
            return false;
        }
        StringArgument otherStringArgument = (StringArgument)other;
        return this.getType() == otherStringArgument.getType() && this.value.equals(otherStringArgument.value);
    }
}

