/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.NamedObjectKey;
import us.fatehi.utility.Utility;

public final class RetrievalCounts {
    private static final Logger LOGGER = Logger.getLogger(RetrievalCounts.class.getName());
    private final String name;
    private int count;
    private int includedCount;
    private final Counts keyCount;
    private final Counts includedKeyCount;

    public RetrievalCounts(String name) {
        this.name = Utility.requireNotBlank((String)name, (String)"No name provided");
        this.count = 0;
        this.includedCount = 0;
        this.keyCount = new Counts();
        this.includedKeyCount = new Counts();
    }

    public int getCount() {
        return this.count;
    }

    public int getIncludedCount() {
        return this.includedCount;
    }

    public String toString() {
        return "%d/%d %s".formatted(this.includedCount, this.count, this.name);
    }

    public void count() {
        ++this.count;
    }

    void count(NamedObjectKey key) {
        if (key == null) {
            return;
        }
        this.keyCount.count(key);
        ++this.count;
    }

    public void countIfIncluded(boolean included) {
        if (included) {
            ++this.includedCount;
        }
    }

    void countIfIncluded(NamedObjectKey key, boolean included) {
        if (key == null) {
            return;
        }
        if (included) {
            this.includedKeyCount.count(key);
            ++this.includedCount;
        }
    }

    public void countIncluded() {
        ++this.includedCount;
    }

    void countIncluded(NamedObjectKey key) {
        if (key == null) {
            return;
        }
        this.includedKeyCount.count(key);
        ++this.includedCount;
    }

    public void log() {
        this.log(Level.INFO, this.count, this.includedCount, null);
    }

    void log(NamedObjectKey key) {
        if (key == null) {
            return;
        }
        this.log(Level.INFO, this.keyCount.get(key), this.includedKeyCount.get(key), key);
    }

    private void log(Level level, int count, int includedCount, NamedObjectKey key) {
        if (level == null) {
            return;
        }
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "Processed %d/%d %s %s".formatted(includedCount, count, this.name, key == null ? "" : " for " + String.valueOf(key)));
        }
    }

    private static class Counts {
        private final Map<NamedObjectKey, Integer> counts = new HashMap<NamedObjectKey, Integer>();

        int count(NamedObjectKey key) {
            if (key == null) {
                return 0;
            }
            int count = 0;
            if (this.counts.containsKey(key)) {
                count = this.get(key);
            }
            this.counts.put(key, ++count);
            return count;
        }

        int get(NamedObjectKey key) {
            if (key == null) {
                return 0;
            }
            int count = 0;
            if (this.counts.containsKey(key)) {
                count = this.counts.get(key);
            }
            return count;
        }
    }
}

