/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.api.NativePointerLibrary;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=NativePointerLibrary.class, useForAOT=true, useForAOTPriority=1)})
final class NFISymbol
implements TruffleObject {
    final Object nativeSymbol;
    final NFISignature signature;

    static Object createBound(Object nativeSymbol, NFISignature signature) {
        return new NFISymbol(nativeSymbol, signature);
    }

    private NFISymbol(Object nativeSymbol, NFISignature signature) {
        assert (signature != null);
        this.nativeSymbol = nativeSymbol;
        this.signature = signature;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] args, @Cached CallSignatureNode.CachedCallSignatureNode call) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        return call.execute(this.signature, this.nativeSymbol, args);
    }

    @ExportMessage
    boolean isNull(@CachedLibrary(value="this.nativeSymbol") InteropLibrary library) {
        return library.isNull(this.nativeSymbol);
    }

    @ExportMessage(name="isPointer", library=InteropLibrary.class)
    boolean isPointerInterop(@CachedLibrary(value="this.nativeSymbol") InteropLibrary library) {
        return library.isPointer(this.nativeSymbol);
    }

    @ExportMessage(name="isPointer", library=NativePointerLibrary.class)
    boolean isPointerNFI(@Cached.Shared(value="backendNativePointer") @CachedLibrary(limit="1") BackendNativePointerLibrary library) {
        return library.isPointer(this.nativeSymbol);
    }

    @ExportMessage(name="asPointer", library=InteropLibrary.class)
    long asPointerInterop(@CachedLibrary(value="this.nativeSymbol") InteropLibrary library) throws UnsupportedMessageException {
        return library.asPointer(this.nativeSymbol);
    }

    @ExportMessage(name="asPointer", library=NativePointerLibrary.class)
    long asPointerNFI(@Cached.Shared(value="backendNativePointer") @CachedLibrary(limit="1") BackendNativePointerLibrary library) throws UnsupportedMessageException {
        return library.asPointer(this.nativeSymbol);
    }

    @ExportMessage
    void toNative(@CachedLibrary(value="this.nativeSymbol") InteropLibrary library) {
        library.toNative(this.nativeSymbol);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return NFILanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return "Native Symbol";
    }
}

