/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.tools.executable.BaseCommand;
import schemacrawler.tools.lint.Lint;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintObjectType;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.tools.lint.Linter;
import schemacrawler.tools.lint.config.LinterConfig;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public abstract class AbstractLinter
extends BaseCommand<LinterConfig, Void>
implements Linter {
    private static final Logger LOGGER = Logger.getLogger(AbstractLinter.class.getName());
    private final UUID linterInstanceId = UUID.randomUUID();
    private final LintCollector lintCollector;
    private LintSeverity severity;
    private int threshold;
    private int lintCount;

    protected AbstractLinter(PropertyName linterName, LintCollector lintCollector) {
        super(Objects.requireNonNull(linterName, "Linter name not provided"));
        this.lintCollector = Objects.requireNonNull(lintCollector, "Lint collector cannot be null");
        this.severity = LintSeverity.medium;
        this.threshold = Integer.MAX_VALUE;
    }

    public void configure(LinterConfig linterConfig) {
        super.configure((Object)linterConfig);
        this.setSeverity(linterConfig.getSeverity());
        this.threshold = linterConfig.getThreshold();
        this.configure(linterConfig.getConfig());
    }

    @Override
    public final boolean exceedsThreshold() {
        return this.lintCount > this.threshold;
    }

    @Override
    public String getDescription() {
        return this.command.getDescription();
    }

    @Override
    public final int getLintCount() {
        return this.lintCount;
    }

    @Override
    public String getLinterId() {
        return this.command.getName();
    }

    @Override
    public final String getLinterInstanceId() {
        return this.linterInstanceId.toString();
    }

    @Override
    public final LintSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public abstract String getSummary();

    public final String toString() {
        return "%s [%s] - %s".formatted(new Object[]{this.getLinterInstanceId(), this.getSeverity(), this.getSummary()});
    }

    protected final <N extends NamedObject & AttributedObject, V extends Serializable> void addLint(LintObjectType objectType, N namedObject, String message, V value) {
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Found lint for %s: %s --> %s", new Object[]{namedObject, message, value}));
        if (this.lintCollector != null) {
            Lint<V> lint = new Lint<V>(this.getLinterId(), this.getLinterInstanceId(), objectType, namedObject, this.getSeverity(), message, value);
            this.lintCollector.addLint(namedObject, lint);
            ++this.lintCount;
        }
    }

    protected void configure(Config config) {
    }

    protected final void setSeverity(LintSeverity severity) {
        if (severity != null) {
            this.severity = severity;
        }
    }
}

