/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.functools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.functools.LruCacheObject;
import com.oracle.graal.python.builtins.modules.functools.LruCacheWrapperBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.functools.LruCacheWrapperBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.functools.LruCacheWrapperBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.functools.LruListElemObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PLruCacheWrapper})
public final class LruCacheWrapperBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = LruCacheWrapperBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return LruCacheWrapperBuiltinsFactory.getFactories();
    }

    @Builtin(name="__deepcopy__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DeepCopyNode
    extends PythonBinaryBuiltinNode {
        DeepCopyNode() {
        }

        @Specialization
        static Object deepcopy(LruCacheObject self, Object ignored) {
            return self;
        }
    }

    @Builtin(name="__copy__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object copy(LruCacheObject self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class GetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        GetNode() {
        }

        @Specialization
        static Object getmethod(LruCacheObject self, Object obj, Object type, @Bind Node inliningTarget, @Cached InlinedConditionProfile objIsNoneProfile) {
            if (objIsNoneProfile.profile(inliningTarget, obj instanceof PNone)) {
                return self;
            }
            return PFactory.createMethod(PythonLanguage.get(inliningTarget), obj, self);
        }
    }

    @Builtin(name="__clear__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ClearNode
    extends PythonUnaryBuiltinNode {
        static LruListElemObject lruCacheUnlinkList(LruCacheObject self) {
            LruListElemObject root;
            LruListElemObject link = root.next;
            root = self.root;
            if (link == root) {
                return null;
            }
            root.prev.next = null;
            root.next = root.prev = root;
            return link;
        }

        @Specialization
        Object clear(LruCacheObject self) {
            LruListElemObject list = ClearNode.lruCacheUnlinkList(self);
            self.cache.clear();
            self.func = null;
            self.kwdMark = null;
            self.cacheInfoType = null;
            CacheClearNode.lruCacheClearList(list);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class PartialCallNode
    extends PythonVarargsBuiltinNode {
        protected PartialCallNode() {
        }

        @Specialization(guards={"self.isUncached()"})
        static Object uncachedLruCacheWrapper(VirtualFrame frame, LruCacheObject self, Object[] args, PKeyword[] kwds, @Cached.Shared @Cached CallNode callNode) {
            ++self.misses;
            return callNode.execute((Frame)frame, self.func, args, kwds);
        }

        static Object lruCacheMakeKey(Object kwdMark, Object[] args, PKeyword[] kwds, int typed, Node inliningTarget, GetClassNode getClassNode, PyUnicodeCheckExactNode unicodeCheckExact, PyLongCheckExactNode longCheckExact) {
            int kwdsSize = kwds.length;
            if (typed == 0 && kwdsSize == 0) {
                Object key;
                if (args.length == 1 && (unicodeCheckExact.execute(inliningTarget, key = args[0]) || longCheckExact.execute(inliningTarget, key))) {
                    return key;
                }
                return PFactory.createTuple(PythonLanguage.get(inliningTarget), args);
            }
            int argsLen = args.length;
            int keySize = args.length;
            if (kwdsSize != 0) {
                keySize += kwdsSize * 2 + 1;
            }
            if (typed != 0) {
                keySize += argsLen + kwdsSize;
            }
            Object[] keyArray = new Object[keySize];
            int keyPos = 0;
            for (Object object : args) {
                keyArray[keyPos++] = object;
            }
            if (kwdsSize != 0) {
                keyArray[keyPos++] = kwdMark;
                for (PKeyword pKeyword : kwds) {
                    keyArray[keyPos++] = pKeyword.getName();
                    keyArray[keyPos++] = pKeyword.getValue();
                }
                assert (keyPos == argsLen + kwdsSize * 2 + 1);
            }
            if (typed != 0) {
                for (Object object : args) {
                    keyArray[keyPos++] = getClassNode.execute(inliningTarget, object);
                }
                if (kwdsSize != 0) {
                    for (PKeyword pKeyword : kwds) {
                        keyArray[keyPos++] = getClassNode.execute(inliningTarget, pKeyword.getValue());
                    }
                }
            }
            assert (keyPos == keySize);
            return PFactory.createTuple(PythonLanguage.get(inliningTarget), keyArray);
        }

        static Object infiniteLruCacheWrapper(VirtualFrame frame, LruCacheObject self, Object[] args, PKeyword[] kwds, Node inliningTarget, Object key, long hash, Object cachedItem, ObjectHashMap.PutNode setItem, CallNode callNode) {
            Object result = cachedItem;
            if (result != null) {
                ++self.hits;
                return result;
            }
            ++self.misses;
            result = callNode.execute((Frame)frame, self.func, args, kwds);
            setItem.put((Frame)frame, inliningTarget, self.cache, key, hash, result);
            return result;
        }

        static void lruCacheAppendLink(LruCacheObject self, LruListElemObject link) {
            LruListElemObject root = self.root;
            LruListElemObject last = root.prev;
            last.next = root.prev = link;
            link.prev = last;
            link.next = root;
        }

        static void lruCacheExtractLink(LruListElemObject link) {
            LruListElemObject prev = link.prev;
            LruListElemObject next = link.next;
            prev.next = link.next;
            next.prev = link.prev;
        }

        static Object boundedLruCacheWrapper(VirtualFrame frame, Node inliningTarget, LruCacheObject self, Object[] args, PKeyword[] kwds, Object key, long hash, Object cachedItem, ObjectHashMap.GetNode getItem, ObjectHashMap.PutNode setItem, ObjectHashMap.RemoveNode popItem, CallNode callNode) {
            if (cachedItem != null) {
                assert (cachedItem instanceof LruListElemObject) : "cachedItem should be an LruListElemObject";
                LruListElemObject link = (LruListElemObject)cachedItem;
                PartialCallNode.lruCacheExtractLink(link);
                PartialCallNode.lruCacheAppendLink(self, link);
                ++self.hits;
                return link.result;
            }
            ++self.misses;
            Object result = callNode.execute((Frame)frame, self.func, args, kwds);
            Object testresult = getItem.execute((Frame)frame, inliningTarget, self.cache, key, hash);
            if (testresult != null) {
                return result;
            }
            assert (self.maxsize > 0);
            if (self.cache.size() < self.maxsize || self.root.next == self.root) {
                LruListElemObject link = new LruListElemObject();
                link.hash = hash;
                link.key = key;
                link.result = result;
                setItem.put((Frame)frame, inliningTarget, self.cache, key, hash, link);
                PartialCallNode.lruCacheAppendLink(self, link);
                return result;
            }
            LruListElemObject link = self.root.next;
            PartialCallNode.lruCacheExtractLink(link);
            Object popresult = popItem.execute((Frame)frame, inliningTarget, self.cache, link.key, link.hash);
            Object object = popresult = popresult != null ? popresult : PNone.NONE;
            if (popresult == PNone.NONE) {
                return result;
            }
            link.hash = hash;
            link.key = key;
            link.result = result;
            setItem.put((Frame)frame, inliningTarget, self.cache, key, hash, link);
            PartialCallNode.lruCacheAppendLink(self, link);
            return result;
        }

        @Specialization(guards={"!self.isUncached()"})
        static Object cachedLruCacheWrapper(VirtualFrame frame, LruCacheObject self, Object[] args, PKeyword[] kwds, @Bind Node inliningTarget, @Cached.Shared @Cached CallNode callNode, @Cached PyObjectHashNode hashNode, @Cached ObjectHashMap.GetNode getItem, @Cached ObjectHashMap.PutNode setItem, @Cached GetClassNode getClassNode, @Cached PyUnicodeCheckExactNode unicodeCheckExact, @Cached PyLongCheckExactNode longCheckExact, @Cached ObjectHashMap.RemoveNode popItem, @Cached InlinedConditionProfile profile) {
            Object key = PartialCallNode.lruCacheMakeKey(self.kwdMark, args, kwds, self.typed, inliningTarget, getClassNode, unicodeCheckExact, longCheckExact);
            long hash = hashNode.execute((Frame)frame, inliningTarget, key);
            Object cached = getItem.execute((Frame)frame, inliningTarget, self.cache, key, hash);
            if (profile.profile(inliningTarget, self.isInfinite())) {
                return PartialCallNode.infiniteLruCacheWrapper(frame, self, args, kwds, inliningTarget, key, hash, cached, setItem, callNode);
            }
            return PartialCallNode.boundedLruCacheWrapper(frame, inliningTarget, self, args, kwds, key, hash, cached, getItem, setItem, popItem, callNode);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class PartialReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reduce(VirtualFrame frame, LruCacheObject self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getQualname) {
            return getQualname.execute((Frame)frame, inliningTarget, self, SpecialAttributeNames.T___QUALNAME__);
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class LruDictNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(mapping)"})
        static Object getDict(LruCacheObject self, PNone mapping, @Bind Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }

        @Specialization
        static Object setDict(LruCacheObject self, PDict mapping, @Bind Node inliningTarget, @Cached SetDictNode setDict) {
            setDict.execute(inliningTarget, self, mapping);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(mapping)", "!isDict(mapping)"})
        static Object setDict(LruCacheObject self, Object mapping, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, mapping);
        }
    }

    @Builtin(name="cache_clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CacheClearNode
    extends PythonUnaryBuiltinNode {
        static void lruCacheClearList(LruListElemObject link) {
            while (link != null) {
                link = link.next;
            }
        }

        @Specialization
        Object clear(LruCacheObject self) {
            LruListElemObject list = ClearNode.lruCacheUnlinkList(self);
            self.misses = 0;
            self.hits = 0;
            self.cache.clear();
            CacheClearNode.lruCacheClearList(list);
            return PNone.NONE;
        }
    }

    @Builtin(name="cache_info", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CacheInfoNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object info(VirtualFrame frame, LruCacheObject self, @Cached CallNode callNode) {
            PNone maxsize = self.maxsize == -1 ? PNone.NONE : Integer.valueOf(self.maxsize);
            return callNode.execute((Frame)frame, self.cacheInfoType, self.hits, self.misses, maxsize, self.cache.size());
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="lru_cache", minNumOfPositionalArgs=5, takesVarArgs=true, takesVarKeywordArgs=true, parameterNames={"$cls", "user_function", "maxsize", "typed", "cache_info_type"})
    @ArgumentClinic(name="typed", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    protected static abstract class LruCacheNewNode
    extends PythonClinicBuiltinNode {
        protected LruCacheNewNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return LruCacheWrapperBuiltinsClinicProviders.LruCacheNewNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object lruCacheNew(VirtualFrame frame, Object type, Object func, Object maxsize_O, int typed, Object cache_info_type, @Bind Node inliningTarget, @Cached PyCallableCheckNode callableCheck, @Cached PyIndexCheckNode indexCheck, @Cached PyNumberAsSizeNode numberAsSize, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            int maxsize;
            LruCacheObject.WrapperType wrapper;
            if (!callableCheck.execute(inliningTarget, func)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.THE_FIRST_ARGUMENT_MUST_BE_CALLABLE);
            }
            if (maxsize_O == PNone.NONE) {
                wrapper = LruCacheObject.WrapperType.INFINITE;
                maxsize = -1;
            } else if (indexCheck.execute(inliningTarget, maxsize_O)) {
                maxsize = numberAsSize.executeExact((Frame)frame, inliningTarget, maxsize_O, PythonBuiltinClassType.OverflowError);
                if (maxsize < 0) {
                    maxsize = 0;
                }
                wrapper = maxsize == 0 ? LruCacheObject.WrapperType.UNCACHED : LruCacheObject.WrapperType.BOUNDED;
            } else {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MAXSIZE_SHOULD_BE_INTEGER_OR_NONE);
            }
            PythonContext context = PythonContext.get(inliningTarget);
            LruCacheObject obj = PFactory.createLruCacheObject(context.getLanguage(inliningTarget), type, getInstanceShape.execute(type));
            obj.root.prev = obj.root;
            obj.root.next = obj.root;
            obj.wrapper = wrapper;
            obj.typed = typed;
            obj.func = func;
            obj.hits = 0;
            obj.misses = 0;
            obj.maxsize = maxsize;
            obj.kwdMark = context.lookupBuiltinModule(BuiltinNames.T_FUNCTOOLS).getModuleState(Object.class);
            obj.cacheInfoType = cache_info_type;
            return obj;
        }
    }
}

