//@ui5-bundle sap/uxap/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/AnchorBar", ["sap/base/i18n/Localization","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/Theming","sap/ui/thirdparty/jquery","sap/m/Button","sap/m/MenuButton","sap/m/library","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","sap/ui/core/Control","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/dom/jquery/scrollLeftRTL"],function(t,e,o,i,jQuery,r,s,n,a,l,c,h,u,f,p,d,_,g,S,y,A,B){"use strict";var m=n.SelectType;var C=2;var I=a.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:y});I.ButtonDelegate={onAfterRendering:function(){var t=this.isA("sap.m.MenuButton")?this._getButtonControl():this,e=this.hasStyleClass("sapUxAPAnchorBarButtonSelected");if(this.data("bHasSubMenu")){t.$().attr("aria-haspopup","menu");t.$().find(".sapMBtn").attr("role","none").removeAttr("aria-haspopup")}t.$().attr("aria-controls",this.data("sectionId")).attr("aria-selected",e)}};I.prototype.init=function(){if(a.prototype.init){a.prototype.init.call(this)}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=t.getRTL();this._bHasButtonsBar=p.system.tablet||p.system.desktop;this.oLibraryResourceBundleOP=o.getResourceBundleFor("sap.uxap");this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new u(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=0;this._iTolerance=0;this._iOffset=0;this._sResizeListenerId=undefined}this.setDesign("Transparent")};I.SCROLL_STEP=250;I.SCROLL_DURATION=500;I.DOM_CALC_DELAY=200;I.prototype.setSelectedButton=function(t){var o=this.getSelectedButton(),i,r=this._oSelect.getItems(),s=r.length>0;if(typeof t==="string"){t=e.getElementById(t)}if(t){if(t.getId()===o){return this}var n=t.data("sectionId");this._sSelectedKey=n;if(n&&s){this._oSelect.setSelectedKey(n)}if(this._bHasButtonsBar&&t.data("secondLevel")!==true){i=e.getElementById(o);this._toggleSelectionStyleClass(i,false);this._toggleSelectionStyleClass(t,true);if(n){this.scrollToSection(n,I.SCROLL_DURATION)}this._setAnchorButtonsTabFocusValues(t)}this.setAssociation("selectedButton",t,true)}return this};I.prototype.setShowPopover=function(t,e){if(this.getShowPopover()===t){return this}return this.setProperty("showPopover",t,true)};I.prototype.getSelectedSection=function(){var t=this.getSelectedButton();if(t&&typeof t==="string"){t=e.getElementById(t)}if(t&&t instanceof r&&t.data("sectionId")){return e.getElementById(t.data("sectionId"))}return null};I.prototype.onBeforeRendering=function(){if(this._bHasButtonsBar){this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3}if(a.prototype.onBeforeRendering){a.prototype.onBeforeRendering.call(this)}var t=this.getContent()||[],e=this.getUpperCase();this._oSelect.setUpperCase(e);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",e);if(t.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey)}};I.prototype.addContent=function(t,e){var o=t.data("secondLevel")===true||t.data("secondLevel")==="true";t.addStyleClass("sapUxAPAnchorBarButton");t.removeAllAriaDescribedBy();this._createSelectItem(t,o);if(o){t.destroy()}else{t.addEventDelegate(I.ButtonDelegate,t);this.addAggregation("content",t,e)}return this};I.prototype._removeButtonsDelegate=function(){var t=this.getContent();t.forEach(function(t){t.removeEventDelegate(I.ButtonDelegate)})};I.prototype._createSelectItem=function(t,e){var o=t.getBindingInfo("text"),i=t.getText().trim()!=""||o;if(i&&(!e||t.data("bTitleVisible")===true)){var r=new c({key:t.data("sectionId"),text:B.escapeSettingsValue(t.getText()),customData:[new d({key:"secondLevel",value:t.data("secondLevel")})]});if(o){r.bindProperty("text",Object.assign({},o))}this._oSelect.addItem(r)}};I.prototype._decorateSubMenuButtons=function(t){var e=t.getSource().getContent();e.forEach(function(t){t.$().attr("aria-controls",t.data("sectionId"))})};I.prototype._toggleSelectionStyleClass=function(t,e){if(t&&t.toggleStyleClass){t.toggleStyleClass("sapUxAPAnchorBarButtonSelected",e);if(t instanceof s){t._getButtonControl().$().attr("aria-selected",e)}else{t.$().attr("aria-selected",e)}}};I.prototype.onButtonPress=function(t){this.fireEvent("_anchorPress",{sectionBaseId:t.getSource().data("sectionId")})};I.prototype._onSelectChange=function(t){var o=t.getParameter("selectedItem"),i,r;if(!o){A.warning("AnchorBar :: no selected hierarchicalSelect item");return}i=e.getElementById(o.getKey());if(i){this.fireEvent("_anchorPress",{sectionBaseId:i.getId()});r=i.getDomRef();if(r){setTimeout(function(){r.focus()},0)}}else{A.error("AnchorBar :: cannot find corresponding section",o.getKey())}};I.prototype._getHierarchicalSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",new g({width:"100%",icon:"sap-icon://slim-arrow-down",tooltip:this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_OVERFLOW"),change:jQuery.proxy(this._onSelectChange,this)}))}return this.getAggregation("_select")};I.prototype._createScrollArrow=function(t){var e,o,s,n,a,c=this,h=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),u=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(t){e=this.getId()+"-arrowScrollLeft";o="slim-arrow-left";s="anchorBarArrowLeft";n=this._bRtl?u:h}else{e=this.getId()+"-arrowScrollRight";o="slim-arrow-right";s="anchorBarArrowRight";n=this._bRtl?h:u}a=new r(e,{icon:l.getIconURI(o),type:"Transparent",press:function(e){e.preventDefault();c._handleScrollButtonTap(t)},tooltip:n});a.addEventDelegate({onAfterRendering:function(){if(i.getTheme()!="sap_hcb"){this.$().attr("tabindex",-1)}},onThemeChanged:function(){if(i.getTheme()=="sap_hcb"){this.$().removeAttr("tabindex")}else{this.$().attr("tabindex",-1)}}},a);return new f({content:[a]}).addStyleClass("anchorBarArrow").addStyleClass(s)};I.prototype._getScrollArrowLeft=function(){var t=this.getAggregation("_scrollArrowLeft");if(t){return t}else{t=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",t);return t}};I.prototype._getScrollArrowRight=function(){var t=this.getAggregation("_scrollArrowRight");if(t){return t}else{t=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",t);return t}};I.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(m.IconOnly);this._computeBarSectionsInfo()}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(m.Default)}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon)};I.prototype._adjustSize=function(t){var e=p.media.getCurrentRange(p.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),o=t&&t.size&&t.size.width!==t.oldSize.width,i=S.Utilities.isPhoneScenario(e)?y._AnchorBarHierarchicalSelectMode.Text:y._AnchorBarHierarchicalSelectMode.Icon;if(i!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=i;this._applyHierarchicalSelectMode()}if(this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return}var r=this.$(),s=r.find(".sapUxAPAnchorBarScrollContainer"),n,a,l,c,h=function t(){var e=n;n=a;a=e};if(o){this.scrollToSection(this._sSelectedKey)}l=s.width();c=this._bRtl?s.scrollLeftRTL():s.scrollLeft();n=c>=this._iTolerance;a=c+l<this._iMaxPosition-this._iTolerance;if(this._bRtl){h()}A.debug("AnchorBar :: scrolled at "+c,"scrollBegin ["+(n?"true":"false")+"] scrollEnd ["+(a?"true":"false")+"]");r.toggleClass("sapUxAPAnchorBarScrollLeft",n);r.toggleClass("sapUxAPAnchorBarScrollRight",a)}};I.prototype._handleScrollButtonTap=function(t){var e=!this._bRtl&&t||this._bRtl&&!t?-1:1;this._oScroller.scrollTo(this._iMaxPosition*e,0,I.SCROLL_DURATION*3)};I.prototype.scrollToSection=function(t,e){if(this._bHasButtonsBar){var o=p.media.getCurrentRange(p.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),e=e||I.SCROLL_DURATION,i;if(!S.Utilities.isPhoneScenario(o)&&this._oSectionInfo[t]){if(this._bRtl&&p.browser.firefox){i=this._oSectionInfo[t].scrollLeft+this._iOffset}else{i=this._oSectionInfo[t].scrollLeft-this._iOffset;if(i<0){i=0}}A.debug("AnchorBar :: scrolling to section "+t+" of "+i);if(this._sCurrentScrollId!=t){this._sCurrentScrollId=t;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);this.$("scroll").parent().stop(true,false)}this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined}.bind(this),e);this._oScroller.scrollTo(i,0,e)}}else{A.debug("AnchorBar :: no need to scroll to "+t)}}};I.prototype.scrollToCurrentlySelectedSection=function(){var t=this.getSelectedButton(),o=e.getElementById(t),i;if(o){i=o.data("sectionId");this.scrollToSection(i,0)}};I.prototype.getScrollDelegate=function(){return this._oScroller};I.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;I.prototype.onsapright=function(t){t.preventDefault();var e,o=this.getContent(),i;o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i+1;return}});if(e&&o[e]){i=o[e];i.focus()}else if(o[o.length-1]){i=o[o.length-1];i.focus()}this._forceScrollIfNeeded(i)};I.prototype.onsapleft=function(t){t.preventDefault();var e,o=this.getContent(),i;o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i-1;return}});if(e&&o[e]){i=o[e];i.focus()}else if(o[0]){i=o[0];i.focus()}this._forceScrollIfNeeded(i,true)};I.prototype._forceScrollIfNeeded=function(t,e){var o=t.getDomRef(),i=o.parentElement,r=i.offsetLeft,s=i.offsetWidth,n=o&&o.offsetWidth,a=o&&o.offsetLeft,l=this._oScroller.getScrollLeft(),c,h,u;if(!i||!n){return}if(!this._bRtl){h=a+n;u=s-(r+h-l);if(!e&&u<0&&s-h<0){this._scrollAnchorBar(e,u)}u=a-this._iOffset-r-C;if(e&&l>u){this._scrollAnchorBar(e,u)}}else{if(e){c=l+s-this._iOffset;h=a-r;if(h+n>c){u=h+n-c+C;this._scrollAnchorBar(e,u)}}else{if(a-r-this._iOffset-C<l){u=n-a+C;this._scrollAnchorBar(e,u)}}}};I.prototype._scrollAnchorBar=function(t,e){var o=!this._bRtl&&t||this._bRtl&&!t?-1:1,i=this._oScroller.getScrollLeft(),r=e;if(o===1){r=this._bRtl?i+e:i+Math.abs(e)}if(this._bRtl&&o===-1){r=e*o}this._oScroller.scrollTo(r,0,I.SCROLL_DURATION*3)};I.prototype.onsapdown=function(t){t.preventDefault()};I.prototype.onsapup=function(t){t.preventDefault()};I.prototype.onsaphome=function(t){t.preventDefault();var e=this.getContent();e[0].focus()};I.prototype.onsapend=function(t){t.preventDefault();var e=this.getContent();e[e.length-1].focus()};I.prototype.onsappageup=function(t){this._handlePageUp(t)};I.prototype.onsappagedown=function(t){this._handlePageDown(t)};I.prototype._handlePageUp=function(t){t.preventDefault();var e;var o=this.getContent();o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i-(I.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return}});if(e&&o[e]){o[e].focus()}else if(o[0]){o[0].focus()}};I.prototype._handlePageDown=function(t){t.preventDefault();var e;var o=this.getContent();o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i+I.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return}});if(e&&o[e]){o[e].focus()}else if(o[o.length-1]){o[o.length-1].focus()}};I.prototype._setAnchorButtonsTabFocusValues=function(t){var e=this.getContent()||[],o,i="0",r="-1",s="tabIndex";e.forEach(function(e){o=e.getAggregation("_button")?e.getAggregation("_button").$():e.$();if(e===t){o.attr(s,i)}else{o.attr(s,r)}})};I.prototype.onAfterRendering=function(){var t;if(a.prototype.onAfterRendering){a.prototype.onAfterRendering.call(this)}t=e.getElementById(this.getSelectedButton());this._setAnchorButtonsTabFocusValues(t);this._iMaxPosition=-1;this._sResizeListenerId=h.register(this,jQuery.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").on("scroll",jQuery.proxy(this._onScroll,this));if(t){this.setSelectedButton(t)}if(this._bHasButtonsBar){this._iComputeContentSizeTimeout=setTimeout(function(){if(this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo()}this._adjustSize();this._iComputeContentSizeTimeout=null}.bind(this),I.DOM_CALC_DELAY)}};I.prototype.onThemeChanged=function(){if(this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo()}};I.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=setTimeout(function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize()}.bind(this),I.SCROLL_DURATION)}};I.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var t=this.getContent()||[];t.forEach(this._computeNextSectionInfo,this);if(this._bRtl&&(p.browser.webkit||p.browser.firefox)){t.forEach(this._adjustNextSectionInfo,this);this._oScroller&&this._oScroller.scrollTo(this._iMaxPosition,0,0)}};I.prototype._computeNextSectionInfo=function(t){var e=t.$().outerWidth(true);this._oSectionInfo[t.data("sectionId")]={scrollLeft:this._iMaxPosition,width:e};this._iMaxPosition+=e};I.prototype._adjustNextSectionInfo=function(t){var e=this._oSectionInfo[t.data("sectionId")];if(p.browser.firefox){e.scrollLeft=-e.scrollLeft}else{e.scrollLeft=this._iMaxPosition-e.scrollLeft-e.width}};I.prototype._resetControl=function(){this._removeButtonsDelegate();this.destroyAggregation("content");this._oSelect.destroyAggregation("items",true);return this};I.prototype._getAccessibilityRole=function(){return"none"};I.prototype.enhanceAccessibilityState=function(t,e){var o=this.getContent(),i=o.indexOf(t);if(i!==-1){e.role="option";e.setsize=o.length;e.posinset=i+1}};I.prototype.exit=function(){if(this._sResizeListenerId){h.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null}if(this._iComputeContentSizeTimeout){clearTimeout(this._iComputeContentSizeTimeout);this._iComputeContentSizeTimeout=null}this._removeButtonsDelegate()};I.prototype._getWidth=function(t){var e=t.getDomRef();return!(t instanceof _)?0:e&&e.offsetWidth||0};I.prototype.setVisible=function(t){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoAnchorBar",!t);return this.setProperty("visible",t)};return I});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/AnchorBarRenderer", ["sap/m/ToolbarRenderer","sap/ui/core/Lib","sap/ui/core/Renderer","sap/m/BarInPageEnabler","./library"],function(e,r,t,o,a){"use strict";var n=t.extend(e);n.apiVersion=2;var s=n._AnchorBarHierarchicalSelectMode={Icon:"icon",Text:"text"};n.renderBarContent=function(e,t){if(t._bHasButtonsBar){e.renderControl(t._getScrollArrowLeft());e.openStart("div",t.getId()+"-scrollContainer");e.class("sapUxAPAnchorBarScrollContainer").openEnd();e.openStart("div",t.getId()+"-scroll").attr("role","listbox").attr("aria-describedby",t.getId()+"-desc").attr("aria-label",r.getResourceBundleFor("sap.uxap").getText("ANCHOR_BAR_ARIA_LABEL")).openEnd();n.renderBarItems(e,t);e.close("div");e.openStart("span",t.getId()+"-desc").class("sapUiPseudoInvisibleText").openEnd();e.text(r.getResourceBundleFor("sap.uxap").getText("ANCHOR_BAR_ARIA_LABEL_DESC"));e.close("span");e.close("div");e.renderControl(t._getScrollArrowRight())}o.addChildClassTo(t._oSelect,t);e.renderControl(t._oSelect)};n.renderBarItems=function(e,r){var t=r.getSelectedButton();r.getContent().forEach(function(a){o.addChildClassTo(a,r);if(a.getId()===t){a.addStyleClass("sapUxAPAnchorBarButtonSelected")}e.renderControl(a)})};n.decorateRootElement=function(r,t){e.decorateRootElement.apply(this,arguments);if(t._sHierarchicalSelectMode===s.Icon){r.class("sapUxAPAnchorBarOverflow")}if(t.getBackgroundDesign()){r.class("sapUxAPAnchorBar"+t.getBackgroundDesign())}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BlockBase", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/mvc/View","sap/ui/base/ManagedObjectObserver","./BlockBaseMetadata","./BlockBaseRenderer","sap/ui/model/Context","sap/ui/layout/form/ColumnLayout","./library","sap/ui/core/Component","sap/ui/layout/library","sap/base/Log","sap/uxap/ModelMapping"],function(jQuery,e,t,o,i,n,a,s,r,p,u,l,d,g){"use strict";var c=l.form.SimpleFormLayout;var h=p.BlockBaseFormAdjustment;var f=e.extend("sap.uxap.BlockBase",{metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{mode:{type:"string",group:"Appearance"},visible:{type:"boolean",group:"Appearance",defaultValue:true},columnLayout:{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},formAdjustment:{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:h.BlockColumns},showSubSectionMore:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{mappings:{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},_views:{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{selectedView:{type:"sap.ui.core.Control",multiple:false}},events:{viewInit:{parameters:{view:{type:"sap.ui.core.mvc.View"}}}},views:{}},renderer:a},n);f.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"})}this._oMappingApplied={};this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;this._oPromisedViews={};this._oViewDestroyObserver=new i(this._onViewDestroy.bind(this))};f.prototype.onBeforeRendering=function(){this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML")}else{d.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.")}}this._applyFormAdjustment()};f.prototype.onAfterRendering=function(){var e=this._getObjectPageLayout(this._oParentObjectPageSubSection);if(e){e._requestAdjustLayout()}};f.prototype.setParent=function(t,o,i){e.prototype.setParent.call(this,t,o,i);if(t?.isA("sap.uxap.ObjectPageSubSection")){this._oParentObjectPageSubSection=t}};f.prototype.setModel=function(t,o){this._applyMapping(o);return e.prototype.setModel.call(this,t,o)};f.prototype._applyMapping=function(){if(this._shouldLazyLoad()){d.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected")}else{this.getMappings().forEach(function(t,o){var i,n,a=t.getInternalModelName(),r=t.getExternalPath(),p=t.getExternalModelName(),u;if(r){if(a==""||r==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty")}i=this.getModel(p);if(!i){return}u=i.resolve(r,this.getBindingContext(p));n=this.getBindingContext(a);if(!this._isMappingApplied(a)||this.getModel(a)!==this.getModel(p)||n&&n.getPath()!==u){d.info("BlockBase :: mapping external model "+p+" to "+a);this._oMappingApplied[a]=true;e.prototype.setModel.call(this,i,a);this.setBindingContext(new s(i,u),a)}}},this)}};f.prototype._isMappingApplied=function(e){return this.getModel(e)&&this._oMappingApplied[e]};f.prototype.propagateProperties=function(t){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(t)){this._oUpdatedModels[t]=true}else{this._applyMapping(t)}return e.prototype.propagateProperties.call(this,t)};f.prototype.getSupportedModes=function(){var e=jQuery.extend({},this.getMetadata().getViews());for(var t in e){e[t]=t}return e};f.prototype.setMode=function(e){e=this._validateMode(e);if(this.getMode()!==e){this.setProperty("mode",e,false);if(!this._shouldLazyLoad()){this._selectView(e)}}return this};f.prototype.setColumnLayout=function(e){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate()}return this.setProperty("columnLayout",e)};f.prototype.clone=function(){var t=-1,o=this.getAssociation("selectedView"),i=this.getAggregation("_views")||[];if(o){i.forEach(function(e,i){if(e.getId()===o){t=i}return t<0})}var n=e.prototype.clone.call(this);if(t>=0){n.setAssociation("selectedView",n.getAggregation("_views")[t])}return n};f.prototype._validateMode=function(e){this.validateProperty("mode",e);if(!this.getMetadata().getView(e)){var t=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){d.warning("BlockBase :: no view defined for block "+t+" for mode "+e+", loading defaultXML instead");e="defaultXML"}else{throw new Error("BlockBase :: no view defined for block "+t+" for mode "+e)}}return e};f.prototype._getSelectedViewContent=function(){var e=null,t,o;t=this.getAssociation("selectedView");o=this.getAggregation("_views");if(o){for(var i=0;!e&&i<o.length;i++){if(o[i].getId()===t){e=o[i]}}}return e};f.prototype.createView=function(e,t){if(!this._oPromisedViews[e.id]){this._oPromisedViews[e.id]=new Promise(function(i,n){var a=u.getOwnerComponentFor(this),s=function(){var t=function(){return o.create(e)};if(a){return a.runAsOwner(t)}else{return t()}};s().then(function(e){this._afterViewInstantiated(e,t);i(e)}.bind(this))}.bind(this))}return this._oPromisedViews[e.id]};f.prototype._afterViewInstantiated=function(e,o){if(this._bIsBeingDestroyed){return}var i=e.getController();if(e){if(i){i.oParentBlock=this}e.addCustomData(new t({key:"layoutMode",value:o}));this.addAggregation("_views",e);this._oViewDestroyObserver.observe(e,{destroy:true});this.fireEvent("viewInit",{view:e})}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+o)}};f.prototype._notifyForLoadingInMode=function(e,t,o){if(e&&typeof e.onParentBlockModeChange==="function"){e.onParentBlockModeChange(o)}else{d.info("BlockBase ::: could not notify "+t.sViewName+" of loading in mode "+o+": missing controller onParentBlockModeChange method")}};f.prototype._selectView=function(e){var t,o=this.getId()+"-"+e,i,n;n=function(t){if(t&&this.getAssociation("selectedView")!==o){this.setAssociation("selectedView",t);this._notifyForLoadingInMode(t.getController(),t,e)}}.bind(this);t=this._findView(e);if(t){n(t);return}i=this.getMetadata().getView(e);i.id=o;this.createView(i,e).then(function(e){n(e)})};f.prototype._findView=function(e){var t=this.getAggregation("_views")||[],o,i;i=t.filter(function(t){return t.data("layoutMode")===e});if(i.length){return i[0]}o=this.getMetadata().getView(e);i=t.filter(function(e){return o.viewName===e.getViewName()});if(i.length){return i[0]}};f.FORM_ADUSTMENT_OFFSET=16;f._FORM_ADJUSTMENT_CONST={labelSpan:{L:12},emptySpan:{L:0},columns:{XL:1,L:1,M:1}};f._PARENT_GRID_SIZE=12;f.prototype._computeFormAdjustmentFields=function(e,t){if(e&&t){return e===h.BlockColumns?jQuery.extend({},f._FORM_ADJUSTMENT_CONST,{columns:t}):f._FORM_ADJUSTMENT_CONST}};f.prototype._applyFormAdjustment=function(){var e=this.getFormAdjustment(),t=this._getSelectedViewContent(),o=this._oParentObjectPageSubSection,i;if(e!==h.None&&t&&o){i=this._computeFormAdjustmentFields(e,o._oLayoutConfig);t.getContent().forEach(function(e){this._adjustForm(e,i)}.bind(this))}};f.prototype._adjustForm=function(e,t){var o,i;if(e.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){e.setLayout(c.ColumnLayout);i=e.getAggregation("form").getLayout();i._iBreakPointTablet-=f.FORM_ADUSTMENT_OFFSET;i._iBreakPointDesktop-=f.FORM_ADUSTMENT_OFFSET;i._iBreakPointLargeDesktop-=f.FORM_ADUSTMENT_OFFSET;e.setLabelSpanL(t.labelSpan.L);e.setEmptySpanL(t.emptySpan.L);this._applyFormAdjustmentFields(t,e);e.setWidth("100%")}else if(e.getMetadata().getName()==="sap.ui.layout.form.Form"){i=e.getLayout();if(i&&i.getMetadata().getName()==="sap.ui.layout.form.ColumnLayout"){o=i}else{o=new r;e.setLayout(o)}o._iBreakPointTablet-=f.FORM_ADUSTMENT_OFFSET;o._iBreakPointDesktop-=f.FORM_ADUSTMENT_OFFSET;o._iBreakPointLargeDesktop-=f.FORM_ADUSTMENT_OFFSET;o.setLabelCellsLarge(t.labelSpan.L);o.setEmptyCellsLarge(t.emptySpan.L);this._applyFormAdjustmentFields(t,o);e.setWidth("100%")}};f.prototype._applyFormAdjustmentFields=function(e,t){t.setColumnsXL(e.columns.XL);t.setColumnsL(e.columns.L);t.setColumnsM(e.columns.M)};f.prototype._getObjectPageLayout=function(e){return p.Utilities.getClosestOPL(this,e)};f.prototype.setVisible=function(e,t){var o=this._getObjectPageLayout(this._oParentObjectPageSubSection);if(e===this.getVisible()){return this}this.setProperty("visible",e,t);o&&o._requestAdjustLayoutAndUxRules();return this};f.prototype.setShowSubSectionMore=function(e,t){if(e!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",e,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility()}}return this};f.prototype.connectToModels=function(){if(!this._bConnected){d.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._getObjectPageLayout(this._oParentObjectPageSubSection)?._isLazyLoadingEffectivelyEnabled()){var e=this.getMode();e&&this._selectView(e);this.updateBindings(true,null)}this.invalidate()}};f.prototype._allowPropagationToLoadedViews=function(e){if(!this._bConnected){return}var t=e&&this.mSkipPropagation._views===true;this.mSkipPropagation._views=!e;if(t){var o=this.removeAllAggregation("_views",true)||[];o.forEach(function(e){this.addAggregation("_views",e,true)},this)}};f.prototype.updateBindingContext=function(t,o,i,n){if(!this._shouldLazyLoad()){return e.prototype.updateBindingContext.call(this,t,o,i,n)}else{d.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout")}};f.prototype.updateBindings=function(t,o){if(!this._shouldLazyLoad()){return e.prototype.updateBindings.call(this,t,o)}else{d.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout")}};f.prototype.exit=function(){if(this._oViewDestroyObserver){this._oViewDestroyObserver.disconnect()}};f.prototype._shouldLazyLoad=function(){var e=this._getObjectPageLayout(this._oParentObjectPageSubSection),t=e?._isLazyLoadingEffectivelyEnabled(),o=t===true||t===undefined;return!!this._oParentObjectPageSubSection&&o&&!this._bConnected};f.prototype._onViewDestroy=function(e){delete this._oPromisedViews[e.object.getId()]};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BlockBaseMetadata", ["sap/ui/core/ElementMetadata","sap/base/Log","sap/base/util/isEmptyObject"],function(e,t,r){"use strict";var n=function(t,r){e.apply(this,arguments);this._mViews=r.metadata.views||{}};n.prototype=Object.create(e.prototype);n.prototype.constructor=n;n.prototype.applySettings=function(t){var r=t.hasOwnProperty("renderer")?t.renderer||"":undefined;e.prototype.applySettings.call(this,t);if(r==null){this._sRendererName=null}};n.prototype.getRendererName=function(){if(!this._sBlockRenderer){this._sBlockRenderer=this._resolveRendererName();t.debug("BlockBaseMetadata :: "+this.getName()+" is renderer with "+this._sBlockRenderer)}return this._sBlockRenderer};n.prototype._resolveRendererName=function(){var t=e.prototype.getRendererName.call(this);if(t==null){var r=this.getParent();if(r){t=n.prototype._resolveRendererName.apply(r)}else{throw new Error("BlockBaseMetadata :: no renderer found for "+this.getName())}}return t};n.prototype.getView=function(e){return this._mViews[e]};n.prototype.getViews=function(){return this._mViews};n.prototype.setView=function(e,t){this._mViews[e]=t;return this};n.prototype.hasViews=function(){return!r(this._mViews)};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BlockBaseRenderer", function(){"use strict";var e={apiVersion:2};e.render=function(e,t){if(!t.getVisible()){return}e.openStart("div",t);if(t._getSelectedViewContent()){e.class("sapUxAPBlockBase").class("sapUxAPBlockBase"+t.getMode())}else{var n=t.getMetadata().getName().split(".").pop();e.class(n+t.getMode())}e.openEnd();if(t._getSelectedViewContent()){e.renderControl(t._getSelectedViewContent())}e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BreadCrumbs", ["sap/m/Link","sap/m/Select","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library","sap/ui/core/InvisibleText","sap/ui/util/openWindow","./BreadCrumbsRenderer","sap/ui/thirdparty/jquery"],function(e,t,i,s,r,o,n,a,l,u,h,g,c,p,jQuery){"use strict";var _=i.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},renderer:p});_.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;_.prototype.init=function(){this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iContainerMaxHeight=this._iREMSize*2};_.prototype.onBeforeRendering=function(){this._bOnPhone=u.system.phone;this._resetControl()};_.prototype.onAfterRendering=function(){this._handleInitialModeSelection()};_.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight()}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this}this._sResizeListenerId=o.register(this,this._handleScreenResize.bind(this));return this};_.prototype._toggleOverflowMode=function(e){if(this._sResizeListenerId){o.deregister(this._sResizeListenerId)}this._setSelectVisible(e);this._setBreadcrumbsVisible(!e);this._sResizeListenerId=o.register(this,this._handleScreenResize.bind(this));return this};_.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new l({src:"sap-icon://slim-arrow-right",color:"#bfbfbf",size:"1rem",useIconTooltip:false}).addStyleClass("sapUxAPTubeIcon"))}return this.getAggregation("_tubeIcon")};_.prototype._getOverflowSelect=function(){var e,i;if(!this.getAggregation("_overflowSelect")){i=this.getLinks().reverse()||[];i.unshift(this.getCurrentLocation());e=new t({items:i.map(this._createSelectItem),autoAdjustWidth:true});e.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",e)}return this.getAggregation("_overflowSelect")};_.prototype._createSelectItem=function(e){return new a({key:e.getId(),text:e.getText()})};_.prototype._overflowSelectChangeHandler=function(t){var i=t.getParameter("selectedItem").getKey(),r=s.getElementById(i),o,n;if(r instanceof e){o=r.getHref();r.firePress();if(o){n=r.getTarget();if(n){c(o,n)}else{window.location.href=o}}}return this};_.prototype._handleScreenResize=function(e){var t=this._shouldOverflow(),i=this._getUsingOverflowSelect();if(t&&!i){this._toggleOverflowMode(true)}else if(!t&&i){this._toggleOverflowMode(false)}return this};_.prototype._shouldOverflow=function(){var e=this._getBreadcrumbsAsJQueryObject(),t,i=this._getUsingOverflowSelect();if(i){this._setBreadcrumbsVisible(true)}e.addClass("sapUxAPInvisible");t=e.outerHeight()>this._iContainerMaxHeight;e.removeClass("sapUxAPInvisible");if(i){this._setBreadcrumbsVisible(false)}return t};_.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs")}return this._$breadcurmbs};_.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select")}return this._$select};_.prototype._setBreadcrumbsVisible=function(e){var t=this.$(),i=this._getBreadcrumbsAsJQueryObject(),s="sapUxAPFullWidth",r="sapUiHidden";if(e){i.removeClass(r);t.removeClass(s)}else{i.addClass(r);t.addClass(s)}return t};_.prototype._setSelectVisible=function(e){var t=this._getOverflowSelectAsJQueryObject(),i="sapUiHidden";if(e){t.removeClass(i)}else{t.addClass(i)}return this};_.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){o.deregister(this._sResizeListenerId)}return this};_.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){_.prototype._oAriaLabelledBy=new g({text:r.getResourceBundleFor("sap.uxap").getText("BREADCRUMB_TRAIL_LABEL")}).toStatic()}return this._oAriaLabelledBy};_.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new n}return this._ItemNavigation};_.prototype._getItemsToNavigate=function(){var e=this.getLinks(),t=this.getCurrentLocation(),i=this.getShowCurrentLocation();if(i&&t){e.push(t)}return e};_.prototype._configureKeyboardHandling=function(){var e=this._getItemNavigation(),t=this._getBreadcrumbsAsJQueryObject()[0],i=-1,s=this._getItemsToNavigate(),r=[];s.forEach(function(e){e.$().attr("tabindex","-1");r.push(e.getDomRef())});this.addDelegate(e);e.setCycling(false);e.setRootDomRef(t);e.setItemDomRefs(r);e.setSelectedIndex(i);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");s[0].$().attr("tabindex","0");return this};_.prototype.onsappageup=function(e){this._handlePageKeys(e,false)};_.prototype.onsappagedown=function(e){this._handlePageKeys(e,true)};_.prototype._handlePageKeys=function(e,t){var i,s=this._getItemsToNavigate(),r=0,o=t?s.length-1:0;e.preventDefault();s.some(function(t,i){if(t.getId()===e.target.id){r=i;return true}});if(t){i=r+_.PAGEUP_AND_PAGEDOWN_JUMP_SIZE}else{i=r-_.PAGEUP_AND_PAGEDOWN_JUMP_SIZE}if(i&&s[i]){s[i].focus()}else if(s[o]){s[o].focus()}};_.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden")};_.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null}this._resetControl()};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/BreadCrumbsRenderer", function(){"use strict";var e={apiVersion:2};e.render=function(e,r){e.openStart("div",r).class("sapUxAPBreadCrumbs").attr("role","navigation").attr("aria-labelledby",r._getAriaLabelledBy().getId()).openEnd();this._renderOverflowSelect(e,r);if(!r._bOnPhone){this._renderBreadcrumbTrail(e,r)}e.close("div")};e._renderBreadcrumbTrail=function(e,r){var n=r.getLinks(),t=r.getCurrentLocation(),o=r._getTubeIcon(),a=r.getShowCurrentLocation();e.openStart("ul",r.getId()+"-breadcrumbs").openEnd();n.forEach(function(r){e.openStart("li").openEnd();e.renderControl(r);e.renderControl(o);e.close("li")});if(a){e.openStart("li").openEnd();e.renderControl(t);e.close("li")}e.close("ul")};e._renderOverflowSelect=function(e,r){var n=r._getTubeIcon();e.openStart("div",r.getId()+"-select");e.class("sapUiHidden");e.openEnd();e.openStart("span").class("sapUxAPBreadCrumbsDots").openEnd().text("...").close("span");e.renderControl(n);e.renderControl(r._getOverflowSelect());e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/HierarchicalSelect", ["sap/m/Select","sap/ui/Device","sap/ui/thirdparty/jqueryui/jquery-ui-position","./HierarchicalSelectRenderer"],function(e,t,jQuery,r){"use strict";var i=e.extend("sap.uxap.HierarchicalSelect",{metadata:{library:"sap.uxap",properties:{upperCase:{type:"boolean",group:"Appearance",defaultValue:false}}},renderer:r});i.POPOVER_MIN_WIDTH_REM=11;i.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments)};i.prototype.onAfterRenderingPicker=function(){e.prototype.onAfterRenderingPicker.call(this);this._applyHierarchyLevelClasses()};i.prototype.onAfterRenderingList=function(){e.prototype.onAfterRenderingList.call(this);this._applyHierarchyLevelClasses()};i.prototype._applyHierarchyLevelClasses=function(){var e=this.getItems()||[];e.forEach(function(e){var t=e.data("secondLevel")===true?"sapUxAPHierarchicalSelectSecondLevel":"sapUxAPHierarchicalSelectFirstLevel";e.$().addClass(t)},this)};i.prototype.setUpperCase=function(e,t){this.setProperty("upperCase",e,t);this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase",e);var r=this.getAggregation("picker");if(r){r.toggleStyleClass("sapMSltPickerFirstLevelUpperCase",e);if(!t){r.invalidate()}}return this};i.prototype.onsapenter=function(t){if(!this.getPicker().isOpen()){e.prototype.ontap.call(this,t)}else{e.prototype.onsapenter.call(this,t)}};["onsapup","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(t){i.prototype[t]=function(r){e.prototype[t].call(this,r);r.stopPropagation()}});i.prototype._createDialog=function(){var t=e.prototype._createDialog.call(this),r=t.getCustomHeader();if(r){r.addStyleClass("sapUxAPHierarchicalSelect")}return t};i.prototype._decoratePopover=function(r){e.prototype._decoratePopover.call(this,r);r._adaptPositionParams=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["end bottom","end center","end top","begin center"];this._atPositions=["end top","end center","end bottom","begin center"]};if(t.system.tablet||t.system.desktop){var i=jQuery.position.scrollbarWidth();if(i>0){r.setOffsetX(i)}}};i.prototype._onAfterRenderingPopover=function(){var e=this.getPicker(),t=e.getDomRef("cont"),r=t.style.minWidth;if(r.endsWith("rem")){r=r.substring(0,r.length-3);var o=parseFloat(r);if(o<i.POPOVER_MIN_WIDTH_REM&&t){t.style.minWidth=i.POPOVER_MIN_WIDTH_REM+"rem"}}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/HierarchicalSelectRenderer", ["sap/m/SelectRenderer","sap/ui/core/Renderer"],function(e,r){"use strict";var a=r.extend(e);a.apiVersion=2;a.addClass=function(e){e.class("sapUxAPHierarchicalSelect")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/LazyLoading", ["sap/ui/core/Element","sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Object","./ObjectPageSubSection","./library","sap/base/Log","sap/base/util/isEmptyObject"],function(e,jQuery,t,i,o,s,n,r){"use strict";var a={};var u=i.extend("sap.uxap._helpers.LazyLoading",{constructor:function(e){this._oObjectPageLayout=e;this._$html=jQuery("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._bSuppressed=false;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters()},getInterface:function(){return this}});u.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:1,ScrollToSection:1}}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:2,ScrollToSection:1}}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:2,ScrollToSection:2}}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:3,ScrollToSection:3}}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5};u.prototype.suppress=function(){this._bSuppressed=true};u.prototype.resume=function(){this._bSuppressed=false};u.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading()};u.prototype.lazyLoadDuringScroll=function(e,t,i,o){var s,r,a=false;if(this._bSuppressed){return}if(e){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer)}this._sLazyLoadingTimer=null;this.doLazyLoading(t);return}this._iScrollProgress=t-this._iPreviousScrollTop;s=Math.round(Math.abs(this._iScrollProgress)/o*100);if(s>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){a=true}this._iPreviousScrollTop=t;this._iPreviousScrollTimestamp=i||0;r=t===0?0:this.LAZY_LOADING_DELAY;if(a&&this._sLazyLoadingTimer){n.debug("ObjectPageLayout :: lazyLoading","delayed by "+r+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this,t),r)}};u.prototype.doLazyLoading=function(t){var i=this._oObjectPageLayout._getHeightRelatedParameters(),o=this._oObjectPageLayout.getUseIconTabBar(),s=e.getElementById(this._oObjectPageLayout.getSelectedSection()),r=this._oObjectPageLayout._oSectionInfo,u,c,l,_={},h={},L,g,S;if(this._bSuppressed){return}l=i.iScreenHeight-i.iAnchorBarHeight-i.iHeaderTitleHeightStickied;u=t||i.iScrollTop;L=Date.now()-this._iPreviousScrollTimestamp;g=L<this.LAZY_LOADING_DELAY/2&&Math.abs(this._iScrollProgress)>5;if(g){if(this._iScrollProgress>=0){S=Math.round(Math.min(this._iScrollProgress*20,l/2))}else{S=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,l/2))}u+=S;n.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+S)}c=u+l;u+=16;jQuery.each(r,jQuery.proxy(function(e,t){if(!t.isSection&&t.sectionReference.getParent()&&t.sectionReference.getParent().getVisible()){if(o&&s&&s.indexOfSubSection(t.sectionReference)<0){return}if(t.positionTop<=c&&u<t.positionBottom-1){h[e]=e;if(!t.loaded){_[e]=e}}}},this));jQuery.each(_,jQuery.proxy(function(t,i){n.debug("ObjectPageLayout :: lazyLoading","connecting "+i);a[t]=true;e.getElementById(i).connectToModelsAsync().then(function(){a[t]=false;n.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+i);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:e.getElementById(i)});this._oPrevSubSectionsInView[t]=e.getElementById(i)}.bind(this));r[i].loaded=true},this));jQuery.each(h,jQuery.proxy(function(t,i){if(!this._oPrevSubSectionsInView[t]&&!a[t]){n.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+i);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:e.getElementById(i)});this._oPrevSubSectionsInView[t]=e.getElementById(i)}},this));if(g){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY)}else{this._sLazyLoadingTimer=null}};u.prototype.getSubsectionsToPreload=function(e,t){var i,s;if(t){i=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;s=false}else{i=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;s=true}var n=[];e.some(function(e){if(!s&&t){s=e.getId()==t}if(s&&e instanceof o){if(e.getVisible()&&e._getInternalVisible()){n.push(e);i--}}return i<=0});return n};u.prototype.destroy=function(){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer)}};u.prototype._isPhone=function(){return s.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange())};u.prototype._isTablet=function(){return t.system.tablet};u.prototype._isTabletSize=function(){return s.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange())};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ModelMapping", ["sap/ui/core/Element","./library"],function(e,a){"use strict";var t=e.extend("sap.uxap.ModelMapping",{metadata:{library:"sap.uxap",properties:{externalModelName:{type:"string",group:"Misc",defaultValue:null},internalModelName:{type:"string",group:"Misc",defaultValue:"Model"},externalPath:{type:"string",group:"Misc",defaultValue:null}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectImageHelper", ["sap/ui/base/ManagedObject","sap/ui/core/IconPool","sap/m/Avatar","sap/m/Image"],function(e,a,t,c){"use strict";var n=function(){};n.createObjectImage=function(a){var t,r=a.getObjectImageURI();if(r.indexOf("sap-icon://")===0){t=n.instantiateAvatar(r);t.addStyleClass("sapUxAPObjectPageHeaderObjectImageIcon")}else{t=new c({densityAware:a.getObjectImageDensityAware(),alt:e.escapeSettingsValue(a.getObjectImageAlt()),decorative:false,mode:"Background",backgroundSize:"cover",backgroundPosition:"center"});t.addStyleClass("sapUxAPObjectPageHeaderObjectImage");t.setSrc(r)}if(a.getObjectImageAlt()){t.setTooltip(a.getObjectImageAlt())}return t};n.instantiateAvatar=function(e){return new t({displaySize:"L",fallbackIcon:e})};n.createPlaceholder=function(){return n.instantiateAvatar(a.getIconURI("picture"))};n.updateAvatarInstance=function(e,a,t){e.setDisplayShape(a);e.setBackgroundColor(t)};n._renderImageAndPlaceholder=function(e,a){var t=a.oHeader,c=a.oObjectImage,r=a.oPlaceholder,s=a.bIsObjectIconAlwaysVisible,o=a.bAddSubContainer,l=a.sBaseClass,d=t.getObjectImageShape(),i=t.getObjectImageBackgroundColor(),g=t.getShowPlaceholder()&&!t.getObjectImageURI(),b=c.isA("sap.m.Avatar");if(t.getShowPlaceholder()){n.updateAvatarInstance(r,d,i)}if(t.getObjectImageURI()||t.getShowPlaceholder()){e.openStart("span").class(l).class("sapUxAPObjectPageHeaderObjectImage-"+d);if(s){e.class("sapUxAPObjectPageHeaderObjectImageForce")}e.openEnd();if(o){e.openStart("span").class("sapUxAPObjectPageHeaderObjectImageContainerSub").openEnd()}if(b){n.updateAvatarInstance(c,d,i);e.openStart("div").class("sapUxAPObjectPageHeaderObjectImage").class("sapUxAPObjectPageHeaderPlaceholder").openEnd()}if(t.getObjectImageURI()){e.renderControl(c)}n._renderPlaceholder(e,r,g);if(b){e.close("div")}if(o){e.close("span")}e.close("span")}};n._renderPlaceholder=function(e,a,t){e.openStart("div").class("sapUxAPObjectPageHeaderPlaceholder").class("sapUxAPObjectPageHeaderObjectImage");if(!t){e.class("sapUxAPHidePlaceholder")}e.openEnd();e.renderControl(a);e.close("div")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageAccessibleLandmarkInfo", ["sap/ui/core/Element","./library"],function(e,a){"use strict";var l=e.extend("sap.uxap.ObjectPageAccessibleLandmarkInfo",{metadata:{library:"sap.uxap",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Main"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},contentLabel:{type:"string",defaultValue:null},navigationRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Navigation"},navigationLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Banner"},headerLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Region"},footerLabel:{type:"string",defaultValue:null},headerContentLabel:{type:"string",defaultValue:null}}}});return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageDynamicHeaderContent", ["./library","./ObjectPageDynamicHeaderContentRenderer","sap/f/DynamicPageHeader"],function(e,t,n){"use strict";var r=n.extend("sap.uxap.ObjectPageDynamicHeaderContent",{metadata:{interfaces:["sap.uxap.IHeaderContent"],library:"sap.uxap"},renderer:t});r.createInstance=function(e,t,n,a,i){return new r({content:e,visible:t,pinnable:a,id:i})};r.prototype.supportsPinUnpin=function(){return true};r.prototype.supportsChildPageDesign=function(){return false};r.prototype.supportsAlwaysExpanded=function(){return false};r.prototype.setContentDesign=function(e){};r.prototype.setVisible=function(e){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoHeaderContent",!e);return this.setProperty("visible",e)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageDynamicHeaderContentRenderer", ["sap/ui/core/Renderer","sap/f/DynamicPageHeaderRenderer"],function(e,r){"use strict";var n=e.extend(r);n.apiVersion=2;return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageDynamicHeaderTitle", ["./library","sap/uxap/ObjectPageDynamicHeaderContent","./ObjectPageDynamicHeaderTitleRenderer","sap/base/Log","sap/f/DynamicPageTitle"],function(e,t,r,n,a){"use strict";var o=a.extend("sap.uxap.ObjectPageDynamicHeaderTitle",{metadata:{interfaces:["sap.uxap.IHeaderTitle"],library:"sap.uxap"},renderer:r});o.prototype.isDynamic=function(){return true};o.prototype.getCompatibleHeaderContentClass=function(){return t};o.prototype.supportsToggleHeaderOnTitleClick=function(){return true};o.prototype.supportsTitleInHeaderContent=function(){return false};o.prototype.supportsAdaptLayoutForDomElement=function(){return false};o.prototype.supportsBackgroundDesign=function(){return true};o.prototype.getTitleText=function(){return this._getTitleText()};o.prototype.getHeaderDesign=function(){return e.ObjectPageHeaderDesign.Light};o.prototype.snap=function(e){this._toggleState(false,e);this._updateARIAState(false)};o.prototype.unSnap=function(e){this._toggleState(true,e);this._updateARIAState(true)};o.prototype._adaptObjectPageHeaderIndentifierLine=function(e,t){};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageDynamicHeaderTitleRenderer", ["sap/ui/core/Renderer","sap/f/DynamicPageTitleRenderer"],function(e,r){"use strict";var i=e.extend(r);i.apiVersion=2;return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeader", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(t,e,jQuery,i,o,n,a,r,s,l,c,u,p,h,g,d,f){"use strict";var _=g.Importance;var y=d.ButtonType;var b=d.PlacementType;var I=g.ObjectPageHeaderDesign;var m=d.AvatarShape;var A=d.AvatarColor;function P(t){return typeof t==="function"}var v=i.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:""},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:m.Square},objectImageBackgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:A.Accent6},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:I.Light,deprecated:true},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink",deprecated:true},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false},titleSelectorTooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"},renderer:f});v.prototype._iAvailablePercentageForActions=.3;v.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=e.getResourceBundleFor("sap.m")}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=e.getResourceBundleFor("sap.uxap")}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this)};v.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs")},aggregation:"links"});v.prototype._handleOverflowButtonPress=function(t){this._oOverflowActionSheet.openBy(this._oOverflowButton)};v.prototype._handleArrowPress=function(t){this.fireTitleSelectorPress({domRef:t.getSource().getDomRef()})};v.prototype._handleLockPress=function(t){this.fireMarkLockedPress({domRef:t.getSource().getDomRef()})};v.prototype._handleChangesPress=function(t){this.fireMarkChangesPress({domRef:t.getSource().getDomRef()})};v._internalAggregationFactory={_objectImage:p.createObjectImage,_placeholder:p.createPlaceholder,_overflowActionSheet:function(){return new u({placement:b.Bottom})},_lockIconCont:function(t){return this._getButton(t,"sap-icon://private","lock-cont",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"))},_breadCrumbs:function(t){return new r({links:t.getAggregation("breadCrumbLinks")})},_lockIcon:function(t){return this._getButton(t,"sap-icon://private","lock",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"))},_titleArrowIconCont:function(t){return this._getButton(t,"sap-icon://slim-arrow-down","titleArrow-cont",t.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"))},_titleArrowIcon:function(t){return this._getButton(t,"sap-icon://slim-arrow-down","titleArrow",t.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"))},_favIcon:function(t){return this._getIcon(t,"favorite",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"))},_flagIcon:function(t){return this._getIcon(t,"flag",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"))},_overflowButton:function(t){return this._getButton(t,"sap-icon://overflow","overflow",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"))},_expandButton:function(t){return this._getButton(t,"sap-icon://slim-arrow-down","expand",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"))},_changesIconCont:function(t){return this._getButton(t,"sap-icon://user-edit","changes-cont",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"))},_changesIcon:function(t){return this._getButton(t,"sap-icon://user-edit","changes",t.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"))},_getIcon:function(t,e,i){return o.createControlByURI({id:this._getParentAugmentedId(t,e),tooltip:i,src:o.getIconURI(e),visible:false})},_getButton:function(t,e,i,o){return new c({id:this._getParentAugmentedId(t,i),tooltip:o,icon:e,type:y.Transparent})},_getParentAugmentedId:function(t,e){return t.getId()+"-"+e}};v.prototype._lazyLoadInternalAggregation=function(t,e){if(!this.getAggregation(t)){this.setAggregation(t,v._internalAggregationFactory[t](this),e)}return this.getAggregation(t)};v.prototype._applyActionProperty=function(t,e){var i=e[0];if(this.getProperty(t)!==i){e.unshift(t);this.setProperty.apply(this,e);if(!this._bFirstRendering){this._notifyParentOfChanges()}}return this};v.prototype._applyObjectImageProperty=function(t,e){var i=e[0];if(this.getProperty(t)!==i){e.unshift(t);this.setProperty.apply(this,e);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true)}}return this};v.prototype._setAggregationTooltip=function(t,e){var i=this.getAggregation(t);if(i){i.setTooltip(e)}return this};v.prototype._setTitleSelectorTooltip=function(t){if(t===null||t===undefined){t=this.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP")}this._setAggregationTooltip("_titleArrowIcon",t);this._setAggregationTooltip("_titleArrowIconCont",t);return this};v.prototype.setHeaderDesign=function(t){this.setProperty("headerDesign",t);if(this.getParent()){this.getParent().invalidate()}return this};v.prototype.setObjectTitle=function(t){var e=this.getParent(),i=this.getProperty("objectTitle"),o=i!==t;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));e&&P(e._updateAriaLabels)&&e._updateAriaLabels();if(o&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{id:this.getId(),name:"objectTitle",oldValue:i,newValue:t})}return this};var O=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],T=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape","objectImageBackgroundColor"];var B=function(t){var e="set"+t.charAt(0).toUpperCase()+t.slice(1);v.prototype[e]=function(){var e=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,t,e);return this}};var L=function(t){var e="set"+t.charAt(0).toUpperCase()+t.slice(1);v.prototype[e]=function(){var e=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,t,e);return this}};var w=function(t,e,i){var o="set"+t.charAt(0).toUpperCase()+t.slice(1);e[o]=function(){var e=Array.prototype.slice.call(arguments);e.unshift(t);i.setProperty.apply(i,e);return this.setProperty.apply(this,e)}};O.forEach(B);T.forEach(L);v.prototype._destroyObjectImage=function(){var t="_objectImage",e=this.getAggregation(t);if(e){e.destroy();this.setAggregation(t,null)}};v.prototype.onBeforeRendering=function(){var t=this.getSideContentButton(),e=this;if(t&&!t.getTooltip()){t.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"))}var i=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._resetActionSheetMap();if(i.length>1||this._hasOneButtonShowText(i)){i.forEach(function(t){if(t instanceof c&&!(t instanceof s)){t._bInternalVisible=t.getVisible();t._getInternalVisible=function(){return this._bInternalVisible};t._setInternalVisible=function(t,e){this.$().toggle(t);if(t!=this._bInternalVisible){this._bInternalVisible=t;if(e){this.invalidate()}}};t.setVisible=function(i){t._setInternalVisible(i,true);c.prototype.setVisible.call(this,i);e._adaptLayout()};t.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide()}e._resizeIdentifierLineContainer(e.$())}}if(t instanceof c&&t.getVisible()){var i=this._createActionSheetButton(t);this._oActionSheetButtonMap[t.getId()]=i;this._oOverflowActionSheet.addButton(i);w("text",t,i);w("icon",t,i);w("enabled",t,i);w("type",t,i)}},this)}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){l.deregister(this._iResizeId);this._iResizeId=null}this._bFirstRendering=false};v.prototype._resetActionSheetMap=function(){Object.keys(this._oActionSheetButtonMap).forEach(function(t){this._oActionSheetButtonMap[t].destroy()}.bind(this));this._oActionSheetButtonMap={}};v.prototype._createActionSheetButton=function(t){return new c({press:jQuery.proxy(this._onSeeMoreContentSelect,this),enabled:t.getEnabled(),text:t.getText(),icon:t.getIcon(),type:t.getType(),tooltip:t.getTooltip(),customData:new n({key:"originalId",value:t.getId()})})};v.prototype._handleImageNotFoundError=function(){var t=this._lazyLoadInternalAggregation("_objectImage"),e=this.getParent(),i=e?e.$():this.$();if(this.getShowPlaceholder()){i.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();i.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder")}else{t.addStyleClass("sapMNoImg")}};v.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error")};v.prototype.onAfterRendering=function(){var t=this._lazyLoadInternalAggregation("_objectImage").$();if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout)}this._adaptLayout();this._clearImageNotFoundHandler();t.on("error",this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError()}if(!this._iResizeId){this._iResizeId=l.register(this,this._onHeaderResize.bind(this))}this._attachDetachActionButtonsHandler(true)};v.prototype._onHeaderResize=function(t){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._onUpdateHeaderTitleSize==="function"){this.getParent()._onUpdateHeaderTitleSize(t)}};v.prototype._attachDetachActionButtonsHandler=function(t){var e=this.getActions()||[];if(e.length<1){return}e.forEach(function(e){if(e instanceof c){var i=this._oActionSheetButtonMap[e.getId()];if(t){e.attachEvent("_change",this._adaptLayoutDelayed,this);if(i){i.attachEvent("_change",this._adaptOverflow,this)}}else{e.detachEvent("_change",this._adaptLayoutDelayed,this);if(i){i.detachEvent("_change",this._adaptOverflow,this)}}}},this)};v.prototype._onSeeMoreContentSelect=function(e){var i=e.getSource(),o=t.getElementById(i.data("originalId"));if(o.firePress){o.firePress({overflowButtonId:this._oOverflowButton.getId(),bInOverflow:true})}this._oOverflowActionSheet.close()};v._actionImportanceMap={Low:3,Medium:2,High:1};v._sortActionsByImportance=function(t,e){var i=t instanceof s?t.getImportance():_.High,o=e instanceof s?e.getImportance():_.High,n=v._actionImportanceMap[i]-v._actionImportanceMap[o];if(n===0){return t.position-e.position}return n};v.prototype._hasOneButtonShowText=function(t){var e=false;if(t.length!==1){return e}if(t[0]instanceof s){e=!t[0].getHideText()&&t[0].getText()!=""}else if(t[0]instanceof c){e=t[0].getText()!=""}return e};v.prototype._adaptLayout=function(t){var e=this.$("identifierLine"),i=e.width(),o=this._getActionsWidth(),n=o/i,r=this._iAvailablePercentageForActions*i,l=this._oOverflowButton.$();if(i===0){return}if(n>this._iAvailablePercentageForActions){this._adaptActions(r)}else if(t&&t.getSource()instanceof s){t.getSource()._setInternalVisible(true)}if(a.system.phone){this.getActions().forEach(function(t){if(t instanceof c){t.$().css("visibility","visible")}})}var u=this.$("actions");var p=u.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(p.filter(":visible").length===p.length){l.hide()}this._adaptObjectPageHeaderIndentifierLine(this.$())};v.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout)}this._adaptLayoutTimeout=setTimeout(function(){this._adaptLayoutTimeout=null;this._adaptLayout()}.bind(this),0)};v.prototype._adaptObjectPageHeaderIndentifierLine=function(t){var e=this._findById(t,"identifierLine"),i=e.find(".sapUxAPObjectPageHeaderIdentifierTitle");this._adaptObjectPageHeaderTitle(i);this._resizeIdentifierLineContainer(t)};v.prototype._resizeIdentifierLineContainer=function(t){var e=this._findById(t,"identifierLineContainer"),i=this._findById(t,"actions"),o=this._findById(t,"identifierLine"),n=o.width(),a=t?t.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),r=i.width()+a.width();e.width((.95-r/n)*100+"%")};v.prototype._adaptObjectPageHeaderTitle=function(t){var e=t.width(),i=t.find(".sapUxAPObjectPageHeaderTitleText"),o=i.length,n;for(var a=0;a<o;a++){n=jQuery(i.get(a));n.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",false);if(n.width()>e){n.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",true)}}};v.prototype._adaptActions=function(t){var e=g.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||a.system.phone,i=this._oOverflowButton.$(),o=i.show().width(),n=this.getActions(),r=n.length,s;for(var l=0;l<r;l++){n[l].position=l}n.sort(v._sortActionsByImportance);n.forEach(function(n){s=this._oActionSheetButtonMap[n.getId()];if(s){o+=n.$().width();if(t>o&&!e){this._setActionButtonVisibility(n,true);i.hide()}else{this._setActionButtonVisibility(n,false);i.show()}}},this)};v.prototype._adaptOverflow=function(t){if(t.getParameter("name")!=="visible"){return}var e=this._oOverflowActionSheet.getButtons();var i=e.some(function(t){return t.getVisible()});this._oOverflowButton.$().toggle(i)};v.prototype._setActionButtonVisibility=function(t,e){var i=this._oActionSheetButtonMap[t.getId()];if(i){if(t.getVisible()){t._setInternalVisible(e);i.setVisible(!e)}else{i.setVisible(false)}}};v.prototype._getActionsWidth=function(){var t=0;this.getActions().forEach(function(e){if(e instanceof c){e.$().show();if(a.system.phone){e.$().css("visibility","hidden")}t+=e.$().outerWidth(true)}});return t};v.prototype._findById=function(t,e){var i;if(!e||!t){return null}e=this.getId()+"-"+e;i="#"+e.replace(/(:|\.)/g,"\\$1");return t.find(i)};v.prototype._getBreadcrumbsAggregation=function(){var t=this.getBreadcrumbs(),e=this._lazyLoadInternalAggregation("_breadCrumbs",true);return t||(e&&e.getLinks().length?e:null)};v.prototype._notifyParentOfChanges=function(t){var e=this.getParent();if(e&&typeof e._headerTitleChangeHandler==="function"){e._headerTitleChangeHandler(t)}};v.prototype.setTitleSelectorTooltip=function(t){this._setTitleSelectorTooltip(t);this.setAggregation("titleSelectorTooltip",t,true);return this};v.prototype.destroyTitleSelectorTooltip=function(){this._setTitleSelectorTooltip(null);this.destroyAggregation("titleSelectorTooltip",true);return this};v.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){l.deregister(this._iResizeId);this._iResizeId=null}this._resetActionSheetMap()};v.prototype.setNavigationBar=function(t){this.setAggregation("navigationBar",t);if(t&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{parent:this,adaptableContent:t})}return this};v.prototype._getAdaptableContent=function(){return this.getNavigationBar()};v.prototype.isDynamic=function(){return false};v.prototype.getCompatibleHeaderContentClass=function(){return h};v.prototype.supportsToggleHeaderOnTitleClick=function(){return false};v.prototype.supportsTitleInHeaderContent=function(){return true};v.prototype.supportsAdaptLayoutForDomElement=function(){return true};v.prototype.supportsBackgroundDesign=function(){return false};v.prototype.getTitleText=function(){return this.getObjectTitle()};v.prototype.snap=function(){this._adaptLayout()};v.prototype.unSnap=function(){this._adaptLayout()};v.prototype._toggleExpandButton=function(t){};v.prototype._setShowExpandButton=function(t){};v.prototype._focusExpandButton=function(){};v.prototype._toggleFocusableState=function(t){};return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderActionButton", ["sap/m/Button","./library","./ObjectPageHeaderActionButtonRenderer"],function(e,t,n){"use strict";var i=e.extend("sap.uxap.ObjectPageHeaderActionButton",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.uxap",properties:{hideText:{type:"boolean",defaultValue:true},hideIcon:{type:"boolean",defaultValue:false},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:t.Importance.High}},designtime:"sap/uxap/designtime/ObjectPageHeaderActionButton.designtime"},renderer:n});i.prototype.init=function(){e.prototype.init.call(this);this._bInternalVisible=this.getVisible();this._bInternalHiddenText=this.getHideText()};i.prototype.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide()}};i.prototype._getText=function(){if(this._bInternalHiddenText&&this.getHideText()){return""}return this.getText()};i.prototype.setHideText=function(e,t){this.setProperty("hideText",e,t);this._bInternalHiddenText=e;return this};i.prototype.setHideIcon=function(e,t){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",e);return this.setProperty("hideIcon",e,t)};i.prototype._setInternalVisible=function(e,t){this.$().toggle(e);if(e!=this._bInternalVisible){this._bInternalVisible=e;if(t){this.invalidate()}}};i.prototype.setVisible=function(t){var n=e.prototype.setVisible.apply(this,arguments);this.getParent()&&this.getParent().invalidate();return n};i.prototype._getInternalVisible=function(){return this._bInternalVisible};i.prototype.getOverflowToolbarConfig=function(){var e={canOverflow:true,propsUnrelatedToSize:["importance"],getCustomImportance:function(){return this.getImportance()}.bind(this)};e.onBeforeEnterOverflow=function(e){e._bInternalHiddenText=false;e.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",false,true)};e.onAfterExitOverflow=function(e){e._bInternalHiddenText=e.getHideText();e.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",e.getHideIcon(),true)};return e};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderActionButtonRenderer", ["sap/m/ButtonRenderer","sap/ui/core/Renderer"],function(e,r){"use strict";var n=r.extend(e);n.apiVersion=2;return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderContent", ["sap/ui/core/Control","./library","sap/m/Button","./ObjectImageHelper","./ObjectPageHeaderContentRenderer","sap/ui/core/Lib"],function(e,t,a,r,o,n){"use strict";var i=t.ObjectPageHeaderDesign;var g=e.extend("sap.uxap.ObjectPageHeaderContent",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderContent"],properties:{contentDesign:{type:"sap.uxap.ObjectPageHeaderDesign",group:"Misc",defaultValue:i.Light,deprecated:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editHeaderButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}}},renderer:o});g.prototype.onBeforeRendering=function(){var e=this.getParent(),t=this.getAggregation("_editHeaderButton");if(t){return}if(e&&e.isA("sap.uxap.ObjectPageLayout")&&e.getShowEditHeaderButton()){t=this._getInternalBtnAggregation("_editHeaderButton","EDIT_HEADER","-editHeaderBtn","Transparent");t.attachPress(this._handleEditHeaderButtonPress,this)}};g.prototype.exit=function(){var e=this.getAggregation("_editHeaderButton");if(e){e.detachPress(this._handleEditHeaderButtonPress,this)}};g.prototype._handleEditHeaderButtonPress=function(e){this.getParent().fireEditHeaderButtonPress()};g.prototype._getInternalBtnAggregation=function(e,t,r,o){if(!this.getAggregation(e)){var i=new a({text:n.getResourceBundleFor("sap.uxap").getText(t),type:o,id:this.getId()+r});this.setAggregation(e,i)}return this.getAggregation(e)};g.prototype._getObjectImage=function(){if(!this.getAggregation("_objectImage")){var e=this.getParent(),t=e&&e.getHeaderTitle&&e.getHeaderTitle(),a=t&&r.createObjectImage(t);if(a){this.setAggregation("_objectImage",a,true)}}return this.getAggregation("_objectImage")};g.prototype._destroyObjectImage=function(e){var t=this.getAggregation("_objectImage");if(t){t.destroy();this.getAggregation("_objectImage",null,e)}};g.prototype._getPlaceholder=function(){if(!this.getAggregation("_placeholder")){var e=this.getParent(),t=e&&e.getHeaderTitle&&e.getHeaderTitle(),a=t.getShowPlaceholder();var o=a&&r.createPlaceholder();if(o){this.setAggregation("_placeholder",o,true)}}return this.getAggregation("_placeholder")};g.prototype._getLayoutDataForControl=function(e){var t=e.getLayoutData();if(!t){return}else if(t.isA("sap.uxap.ObjectPageHeaderLayoutData")){return t}else if(t.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var a=t.getMultipleLayoutData();for(var r=0;r<a.length;r++){var o=a[r];if(o.isA("sap.uxap.ObjectPageHeaderLayoutData")){return o}}}};g.prototype.setVisible=function(e){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoHeaderContent",!e);return this.setProperty("visible",e)};g.createInstance=function(e,t,a,r,o){return new g({content:e,visible:t,id:o})};g.prototype.supportsPinUnpin=function(){return false};g.prototype.supportsChildPageDesign=function(){return true};g.prototype.supportsAlwaysExpanded=function(){return true};g.prototype._toggleCollapseButton=function(e){};g.prototype._setShowCollapseButton=function(e){};g.prototype._focusCollapseButton=function(){};g.prototype._focusPinButton=function(){};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderContentRenderer", ["./ObjectPageHeaderRenderer","./ObjectImageHelper"],function(e,t){"use strict";var a={apiVersion:2};a.render=function(e,t){var a=t.getParent(),n=a&&a.isA("sap.uxap.ObjectPageLayout"),s=a&&n?a.getHeaderTitle():undefined,r=a&&n?a.isA("sap.uxap.ObjectPageLayout")&&a.getShowTitleInHeaderContent():false,o=n&&a.getShowEditHeaderButton()&&t.getContent()&&t.getContent().length>0;if(o){e.openStart("div",t).class("sapUxAPObjectPageHeaderContentFlexBox");e.class("sapUxAPObjectPageHeaderContentDesign-"+t.getContentDesign());if(s){e.class("sapUxAPObjectPageContentObjectImage-"+s.getObjectImageShape())}e.openEnd()}e.openStart("div",o?undefined:t);if(o){e.class("sapUxAPObjectPageHeaderContentCellLeft")}else{e.class("sapUxAPObjectPageHeaderContentDesign-"+t.getContentDesign());if(s){e.class("sapUxAPObjectPageContentObjectImage-"+s.getObjectImageShape())}}e.class("sapContrastPlus").class("ui-helper-clearfix").class("sapUxAPObjectPageHeaderContent");if(!t.getVisible()){e.class("sapUxAPObjectPageHeaderContentHidden")}e.openEnd();if(n&&a.getIsChildPage()){e.openStart("div").class("sapUxAPObjectChildPage").openEnd().close("div")}if(r){this._renderTitleImage(e,t,s);if(t.getContent().length==0){e.openStart("span").class("sapUxAPObjectPageHeaderContentItem").openEnd();this._renderTitle(e,s);e.close("span")}}t.getContent().forEach(function(a,n){this._renderHeaderContentItem(a,n,e,r,s,t)},this);e.close("div");if(o){this._renderEditButton(e,t);e.close("div")}};a._renderHeaderContentItem=function(e,t,a,n,s,r){var o=false,i=false,d=r._getLayoutDataForControl(e),l=t===0;if(d){o=d.getShowSeparatorBefore();i=d.getShowSeparatorAfter();a.openStart("span").class("sapUxAPObjectPageHeaderWidthContainer").class("sapUxAPObjectPageHeaderContentItem").style("width",d.getWidth());if(i||o){a.class("sapUxAPObjectPageHeaderSeparatorContainer")}if(!d.getVisibleL()){a.class("sapUxAPObjectPageHeaderLayoutHiddenL")}if(!d.getVisibleM()){a.class("sapUxAPObjectPageHeaderLayoutHiddenM")}if(!d.getVisibleS()){a.class("sapUxAPObjectPageHeaderLayoutHiddenS")}a.openEnd();if(o){a.openStart("span").class("sapUxAPObjectPageHeaderSeparatorBefore").openEnd().close("span")}if(l&&n){this._renderTitle(a,s)}}else{if(l&&n){a.openStart("span").class("sapUxAPObjectPageHeaderContentItem").openEnd();this._renderTitle(a,s)}else{e.addStyleClass("sapUxAPObjectPageHeaderContentItem")}}a.renderControl(e);if(i){a.openStart("span").class("sapUxAPObjectPageHeaderSeparatorAfter").openEnd().close("span")}if(d||l&&n){a.close("span")}};a._renderTitleImage=function(e,a,n){t._renderImageAndPlaceholder(e,{oHeader:n,oObjectImage:a._getObjectImage(),oPlaceholder:a._getPlaceholder(),bIsObjectIconAlwaysVisible:false,bAddSubContainer:false,sBaseClass:"sapUxAPObjectPageHeaderContentImageContainer"})};a._renderTitle=function(t,a){e._renderObjectPageTitle(t,a,true)};a._renderEditButton=function(e,t){e.openStart("div").class("sapUxAPObjectPageHeaderContentCellRight").openEnd();e.renderControl(t.getAggregation("_editHeaderButton"));e.close("div")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderLayoutData", ["sap/ui/core/LayoutData","./library"],function(e,a){"use strict";var t=e.extend("sap.uxap.ObjectPageHeaderLayoutData",{metadata:{library:"sap.uxap",properties:{visibleS:{type:"boolean",group:"Misc",defaultValue:true},visibleM:{type:"boolean",group:"Misc",defaultValue:true},visibleL:{type:"boolean",group:"Misc",defaultValue:true},showSeparatorBefore:{type:"boolean",group:"Misc",defaultValue:false},showSeparatorAfter:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"}}}});
/*!
	 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
	 */return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageHeaderRenderer", ["./ObjectImageHelper","sap/ui/Device"],function(e,t){"use strict";var a={apiVersion:2};a.render=function(a,r){var n=r.getNavigationBar(),s=r.getIsObjectIconAlwaysVisible()||r.getIsObjectTitleAlwaysVisible()||r.getIsObjectSubtitleAlwaysVisible()||r.getIsActionAreaAlwaysVisible(),o=r.getParent(),i=r.getAggregation("_expandButton"),l=r._lazyLoadInternalAggregation("_objectImage",true),c,d=t.system.desktop,g=o&&o.isA("sap.uxap.ObjectPageLayout")&&(o.getHeaderContent()&&o.getHeaderContent().length>0&&o.getShowHeaderContent()||o.getShowHeaderContent()&&o.getShowTitleInHeaderContent());a.openStart("div",r).class("sapUxAPObjectPageHeader");a.class("sapUxAPObjectPageHeaderDesign-"+r.getHeaderDesign());a.openEnd();if(n){a.openStart("div").class("sapUxAPObjectPageHeaderNavigation").openEnd();a.renderControl(n);a.close("div")}a.openStart("div",r.getId()+"-identifierLine").class("sapUxAPObjectPageHeaderIdentifier");if(s){a.class("sapUxAPObjectPageHeaderIdentifierForce")}a.openEnd();if(o&&o.isA("sap.uxap.ObjectPageLayout")&&o.getIsChildPage()){a.openStart("div").class("sapUxAPObjectChildPage").openEnd().close("div")}if(r.getShowPlaceholder()){c=r._lazyLoadInternalAggregation("_placeholder",true)}e._renderImageAndPlaceholder(a,{oHeader:r,oObjectImage:l,oPlaceholder:c,bIsObjectIconAlwaysVisible:r.getIsObjectIconAlwaysVisible(),bAddSubContainer:true,sBaseClass:"sapUxAPObjectPageHeaderObjectImageContainer"});a.openStart("span",r.getId()+"-identifierLineContainer").class("sapUxAPObjectPageHeaderIdentifierContainer").openEnd();this._renderObjectPageTitle(a,r);a.close("span");a.openStart("span",r.getId()+"-actions").class("sapUxAPObjectPageHeaderIdentifierActions");if(r.getIsActionAreaAlwaysVisible()){a.class("sapUxAPObjectPageHeaderIdentifierActionsForce")}a.openEnd();if(d&&g){i.addStyleClass("sapUxAPObjectPageHeaderExpandButton");a.renderControl(i)}var p=r.getActions();for(var b=0;b<p.length;b++){var A=p[b];a.renderControl(A)}var P=r.getAggregation("_overflowButton");a.renderControl(P);this._renderSideContentBtn(a,r);a.close("span");a.close("div");a.close("div")};a._renderObjectPageTitle=function(e,t,a){var r=t.getObjectTitle(),n=t.getShowMarkers()&&(t.getMarkFavorite()||t.getMarkFlagged()),s=t._getBreadcrumbsAggregation(),o=t.getTooltip_Text(),i=a?"-content":"";if(!a&&s){e.renderControl(s)}e.openStart("h2",t.getId()+"-title"+i).class("sapUxAPObjectPageHeaderIdentifierTitle");if(t.getIsObjectTitleAlwaysVisible()){e.class("sapUxAPObjectPageHeaderIdentifierTitleForce")}if(a){e.class("sapUxAPObjectPageHeaderIdentifierTitleInContent")}if(t.getShowTitleSelector()){e.class("sapUxAPObjectPageHeaderTitleFollowArrow")}e.openEnd();e.openStart("span",t.getId()+"-innerTitle"+i).class("sapUxAPObjectPageHeaderTitleText").class("sapUxAPObjectPageHeaderTitleTextWrappable");if(o){e.attr("title",o)}e.openEnd();if(n||t.getShowTitleSelector()||t.getMarkLocked()||t.getMarkChanges()){var l=r.substr(r.lastIndexOf(" ")+1);var c=r.substr(0,r.lastIndexOf(" ")+1);if(l.length===1){l=r;c=""}e.text(c);e.close("span");e.openStart("span").class("sapUxAPObjectPageHeaderNowrapMarkers");if(t.getMarkLocked()||t.getMarkChanges()){e.class("sapUxAPObjectPageHeaderMarks")}e.openEnd();e.openStart("span").class("sapUxAPObjectPageHeaderTitleText").openEnd().text(l).close("span");this._renderMarkers(e,t);if(t.getMarkLocked()){this._renderLock(e,t,a)}else if(t.getMarkChanges()){this._renderMarkChanges(e,t,a)}this._renderSelectTitleArrow(e,t,a);e.close("span")}else{e.text(r);e.close("span")}e.close("h2");if(t.getObjectSubtitle()){e.openStart("div",t.getId()+"-subtitle"+i).class("sapUxAPObjectPageHeaderIdentifierDescription");if(t.getIsObjectSubtitleAlwaysVisible()){e.class("sapUxAPObjectPageHeaderIdentifierDescriptionForce")}if(a){e.class("sapUxAPObjectPageHeaderIdentifierSubTitleInContent")}e.openEnd();e.text(t.getObjectSubtitle());e.close("div")}};a._renderSelectTitleArrow=function(e,t,a){if(t.getShowTitleSelector()){e.openStart("span").class("sapUxAPObjectPageHeaderTitleArrow").openEnd();if(a){e.renderControl(t._oTitleArrowIconCont)}else{e.renderControl(t._oTitleArrowIcon)}e.close("span")}};a._renderSideContentBtn=function(e,t){var a=t.getSideContentButton();if(a){e.openStart("span");e.class("sapUxAPObjectPageHeaderSideContentBtn");e.openEnd();e.openStart("span").class("sapUxAPObjectPageHeaderSeparator").openEnd().close("span");e.renderControl(a);e.close("span")}};a._renderMarkChanges=function(e,t,a){e.openStart("span").class("sapUxAPObjectPageHeaderChangesBtn").class("sapUiSizeCompact").openEnd();if(a){e.renderControl(t._oChangesIconCont)}else{e.renderControl(t._oChangesIcon)}e.close("span")};a._renderLock=function(e,t,a){e.openStart("span").class("sapUxAPObjectPageHeaderLockBtn").class("sapUiSizeCompact").openEnd();if(a){e.renderControl(t._oLockIconCont)}else{e.renderControl(t._oLockIcon)}e.close("span")};a._renderMarkers=function(e,t){var a=[];if(t.getShowMarkers()){a.push(t._oFavIcon);a.push(t._oFlagIcon);this._renderMarkersAria(e,t);e.openStart("span",t.getId()+"-markers").class("sapMObjStatusMarker").attr("aria-describedby",t.getId()+"-markers-aria").openEnd();for(var r=0;r<a.length;r++){e.renderControl(a[r])}e.close("span")}};a._renderMarkersAria=function(e,t){var a="";if(t.getMarkFlagged()){a+=t.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE")+" "}if(t.getMarkFavorite()){a+=t.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE")+" "}if(a!==""){e.openStart("div",t.getId()+"-markers-aria").attr("aria-hidden","false").class("sapUiHidden").openEnd().text(a).close("div")}};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageLayout", ["sap/base/i18n/Localization","sap/ui/core/AnimationMode","sap/ui/core/ControlBehavior","sap/ui/core/Element","sap/ui/core/EventBus","sap/ui/core/Lib","sap/ui/core/RenderManager","sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/dom/getFirstEditableInput","sap/ui/dom/units/Rem","sap/ui/base/Object"],function(e,t,i,o,n,r,s,jQuery,a,l,h,c,d,g,u,_,p,S,f,b,y,T,H,A,C,I,P,B,E,v,L,O,m,R,D,V){"use strict";var x=A.TitleLevel;var F=A.AccessibleLandmarkRole;var $=C.ObjectPageSubSectionLayout;var j=["toggleAnchorBar","_moveHeader"];var M=c.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:$.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:x.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},headerContentPinned:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"}},events:{headerContentPinnedStateChange:{parameters:{pinned:{type:"boolean"}}},toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},beforeNavigate:{allowPreventDefault:true,parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"},renderer:I});M.HEADER_CALC_DELAY=350;M.DOM_CALC_DELAY=200;M.MAX_SNAP_POSITION_OFFSET=20;M.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=.6;M.TITLE_LEVEL_AS_ARRAY=Object.keys(x);M.SCROLLBAR_SIZE_FF=12;M.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};M.MEDIA_RANGESET_NAME="ObjectPageRangeSet";M.BREAK_POINTS={DESKTOP:1439,TABLET:1024,PHONE:600};M.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop",DESKTOP_XL:"sapUxAPObjectPageLayout-Std-Desktop-XL"};M.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop",DESKTOP_XL:"sapFDynamicPage-Std-Desktop-XL"};M.DIV="div";M.HEADER="header";M.FOOTER="section";M.HEADER_CONTENT_PADDING_BOTTOM=D.toPx("1rem");M.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";M.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";M.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";M.ARIA={LABEL_TOOLBAR_FOOTER_ACTIONS:"ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS"};M.prototype._getFirstEditableInput=function(e){var t=this.getDomRef(e);return R(t)};M.prototype._focusFirstEditableInput=function(e){this._getFirstEditableInput(e).focus()};M._getNextTitleLevelEntry=function(e){var t=M.TITLE_LEVEL_AS_ARRAY.indexOf(e),i=t!==-1,o=i&&t!==M.TITLE_LEVEL_AS_ARRAY.length-1;if(!i){return x.Auto}return M.TITLE_LEVEL_AS_ARRAY[o?t+1:t]};M._getLibraryResourceBundle=function(){return r.getResourceBundleFor("sap.uxap")};M.prototype.init=function(){this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._initialABButtonsColorUpdateDone=false;this._bDomElementsCached=false;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iOffset=parseInt(.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new T(this);this._initializeScroller();this._attachSnapListeners();this._initRangeSet();this._attachMediaContainerWidthChange(this._onMediaRangeChange,this,M.MEDIA_RANGESET_NAME);this._oHeaderContentDelegate={onBeforeRendering:this._setSectionInfoIsDirty.bind(this,true)}};M.prototype.onBeforeRendering=function(){var e,t;this._deregisterScreenSizeListener();this._deregisterTitleSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy()}this._oLazyLoading=new y(this);this._deregisterCustomEvents();if(!this.getVisible()){return}if(!this.getSelectedSection()){this._bHeaderExpanded=true}this._bMobileScenario=C.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=C.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().toggleStyleClass("sapUxAPAnchorBarUpperCase",this.getUpperCaseAnchorBar());this._storeScrollLocation();this._applyUxRules();if(!L(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false}this._bStickyAnchorBar=this._shouldPreserveHeaderInTitleArea();this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();e=this._getHeaderContent();if(e&&e.supportsPinUnpin()){t=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(t);if(t){this._attachPinPressHandler()}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(g.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this)}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter())}this._$titleArea=[];this._setFooterAriaLabelledBy()};M.prototype._setFooterAriaLabelledBy=function(){var e=this.getFooter();if(e&&!e.getAriaLabelledBy().length){this._oInvisibleText=new d({id:e.getId()+"-FooterActions-InvisibleText",text:M._getLibraryResourceBundle().getText(M.ARIA.LABEL_TOOLBAR_FOOTER_ACTIONS)}).toStatic();e.addAriaLabelledBy(this._oInvisibleText)}};M.prototype._destroyInvisibleText=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};M.prototype.setBackgroundDesignAnchorBar=function(e){var t=this.getBackgroundDesignAnchorBar();if(t===e){return this}this.setProperty("backgroundDesignAnchorBar",e);this._oABHelper._getAnchorBar().setBackgroundDesign(e);return this};M.prototype.setToggleHeaderOnTitleClick=function(e){var t=this.getHeaderTitle(),i=this.setProperty("toggleHeaderOnTitleClick",e,true);if(!t||!t.supportsToggleHeaderOnTitleClick()){P.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return i}e=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return i};M.prototype._attachTitlePressHandler=function(){var e=this.getHeaderTitle();if(k(e)&&!this._bAlreadyAttachedTitlePressHandler){e.attachEvent(M.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true}};M.prototype._attachSnapListeners=function(){j.forEach(function(e){this.attachEvent(e,function(){this.fireEvent("_snapChange")})},this)};M.prototype._toggleHeaderVisibility=function(e){var t=this._getHeaderContent();if(k(t)){t.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!e)}};M.prototype._snapHeader=function(e,t){var i,o=this._getHeaderContent();if(o&&o.supportsPinUnpin()&&this._bPinned){this._unPin(t);o._togglePinButton(false);e=true}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(e);this._moveAnchorBarToTitleArea();if(e){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);i=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1;if(i){this._scrollTo(this._getSnapPosition()+1)}return}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout()};M.prototype._expandHeader=function(e){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(e){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0);this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea())}};M.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return}var e=!this._bHeaderExpanded,t,i,o;if(e){t=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1;i=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!t);this._expandHeader(i);if(!i){this._scrollTo(0,0)}}else{o=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(o,true)}this.getHeaderTitle()._getFocusSpan().trigger("focus")};M.prototype._attachPinPressHandler=function(){var e=this._getHeaderContent();if(k(e)&&!this._bAlreadyAttachedPinPressHandler){e.attachEvent(M.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true}};M.prototype._handleExpandButtonPressEventLifeCycle=function(e){var t=this.getHeaderTitle(),i=this._hasDynamicTitle(),o;if(t&&!i){o=t.getAggregation("_expandButton");if(o){o[e?"attachPress":"detachPress"](this._handleExpandButtonPress,this)}}};M.prototype._adjustSelectedSectionByUXRules=function(){var e=o.getElementById(this.getSelectedSection()),t=e&&this._sectionCanBeRenderedByUXRules(e);if(!t){if(this._oFirstVisibleSection){e=this._oFirstVisibleSection;this.setAssociation("selectedSection",e.getId(),true)}else{this.setAssociation("selectedSection",null,true);return}}};M.prototype._sectionCanBeRenderedByUXRules=function(e){if(!(e instanceof p)){return false}var t=e.getBindingInfo("subSections");if(!t&&(!e.getVisible()||!e._getInternalVisible())){return false}var i=this._aSectionBases.map(function(e){return e.getId()});return i.indexOf(e.getId())>-1};M.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var e=o.getElementById(this.getSelectedSection());if(this.getUseIconTabBar()&&e){return[e]}else{return this.getSections()}};M.prototype._preloadSectionsOnBeforeFirstRendering=function(){var e=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(e).then(function(){if(this.getEnableLazyLoading()){e.forEach(function(e){this.fireEvent("subSectionPreload",{subSection:e})},this)}}.bind(this))};M.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var e,t,i;if(!this.getEnableLazyLoading()){return this._getSectionsToRender()}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases())}this._adjustSelectedSectionByUXRules();t=o.getElementById(this.getSelectedSection());if(!t||t===this._oFirstVisibleSection){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases)}i=this.indexOfSection(t);var n=function(e){var t=e.isA("sap.uxap.ObjectPageSection")?e:e.getParent();return this.indexOfSection(t)>=i}.bind(this);e=this._aSectionBases.filter(n);return this._oLazyLoading.getSubsectionsToPreload(e)};M.prototype._grepCurrentTabSectionBases=function(){var e=[],t,i,n,r;this._adjustSelectedSectionByUXRules();t=o.getElementById(this.getSelectedSection());if(t){i=t.getId();this._aSectionBases.forEach(function(t){n=t.getParent();r=n&&n.getId();if(t.getId()===i||r===i){e.push(t)}})}return e};M.prototype.onAfterRendering=function(){var e=this._getHeaderContent(),t=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._ensureCorrectParentHeight();this._cacheDomElements();this._iResizeId=l.register(this,this._onUpdateScreenSize.bind(this));this._iTitleResizeId=l.register(this._$titleArea.get(0),this._adjustTitlePositioning.bind(this));if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle")}if(t>0){this._updateMedia(t,M.MEDIA)}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady()}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout)}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());this._adjustTitlePositioning()}if(e&&e.supportsPinUnpin()){this._updatePinButtonState()}this._handleExpandButtonPressEventLifeCycle(true);if(k(e)&&e._setLandmarkInfo){e._setLandmarkInfo(this.getLandmarkInfo())}};M.prototype._onAfterRenderingDomReady=function(){var e,t,i,r,s=this._getWidth(this);if(this._bIsBeingDestroyed){return}this._adjustSelectedSectionByUXRules();e=this.getSelectedSection();t=o.getElementById(e);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(e){if(this.getUseIconTabBar()){this._setSelectedSectionId(e);this._setCurrentTabSection(t);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(t);this._checkSubSectionVisibilityChange()}else{r=t?.getSelectedSubSection();this.scrollToSection(r||e,0)}}this._toggleScrolling(this._shouldAllowScrolling());this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}if(!this._bHeaderExpanded){i=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(i)}this._restoreScrollPosition();n.getInstance().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(s,M.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(s,M.DYNAMIC_HEADERS_MEDIA)}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady")};M.prototype.onfocusfail=function(e){var t=e.srcControl;if(t===this.getAggregation("footer")&&!t.getVisible()){return}c.prototype.onfocusfail.apply(this,arguments)};M.prototype._toggleScrolling=function(e){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=e?"auto":"hidden"}};M.prototype._shouldAllowScrolling=function(){return!this._bAllContentFitsContainer||!this._getFirstVisibleSubSection()?._hasRestrictedHeight()};M.prototype._shiftFooter=function(){var e=this.$("footerWrapper"),t=this._calculateShiftOffset();e.css(t.sStyleAttribute,t.iMarginalsOffset+"px")};M.prototype._calculateShiftOffset=function(){var t=0,i=e.getRTL()?"left":"right",o=this._hasVerticalScrollBar(),n=this._iOffset,r;if(g.system.desktop){r=g.browser.firefox?M.SCROLLBAR_SIZE_FF:E().width;t=r;if(!o){t=0;n+=r}}return{sStyleAttribute:i,iActionsOffset:n,iMarginalsOffset:t}};M.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?M.HEADER_CALC_DELAY:0};M.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null}if(this._asyncUpdateScreenSizeExec){clearTimeout(this._asyncUpdateScreenSizeExec)}this._destroyInvisibleText();this._deregisterScreenSizeListener();this._deregisterTitleSizeListener();if(this._iContentResizeId){l.deregister(this._iContentResizeId)}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout)}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null};M.prototype.setShowOnlyHighImportance=function(e){var t=this.getShowOnlyHighImportance();if(t!==e){this.setProperty("showOnlyHighImportance",e,true);this.getSections().forEach(function(e){e._updateImportance()})}return this};M.prototype.setIsHeaderContentAlwaysExpanded=function(e){var t=this.getAlwaysShowContentHeader();var i=g.system.phone||g.system.tablet;if(t!==e){this.setProperty("alwaysShowContentHeader",e,i)}return this};M.prototype.setShowEditHeaderButton=function(e){var t=this.getShowEditHeaderButton(),i=this.getAggregation("_headerContent");if(t!==e){this.setProperty("showEditHeaderButton",e,true);i&&i.invalidate()}return this};M.prototype._initializeScroller=function(){if(this._oScroller){return}this._oScroller=new _(this,this.getId()+"-scroll",{horizontal:false,vertical:true});this._oScroller.setOnAfterScrollToElement(this._onAfterScrollToElement.bind(this))};M.prototype._onAfterScrollToElement=function(){var e=this._$opWrapper.scrollTop(),t=this._bStickyAnchorBar;this._onScroll({target:{scrollTop:e}});if(this._bStickyAnchorBar&&!t&&this._$opWrapper.scrollTop()===e){this._$opWrapper.scrollTop(e-this.iAnchorBarHeight)}};M.prototype.setSelectedSection=function(e){var t,i;if(e instanceof p){e=e.getId()}else if(e!=null&&typeof e!=="string"){v(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this}if(e===this.getSelectedSection()){return this}if(e===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this}this.scrollToSection(e);t=S._getClosestSection(e);i=t instanceof S?t.getId():t;this.setDirectScrollingToSection(i);return this.setAssociation("selectedSection",i,true)};M.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()&&this._oFirstVisibleSection){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange()}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0)}}};M.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%")}this._bCorrectParentHeightIsSet=true};M.prototype._cacheDomElements=function(){this._$footerWrapper=this.$("footerWrapper");this._$titleArea=this.$("headerTitle");this._$anchorBar=this.$("anchorBar");this._$stickyAnchorBar=this.$("stickyAnchorBar");this._$opWrapper=this.$("opwrapper");this._$spacer=this.$("spacer");this._$headerContent=this.$("headerContent");this._$stickyHeaderContent=this.$("stickyHeaderContent");this._$contentContainer=this.$("scroll");this._$sectionsContainer=this.$("sectionsContainer");this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true};M.prototype._handleExpandButtonPress=function(e){this._expandHeader(true)};M.prototype._toggleHeaderTitle=function(e,t){var i=this.getHeaderTitle();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!e);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!e)}if(e){i&&i.unSnap(t)}else{i&&i.snap(t)}};M.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this.fireEvent("_moveHeader",{fixed:true});this._bSupressModifyOnScrollOnce=true};M.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;this.fireEvent("_moveHeader",{fixed:false});return true}return false};M.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar()}};M.prototype._applyUxRules=function(e){var t,i,n,r,s,a,l,h,c,d,g,u,_={};t=this.getSections()||[];r=0;a=this.getShowAnchorBar();l=this.getUseIconTabBar();h=null;this._cleanMemory();t.forEach(function(t){if(!t.getVisible()){return true}this._registerSectionBaseInfo(t);i=t.getSubSections()||[];n=0;c=null;i.forEach(function(t){if(!t.getVisible()){return true}this._registerSectionBaseInfo(t);s=t.getVisibleBlocksCount();if(s===0){t._setInternalVisible(false,e);P.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+t.getTitle()+" forced to hidden")}else{t._setInternalVisible(true,e);_[t.getId()]=true;n++;if(!c){c=t}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t,!h),e)}}},this);if(n>1){i.forEach(function(e){e._setBorrowedTitleDomId("")})}if(n==0){t._setInternalVisible(false,e);P.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+t.getTitle()+" forced to hidden")}else{t._setInternalVisible(true,e);_[t.getId()]=true;if(!h){h=t;u=n}if(this.getSubSectionLayout()===$.TitleOnTop&&n===1&&c.getTitle().trim()!==""){P.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+t.getTitle()+" is taking its single subsection title "+c.getTitle());t._setInternalTitle(c.getTitle(),e);_[c.getId()]=false;c._setBorrowedTitleDomId(t.getId()+"-title")}else{t._setInternalTitle("",e)}if(n===1&&!c.getTitle().trim()){c._setBorrowedTitleDomId(t.getId()+"-title")}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t),e)}r++}if(l){_[t.getId()]=false}},this);if(r<=1){a=false;P.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(l&&h){_[h.getId()]=true}}else if(h&&a){d=true;_[h.getId()]=false;P.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+h.getTitle()+" title forced to hidden")}this.toggleStyleClass(M.NO_NAVIGATION_CLASS_NAME,r<=1);Object.keys(_).forEach(function(t){o.getElementById(t)._setInternalTitleVisible(_[t],e)});if(a){this._oABHelper._buildAnchorBar()}this._setInternalAnchorBarVisible(a,e);this._oFirstVisibleSection=h;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(h);this._bAllContentFitsContainer=r===1&&n===1&&this._oFirstVisibleSubSection.hasStyleClass(f.FIT_CONTAINER_CLASS);if(d&&u===1){g=this.getAggregation("_anchorBar").getItems();if(g.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(g[0].getId()+"-content")}}this._checkSubSectionVisibilityChange()};M.prototype._checkSubSectionVisibilityChange=function(){var e=this.getUseIconTabBar(),t=e&&o.getElementById(this.getSelectedSection()),i=t?[t]:this._getVisibleSections(),n={},r;i.forEach(function(e){e.getSubSections().forEach(function(e){r=e.getVisible()&&e._getInternalVisible();if(r){n[e.getId()]=e}})});if(B(Object.keys(this._oVisibleSubSections),Object.keys(n)).length){this._oVisibleSubSections=n;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:n})}};M.prototype.setUseIconTabBar=function(e){var t=this.getUseIconTabBar();if(e!=t){this._applyUxRules()}this.setProperty("useIconTabBar",e);this.toggleStyleClass("sapUxAPObjectPageLayoutIconTabBar",e);return this};M.prototype._setCurrentTabSection=function(e,t){if(!e){return}var i;if(V.isObjectA(e,"sap.uxap.ObjectPageSubSection")){i=e;e=e.getParent()}else{i=this._getFirstVisibleSubSection(e)}if(this._oCurrentTabSection!==e){this._renderSection(e);this._oCurrentTabSection=e}this._oCurrentTabSubSection=i};M.prototype._renderSection=function(e){var t=this.$().find(".sapUxAPObjectPageContainer"),i;if(e&&t.length){i=(new s).getInterface();this.getSections().forEach(function(t){if(t.getId()===e.getId()){i.renderControl(e)}else{i.cleanupControlWithoutRendering(t)}});i.flush(t[0]);i.destroy()}};M.prototype._isLazyLoadingEffectivelyEnabled=function(){return this.getEnableLazyLoading()||this.getUseIconTabBar()};M.prototype.setShowAnchorBarPopover=function(e,t){var i=this.getProperty("showAnchorBarPopover"),e=this.validateProperty("showAnchorBarPopover",e),o=this.getSelectedSection();if(e===i){return this}this.setProperty("showAnchorBarPopover",e,true);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(o);return this};M.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible};M.prototype._setInternalAnchorBarVisible=function(e,t){if(e!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=e;if(t===true){this.invalidate()}}};M.prototype.setUpperCaseAnchorBar=function(e){this._oABHelper._getAnchorBar().toggleStyleClass("sapUxAPAnchorBarUpperCase",e);return this.setProperty("upperCaseAnchorBar",e,true)};M.prototype._requestAdjustLayout=function(e){if(!this._oLayoutTask){this._oLayoutTask=new H(this._updateScreenHeightSectionBasesAndSpacer,M.DOM_CALC_DELAY,this)}if(!e){P.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+M.DOM_CALC_DELAY+" ms because of dom modifications")}return this._oLayoutTask.reSchedule(e,{}).catch(function(e){})};M.prototype._requestAdjustLayoutAndUxRules=function(e){if(!this._oUxRulesTask){this._oUxRulesTask=new H(this._adjustLayoutAndUxRules,M.DOM_CALC_DELAY,this)}if(!e){P.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+M.DOM_CALC_DELAY+" ms because of dom modifications")}return this._oUxRulesTask.reSchedule(e,{}).catch(function(e){})};M.prototype._adjustLayoutAndUxRules=function(){var e,t,i,n;P.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();e=this.getSelectedSection();i=o.getElementById(e);t=i?.getSelectedSubSection();if(i){this._setSelectedSectionId(e);if(this.getUseIconTabBar()){this._setCurrentTabSection(i);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(i)}this._requestAdjustLayout(true);if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading.doLazyLoading()}if(!this._isClosestScrolledSection(e)||this._hasOngoingScrollToSection()){n=e;if(i.indexOfSubSection(o.getElementById(this.getOngoingScrollToSectionBaseId()))>-1){n=this.getOngoingScrollToSectionBaseId()}else if(t){n=t}this.scrollToSection(n,null,0,false,true)}}};M.prototype._isClosestScrolledSection=function(e){var t=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,i=this.iScreenHeight,n=this._getClosestScrolledSectionBaseId(t,i),r=o.getElementById(n),s=S._getClosestSection(r);return s&&e===s.getId()};M.prototype._hasOngoingScrollToSection=function(e){return this._oScroller._$Container&&this._oScroller._$Container.is(":animated")&&this.getOngoingScrollToSectionBaseId()};M.prototype._setSelectedSectionId=function(e){var t=this.getAggregation("_anchorBar"),i=e&&this._oSectionInfo[e];if(!i){return}if(t){this._oABHelper.selectAnchorForSection(e);this.setAssociation("selectedSection",e,true)}};M.prototype.isFirstRendering=function(){return this._bFirstRendering};M.prototype._cleanMemory=function(){this._oSectionInfo={};this._aSectionBases=[]};M.prototype._registerSectionBaseInfo=function(e){this._oSectionInfo[e.getId()]={$dom:[],positionTop:0,buttonId:"",isSection:e instanceof S,sectionReference:e};this._aSectionBases.push(e)};M.prototype._triggerVisibleSubSectionsEvents=function(){var e=this.getSelectedSection(),t=o.getElementById(e),i=t?.getSelectedSubSection(),n=this._bDomElementsCached;this._bDelayDOMBasedCalculations=false;if(i&&n&&this._oSectionInfo[i]?.positionTop!==this._$opWrapper.scrollTop()){this.scrollToSection(i,0)}else if(e&&n&&this._oSectionInfo[e]?.positionTop!==this._$opWrapper.scrollTop()){this.scrollToSection(e,0)}if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents()}};M.prototype.scrollToSection=function(e,n,r,s,a){var l=o.getElementById(e),h,c,d=i.getAnimationMode()!==t.none,g,u,_,p;if(!this.getDomRef()){P.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return}if(!l){P.warning("scrollToSection aborted: unknown section",e,this);return}if(!this._oSectionInfo[e]||!l._getInternalVisible()){P.warning("scrollToSection aborted: section is hidden by UX rules",e,this);return}if(this.bIsDestroyed){P.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return}if(this.getUseIconTabBar()){var b=S._getClosestSection(l);var y=this._bAllContentFitsContainer,T;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(b);T=this._bAllContentFitsContainer!==y;if(T&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false)}b._allowPropagationToLoadedViews(true);this._setCurrentTabSection(l);this._oABHelper.selectAnchorForSection(b.getId());this.setAssociation("selectedSection",b.getId(),true);this._checkSubSectionVisibilityChange()}c=l instanceof f?l:this._getFirstVisibleSubSection(l);r=r||0;l._expandSection();this._requestAdjustLayout(true);n=this._computeScrollDuration(n,l);g=d&&n>0;var H=this._computeScrollPosition(l);if(H>this._getSnapPosition()&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){var A=this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();A&&(H+=this._$headerContent.height())}if(this._sCurrentScrollId!=e||a){this._sCurrentScrollId=e;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false)}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined}.bind(this),n)}this._preloadSectionsOnBeforeScroll(l);H+=r;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(H)){h=this._getSnapPosition();this._scrollTo(h,0);if(h===0){this._toggleHeader(true)}}u=g&&this.getEnableLazyLoading()&&this._oLazyLoading;_=function(e,t,i){t&&this.setOngoingScrollToSectionBaseId(e);i&&this._oLazyLoading.suppress()}.bind(this,e,g,u);p=function(e){if(e===this.getOngoingScrollToSectionBaseId()){this.setOngoingScrollToSectionBaseId(null);this._resumeLazyLoading()}}.bind(this,e);this._scrollTo(H,n,_,p);if(s){this.fireNavigate({section:S._getClosestSection(l),subSection:c})}}};M.prototype.onAnchorBarTabPress=function(e){var t=o.getElementById(e),i=t.isA("sap.uxap.ObjectPageSubSection"),n,r;if(!t){return}n=i?t.getParent():t;r=i?t:null;var s=this.fireBeforeNavigate({section:n,subSection:r});if(!s){return}this.setDirectScrollingToSection(n.getId());this._iCurrentScrollPositionWhenTabPressed=this._$opWrapper.length&&this._$opWrapper.scrollTop();this.scrollToSection(t.getId(),null,0,true);n.setAssociation("selectedSubSection",r,true);this.setAssociation("selectedSection",n,true);this._iCurrentScrollPositionWhenTabPressed=0};M.prototype._hasSingleVisibleFullscreenSubSection=function(e){var t=e.getSubSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()&&e.getBlocks().length>0});return t.length===1&&t[0].hasStyleClass(f.FIT_CONTAINER_CLASS)};M.prototype._computeScrollDuration=function(e,t){var i=parseInt(e);i=i>=0?i:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&(t instanceof S||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){i=0}return i};M.prototype._computeScrollPosition=function(e){var t=this._oSectionInfo[e.getId()].positionTop,i=this._bHeaderExpanded;if(i&&this._isFirstVisibleSectionBase(e)){t=this._iCurrentScrollPositionWhenTabPressed&&this._iCurrentScrollPositionWhenTabPressed<t?this._iCurrentScrollPositionWhenTabPressed:0}return t};M.prototype._preloadSectionsOnBeforeScroll=function(e){var t=e.getId(),i;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){i=e instanceof S?e:e.getParent();this._connectModelsForSections([i])}if(this.getEnableLazyLoading()){var o=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;i=this._oLazyLoading.getSubsectionsToPreload(o,t);if(g.system.desktop){setTimeout(function(){this._doConnectModelsForSections(i)}.bind(this),50)}else{this._doConnectModelsForSections(i)}}};M.prototype._doConnectModelsForSections=function(e){this._connectModelsForSections(e).then(()=>this._fireSubSectionEnteredViewPortEvent(e))};M.prototype._fireSubSectionEnteredViewPortEvent=function(e){e.forEach(function(e){this.fireEvent("subSectionEnteredViewPort",{subSection:e})},this)};M.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId};M.prototype.setDirectScrollingToSection=function(e){this.sDirectSectionId=e};M.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId};M.prototype.setOngoingScrollToSectionBaseId=function(e){this.sOngoingScrollToSectionBaseId=e};M.prototype.getOngoingScrollToSectionBaseId=function(){return this.sOngoingScrollToSectionBaseId};M.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null};M.prototype._scrollTo=function(e,t,i,o){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){P.debug("ObjectPageLayout :: scrolling to "+e);if(t===0&&this._shouldSnapHeaderOnScroll(e)){this._toggleHeader(true)}i&&i();this._oScroller.scrollTo(0,e,t,o)}return this};M.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true)}};M.prototype._scrollBelowCollapseVisualIndicator=function(){var e=this._getHeaderContent(),t,i,o,n;if(!k(e)||!k(this._$opWrapper)){return}t=e._getCollapseButton().getDomRef();i=t.getBoundingClientRect().height;o=this._$opWrapper[0].getBoundingClientRect().height;n=t.offsetTop+i-o;this._scrollTo(n)};M.prototype._updateMedia=function(e,t){if(!e){return}var i=function(e){Object.keys(t).forEach(function(i){var o=t[i],n=e===o;this.toggleStyleClass(o,n)},this)}.bind(this),o=M.BREAK_POINTS;if(e<=o.PHONE){i(t.PHONE)}else if(e<=o.TABLET){i(t.TABLET)}else if(e<=o.DESKTOP){i(t.DESKTOP)}else{i(t.DESKTOP_XL)}};M.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var e,t,i,n,r,s,a=this._bHeaderInTitleArea||!this._bHeaderExpanded,l,h,c,d=this.getDomRef(),g=this.getUseIconTabBar(),u=o.getElementById(this.getSelectedSection());if(!d||!this._bDomReady){return false}P.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(d);if(this.iScreenHeight===0){return}if(g&&u){this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(u)}this.iFooterHeight=this._getFooterHeight();var _=-1;this._aSectionBases.forEach(function(e){var i=this._oSectionInfo[e.getId()],o=e.$(),s=false,a;if(!i||!o.length){return}if(!i.isSection){_++}i.$dom=o;var d=C.Utilities.getChildPosition(o,this._$contentContainer).top;i.positionTop=Math.ceil(d);if(!i.isSection&&(a=e.getParent())){s=e._getTitleDomId()===a.getId()+"-title";if(s){var u=a.$().position().top;i.positionTop=Math.ceil(u)}}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){i.positionTop-=this.iAnchorBarHeight}i.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",s);if(this._bMobileScenario){var p=e.getParent();if(p instanceof S&&p._getIsHidden()){return}if(r){this._oSectionInfo[r].positionBottom=i.positionTop}r=e.getId();t=e}else{if(i.isSection){if(r){this._oSectionInfo[r].positionBottom=i.positionTop;if(n){this._oSectionInfo[n].positionBottom=i.positionTop}}r=e.getId();n=null}else{if(n){this._oSectionInfo[n].positionBottom=i.positionTop}n=e.getId();t=e}}if(!i.isSection){h=g||e.getParent()===this._oFirstVisibleSection;l=h&&_===0;c=e.hasStyleClass(f.FIT_CONTAINER_CLASS);e._setHeight(this._computeSubSectionHeight(l,c,e))}},this);if(t){e=this._computeLastVisibleHeight(t);if(this._bMobileScenario&&r){this._oSectionInfo[r].positionBottom=this._oSectionInfo[r].positionTop+e}else{if(n){this._oSectionInfo[n].positionBottom=this._oSectionInfo[n].positionTop+e}if(r&&n){this._oSectionInfo[r].positionBottom=this._oSectionInfo[n].positionTop+e}}s=this._bStickyAnchorBar||_>0||this._checkContentBottomRequiresSnap(t);if(this._bAllContentFitsContainer){s=false}if(s&&!this._shouldPreserveHeaderInTitleArea()){a=true}i=this._computeSpacerHeight(t,e,s,a);this._$spacer.height(i+"px");P.debug("ObjectPageLayout :: bottom spacer is now "+i+"px");O(this._oScrollContainerLastState,{iScrollableContentLength:Math.round(this._getScrollableContentLength()),iSpacerHeight:i})}this._adjustTitlePositioning();this._setSectionInfoIsDirty(false);this._updateSelectionOnScroll(this._$opWrapper.scrollTop());this._toggleScrolling(this._shouldAllowScrolling());return true};M.prototype._computeSubSectionHeight=function(e,t,i){var o,n,r,s,a,l;if(!t){return""}var h=this._bAllContentFitsContainer?this._bHeaderExpanded:e;o=this._getSectionsContainerHeight(h);if(this._bAllContentFitsContainer){n=this._$sectionsContainer[0].getBoundingClientRect();r=i.getDomRef().getBoundingClientRect();s=r.top-n.top;a=this.iFooterHeight+this._iREMSize;l=s+a;o-=l}return o+"px"};M.prototype._computeScrollableContentSize=function(e){var t=0;if(this._$contentContainer&&this._$contentContainer.length){t=this._$contentContainer[0].scrollHeight}if(!this._bStickyAnchorBar&&e){t-=this.iAnchorBarHeight}if(this._bStickyAnchorBar&&!e){t+=this.iAnchorBarHeight}return t};M.prototype._computeLastVisibleHeight=function(e){var t=this._bStickyAnchorBar||this._bHeaderInTitleArea;var i=this._getSectionPositionTop(e,t);return Math.floor(this._$spacer.position().top)-i};M.prototype._getStickyAreaHeight=function(e){if(e){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight}return this.iHeaderTitleHeight};M.prototype._getScrollableViewportHeight=function(e){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(e)};M.prototype._getSectionsContainerHeight=function(e){var t=!e,i=this._getScrollableViewportHeight(t);if(!t&&!this._bHeaderInTitleArea){i-=this.iHeaderContentHeight+this.iAnchorBarHeight}return i};M.prototype._getSectionPositionTop=function(e,t){var i=this._oSectionInfo[e.getId()].positionTop;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){i+=this.iAnchorBarHeight}return i};M.prototype._getSectionPositionBottom=function(e,t){var i=this._oSectionInfo[e.getId()].positionBottom;if(!t){i+=this.iAnchorBarHeight}return i};M.prototype._determineSectionBaseInternalTitleLevel=function(e,t){var i=this.getSectionTitleLevel(),o=e instanceof S;if(i===x.Auto){if(o||t&&!o){return x.H3}return x.H4}return o?i:M._getNextTitleLevelEntry(i)};M.prototype._shouldApplySectionTitleLevel=function(e){return e.getTitleLevel()===x.Auto};M.prototype._checkContentBottomRequiresSnap=function(e){var t=false;return this._getSectionPositionBottom(e,t)>this._getScrollableViewportHeight(t)+this._getSnapPosition()};M.prototype._computeSpacerHeight=function(e,t,i,o){var n,r;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){n=0}else{r=this._getScrollableViewportHeight(o);if(i){r=Math.ceil(r);t=Math.floor(t)}else{t=this._$spacer.position().top}if(t<r){n=r-t}else{n=0}}if(this.iFooterHeight>n){n+=this.iFooterHeight}return n};M.prototype._isFirstVisibleSectionBase=function(e){var t,i,n,r=this.getSelectedSection(),s=this.getUseIconTabBar();if(!e||!e.getParent()){return}t=e.getId();if(s&&t===r){return true}if(s&&e.getParent().getId()===r){i=o.getElementById(r);n=this._getFirstVisibleSubSection(i);return n&&n.getId()===t}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return t===this._oFirstVisibleSection.getId()||t===this._oFirstVisibleSubSection.getId()}return false};M.prototype._getFirstVisibleSubSection=function(e){if(!e){e=this.getUseIconTabBar()?this._oCurrentTabSection:this._oFirstVisibleSection;if(!e){return}}var t;this._aSectionBases.every(function(i){if(i.getParent()&&i.getParent().getId()===e.getId()){t=i;return false}return true});return t};M.prototype._initAnchorBarScroll=function(){var e=o.getElementById(this.getSelectedSection()),t=e?.getSelectedSubSection(),i=o.getElementById(t),n,r=i&&this._oSectionInfo[t];this._requestAdjustLayout(true);n=e?this._computeScrollPosition(r&&i||e):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:n}},true)};M.prototype._setAsCurrentSection=function(e){var t,i,n,r;if(this._sScrolledSectionId===e){return}P.debug("ObjectPageLayout :: current section is "+e);this._sScrolledSectionId=e;t=this.getAggregation("_anchorBar");r=t&&this._getInternalAnchorBarVisible();i=o.getElementById(e);n=i&&i instanceof f&&(i.getTitle().trim()===""||!i._getInternalTitleVisible()||i.getParent()._getIsHidden());if(n){e=i.getParent().getId();P.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+e)}if(i&&this._oSectionInfo[e]){r&&this._oABHelper.selectAnchorForSection(e);this.setAssociation("selectedSection",S._getClosestSection(e).getId(),true);this._setSectionsFocusValues(e)}};M.prototype._registerOnContentResize=function(){var e=this._$contentContainer.length&&this._$contentContainer[0];if(!e){return}if(this._iContentResizeId){l.deregister(this._iContentResizeId)}this._iContentResizeId=l.register(e,this._onUpdateContentSize.bind(this))};M.prototype._onUpdateContentSize=function(e){var t=e.size;this.iContentHeight=t.height;if(t.height===0||t.width===0){P.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading.doLazyLoading()}};M.prototype.triggerPendingLayoutUpdates=function(){if(this._hasPendingLayoutUpdate()){this._requestAdjustLayout(true)}};M.prototype._hasPendingLayoutUpdate=function(){return this._oLayoutTask&&this._oLayoutTask.isPending()||this._$contentContainer.length&&this._$contentContainer.get(0).offsetHeight!==this.iContentHeight};M.prototype._adjustTitlePositioning=function(t){if(!this._$titleArea?.length||!this._$opWrapper?.length){return}var i=this._$opWrapper.get(0),o=this._$titleArea.get(0),n=o.getBoundingClientRect().height,r=o.getBoundingClientRect().width,s=E().width,a;i.style.paddingTop=n+"px";i.style.scrollPaddingTop=n+"px";if(this._oScroller){this._oScroller.setScrollPaddingTop(n)}a="polygon(0px "+n+"px, "+Math.floor(r)+"px "+n+"px, "+Math.floor(r)+"px 0, 100% 0, 100% 100%, 0 100%)";if(e.getRTL()){a="polygon(0px 0px, "+s+"px 0px, "+s+"px "+n+"px, 100% "+n+"px, 100% 100%, 0 100%)"}i.style.clipPath=a;this.getHeaderTitle()&&this._shiftHeaderTitle()};M.prototype._onUpdateScreenSize=function(e){var t=this.getHeaderTitle(),i=this._getHeaderContent(),o=e.size.width,n=e.size.height,r=e.oldSize.height,s=n!==r,a,l=i&&i.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(e.size.height===0||e.size.width===0){P.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}this._bMobileScenario=C.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=C.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(!this._bDomReady){P.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return}this._oLazyLoading.setLazyLoadingParameters();this._asyncUpdateScreenSizeExec=setTimeout(function(){if(l&&this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader()){this.invalidate()}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){if(this._isHeaderPinnable()){this._updatePinButtonState()}this._expandHeader(false);this._scrollTo(0,0)}else if(this._isHeaderPinnable()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._updatePinButtonState()}if(t&&t.isDynamic()){t._onResize(o);this._updateMedia(o,M.DYNAMIC_HEADERS_MEDIA)}this._updateMedia(o,M.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter()}a=this.getSelectedSection();if(r===0&&s&&!this._isClosestScrolledSection(a)){a!==null?this.scrollToSection(a,0):this._selectFirstVisibleSection()}this._scrollTo(this._$opWrapper.scrollTop(),0);if(r===0&&s&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading()}}.bind(this),this._getDOMCalculationDelay())};M.prototype._onUpdateHeaderTitleSize=function(e){if(e.size.height===0||e.size.width===0){P.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}if(!this._bDomReady){P.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return}this._adjustHeaderHeights();this._requestAdjustLayout()};M.prototype._initRangeSet=function(){if(!g.media.hasRangeSet(M.MEDIA_RANGESET_NAME)){g.media.initRangeSet(M.MEDIA_RANGESET_NAME,[M.BREAK_POINTS.PHONE,M.BREAK_POINTS.TABLET,M.BREAK_POINTS.DESKTOP],"px",["phone","tablet","desktop"])}};M.prototype._onMediaRangeChange=function(){var e=this._getMediaContainerWidth();if(!e){return}if(this._hasDynamicTitle()){this._updateMedia(e,M.DYNAMIC_HEADERS_MEDIA)}this._updateMedia(e,M.MEDIA)};M.prototype._shouldSnapHeaderOnScroll=function(e){return e>0&&e>=this._getSnapPosition()&&!this._shouldPreserveHeaderInTitleArea()};M.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0};M.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight};M.prototype._isContentLengthDecreased=function(e){if(e){return e.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength&&e.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight}};M.prototype._canReachScrollTop=function(e,t){var i;t=t||0;i=this._oScrollContainerLastState.iScrollableContentLength+t+this._$contentContainer.get(0).offsetTop-this._oScrollContainerLastState.iScrollableViewportHeight;return i>=e};M.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL")}};M.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){l.deregister(this._iResizeId);this._iResizeId=null}};M.prototype._deregisterTitleSizeListener=function(){if(this._iTitleResizeId){l.deregister(this._iTitleResizeId);this._iTitleResizeId=null}};M.prototype._onScroll=function(e,t){var i=Math.max(Math.ceil(e.target.scrollTop),0),o=this._$opWrapper.length&&this._$opWrapper[0],n=this._$spacer.length&&this._$spacer[0],r=this._$spacer.height(),s,a=this.getHeaderTitle(),l=this._shouldSnapHeaderOnScroll(i),h=this._shouldPreserveHeaderInTitleArea(),c=false,d=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:i,iScrollableContentLength:Math.round(this._getScrollableContentLength()),iScrollableViewportHeight:o.offsetHeight,iSpacerHeight:r};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;if(!t){return}}if(!o||!n){return}s=this.iScreenHeight;if(s===0){return}if(this._getSectionInfoIsDirty()){return}if(d&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(d)){var g=d.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(d.iScrollTop)&&this._canReachScrollTop(d.iScrollTop,g)){var u=d.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight,_=this._oScrollContainerLastState.iScrollableContentLength,p=u-_,S;if(p>0){S=r+p;this._$spacer.height(S+"px");this._scrollTo(d.iScrollTop);return}}}if(l&&!h){s-=this.iAnchorBarHeight+this.iHeaderTitleHeightStickied}if(this._bHeaderInTitleArea&&!h){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout()}if(!h&&(a&&this.getShowHeaderContent()||this.getShowAnchorBar())){this._toggleHeader(l,!!(e&&e.type==="scroll"))}if(!h){this._adjustHeaderTitleBackgroundPosition(i)}P.debug("ObjectPageLayout :: lazy loading : Scrolling at "+i,"----------------------------------------");this._updateSelectionOnScroll(i);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(t,i,e.timeStamp,s)}if(a&&a.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&a.getShowTitleSelector()){if(i===0){this.$("scroll").css("z-index","1000");c=false}else if(!c){c=true;this.$("scroll").css("z-index","0")}}};M.prototype._updateSelectionOnScroll=function(e){var t=this.iScreenHeight,i,n,r,s;if(t===0){return}i=this._getClosestScrolledSectionBaseId(e,t);n=S._getClosestSection(i);r=n?n.getId():null;s=this._getClosestScrolledSectionBaseId(e,t,true);if(i){var a=this.getDirectScrollingToSection(),l=o.getElementById(a);if(i!==this._sScrolledSectionId){P.debug("ObjectPageLayout :: closest id "+i,"----------------------------------------");var a=this.getDirectScrollingToSection();if(a&&a!==r&&(l&&l.getDomRef()&&!this.isFirstRendering())){return}this.clearDirectScrollingToSection();this._setAsCurrentSection(i)}else if(r===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection()}if(s!==this._sScrolledSubSectionId){var h=S._getClosestSection(i),c=o.getElementById(s);this._sScrolledSubSectionId=s;this.fireEvent("_sectionChange",{section:h,subSection:c});this.fireEvent("sectionChange",{section:h,subSection:c})}}};M.prototype._getSnapPosition=function(){var e=this.iHeaderContentHeight,t=this._getTitleHeightDelta();if(e){e-=Math.max(t,this._iHeaderContentPaddingBottom)}return e};M.prototype._getTitleHeightDelta=function(){var e=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;e=Math.max(e,0);e=Math.min(e,M.MAX_SNAP_POSITION_OFFSET);return e};M.prototype._getClosestScrolledSectionBaseId=function(e,t,i){i=!!i;e=Math.ceil(e);var n=e+t,r,s=i||this._bMobileScenario;jQuery.each(this._oSectionInfo,function(t,a){var l,h,c,d,g,u=this.getSelectedSection();l=a.sectionReference;h=l.getParent();c=h instanceof S&&h._getIsHidden();if(this.getUseIconTabBar()&&u){g=o.getElementById(u);if(!g){return}if(a.isSection&&a.sectionReference!=g){return true}if(!a.isSection&&g.indexOfSubSection(a.sectionReference)<0){return true}}if(a.isSection||s&&!c){if(!r&&a.sectionReference._getInternalVisible()===true){d=this._getFirstVisibleSubSection(a.sectionReference);if(a.isSection&&i&&d){r=d.getId()}else{r=t}}if(a.isSection&&i){return true}if(a.positionTop<=n&&e<=a.positionBottom){if(a.positionTop<=e+1&&a.positionBottom>e){r=t}}}}.bind(this));return o.getElementById(r)?r:null};M.prototype._toggleHeader=function(e,t){var i;if(e===this._bStickyAnchorBar){return}i=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!e,t)}if(!this._bStickyAnchorBar&&e){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);i&&i.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators()}else if(this._bStickyAnchorBar&&!e){this._restoreFocusAfter(this._moveAnchorBarToContentArea);i&&i.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea())}}};M.prototype._restoreFocusAfter=function(e){var t=o.getActiveElement();e.call(this);if(g.system.phone!==true){if(!o.getActiveElement()){t&&t.$().trigger("focus")}}return this};M.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize()}return this};M.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var e=this._$opWrapper.scrollTop();this._$anchorBar.append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(e);this._toggleHeaderStyleRules(false)}return this};M.prototype._toggleHeaderStyleRules=function(e){e=!!e;var t=e?"hidden":"inherit";this._bStickyAnchorBar=e;this._$headerContent.css("overflow",t);this._$headerContent.toggleClass("sapContrastPlus",!e);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",e);this._$anchorBar.css("visibility",t);if(k(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!e)}this.fireToggleAnchorBar({fixed:e});if(!e&&!this.iAnchorBarHeight){this._requestAdjustLayout()}};M.prototype.getScrollDelegate=function(){return this._oScroller};M.prototype.setHeaderTitle=function(e,t){if(e&&typeof e.addEventDelegate==="function"){e.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)})}this.setAggregation("headerTitle",e,t);this._oObserver&&this._oObserver.disconnect();this._oObserver=new a(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(e,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(e){this._createHeaderContent()}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=M.HEADER_CONTENT_PADDING_BOTTOM}return this};M.prototype._onAfterHeaderTitleRendering=function(){var e=this.getHeaderTitle(),t=e&&e.$(),i;if(!e||!t.length){return}i=t.height();if(i!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=i}};M.prototype._onModifyHeaderTitle=function(e){var t=this.getAggregation("_headerContent");t&&e.current&&t.setBackgroundDesign(e.current)};M.prototype.invalidate=function(e){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&e&&e instanceof S&&!e.isActive()&&this._oSectionInfo[e.getId()]){return}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);this._iAfterRenderingDomReadyTimeout=null}c.prototype.invalidate.apply(this,arguments)};M.prototype._createHeaderContent=function(){var e=this.getHeaderTitle(),t=this.getAggregation("_headerContent"),i,o;var n=e?e.getCompatibleHeaderContentClass():b;if(!(t instanceof n)){i=this.getAggregation("_headerContent");if(i){i.destroy();i.removeEventDelegate(this._oHeaderContentDelegate)}o=n.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),"",this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");o.addEventDelegate(this._oHeaderContentDelegate);o.getContent().forEach(this._replaceHeaderContentParent,this);this.setAggregation("_headerContent",o,true)}};M.prototype._adjustHeaderBackgroundSize=function(){var e=this.getHeaderTitle();if(e&&e.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px")}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px")}e.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0)}};M.prototype._adjustHeaderTitleBackgroundPosition=function(e){var t=this.getHeaderTitle();if(t&&t.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){t.$().css("background-position","0px "+(this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1+"px")}else{if(this._shouldPreserveHeaderInTitleArea()){t.$().css("background-position","0px 0px")}else{t.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-e)+"px")}}}};M.prototype._adjustHeaderHeights=function(){var e=this.getHeaderTitle(),t=true;if(e&&!e.supportsAdaptLayoutForDomElement()){t=false}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(t)}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(t)}this._adjustHeaderBackgroundSize();this._adjustTitlePositioning();P.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight)}else{P.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered")}};M.prototype._appendTitleCloneToDOM=function(e){var t=this.getHeaderTitle().$(),i=t.clone();i.css({left:"-10000px",top:"-10000px",width:t.width()+"px",position:"absolute"});i.toggleClass("sapUxAPObjectPageHeaderStickied",e);i.appendTo(this._$titleArea.parent());if(e){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(i)}return i};M.prototype._obtainSnappedTitleHeight=function(e){var t=this.getHeaderTitle(),i,o;if(!t){return 0}if(e){i=this._appendTitleCloneToDOM(true);o=i.height();i.remove()}else if(t.snap){o=this._obtainTitleHeightViaStateChange(true)}return o};M.prototype._obtainExpandedTitleHeight=function(e){var t=this.getHeaderTitle(),i,o;if(!t){return 0}if(e){i=this._appendTitleCloneToDOM(false);o=i.is(":visible")?i.height():0;i.remove()}else if(t.unSnap){o=this._obtainTitleHeightViaStateChange(false)}return o};M.prototype._obtainTitleHeightViaStateChange=function(e){var t=this.getHeaderTitle(),i,o=this._$sectionsContainer.height(),n,r=e?t.snap:t.unSnap,s=e?t.unSnap:t.snap;r.call(t,false);i=t.$().outerHeight();s.call(t,false);n=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(o,n);return i};M.prototype._adjustSpacerHeightUponUnsnapping=function(e,t){var i;if(e!=t){i=this._$spacer.height()-(t-e);this._$spacer.height(i)}};M.prototype._getHeaderDesign=function(){var e=this.getHeaderTitle(),t=C.ObjectPageHeaderDesign.Light;if(e!=null){t=e.getHeaderDesign()}return t};M.prototype._getVisibleSections=function(){return this.getSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()})};M.prototype._setSectionsFocusValues=function(e){var t=this._getVisibleSections()||[],i,o="0",n="-1",r="tabindex",s,a=t[0];t.forEach(function(t){i=t.$();if(e===t.getId()){i.attr(r,o);s=t;t._setSubSectionsFocusValues()}else{i.attr(r,n);t._disableSubSectionsFocus()}});if(!s&&t.length>0){a.$().attr(r,o);a._setSubSectionsFocusValues();s=a}return s};M.prototype.setShowHeaderContent=function(e){var t=this.getShowHeaderContent(),i;if(t!==e){if(t&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false)}this.setProperty("showHeaderContent",e,true);this._updateTitleVisualState();i=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!e||!i);if(i){i.setProperty("visible",e)}if(e){this._updateToggleHeaderVisualIndicators()}}return this};M.prototype._headerTitleChangeHandler=function(e){var t;if(!this.getShowTitleInHeaderContent()){return}if(e){this._getHeaderContent()._destroyObjectImage(true)}t=(new s).getInterface();this.getRenderer()._rerenderHeaderContentArea(t,this);this._getHeaderContent().invalidate();t.destroy()};M.prototype._replaceHeaderContentParent=function(e){if(e.getParent().isA(["sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageDynamicHeaderContent"])){if(e.isA(["sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageDynamicHeaderContent"])){return}if(e._sOriginalParentAggregationName){return}e._sOriginalParentAggregationName=e.sParentAggregationName;e.sParentAggregationName="headerContent";e.getParent=function(){return this}.bind(this);e.destroy=function(){this._restoreParent(e);e.getMetadata().getClass().prototype.destroy.apply(e,arguments)}.bind(this)}};M.prototype._restoreParent=function(e){if(e&&e._sOriginalParentAggregationName){e.sParentAggregationName=e._sOriginalParentAggregationName;e.getParent=e.getMetadata().getClass().prototype.getParent;e.destroy=e.getMetadata().getClass().prototype.destroy;e._sOriginalParentAggregationName=null}};M.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[])}return this._getHeaderContent().getAggregation("content",[])};M.prototype.insertHeaderContent=function(e,t,i){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",e,t,i)}this._getHeaderContent().insertAggregation("content",e,t,i);this._replaceHeaderContentParent(e);return this};M.prototype.addHeaderContent=function(e,t){if(!this._getHeaderContent()){return this.addAggregation("headerContent",e,t)}this._getHeaderContent().addAggregation("content",e,t);this._replaceHeaderContentParent(e);return this};M.prototype.removeAllHeaderContent=function(e){var t;if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",e)}t=this._getHeaderContent().removeAllAggregation("content",e);t.forEach(function(e){this._restoreParent(e)},this);return t};M.prototype.removeHeaderContent=function(e,t){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",e,t)}this._getHeaderContent().removeAggregation("content",e,t);this._restoreParent(e);return this};M.prototype.destroyHeaderContent=function(e){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",e)}return this._getHeaderContent().destroyAggregation("content",e)};M.prototype.indexOfHeaderContent=function(e){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",e)}return this._getHeaderContent().indexOfAggregation("content",e)};M.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent")};M.prototype._getHeaderContentDomRef=function(){var e=this._getHeaderContent();if(!e||!this.getShowHeaderContent()){return null}if(this._bStickyAnchorBar&&!this._bHeaderInTitleArea){return this.$().find(".sapUxAPObjectPageHeaderTitle .sapUxAPObjectPageHeaderDetails").get(0)}return e.getDomRef()};M.prototype._connectModelsForSections=function(e){var t=[];e=e||[];e.forEach(function(e){t.push(e.connectToModelsAsync())});return Promise.all(t)};M.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()}};M.prototype._hasVerticalScrollBar=function(){var e=this._$opWrapper.length&&this._$opWrapper.get(0);return e&&e.scrollHeight>e.offsetHeight};M.prototype._shiftHeaderTitle=function(){var e=this._calculateShiftOffset(),t=e.sStyleAttribute,i=e.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css(t,i+"px")};M.prototype._isFirstSection=function(e){var t=this._getVisibleSections();if(e===t[0]){return true}return false};M.prototype._isValidStoredSubSectionInfo=function(){var e=this.getSelectedSection(),t=o.getElementById(e),i;if(!t||!this._oStoredScrolledSubSectionInfo){return false}i=o.getElementById(this._oStoredScrolledSubSectionInfo.sSubSectionId);return i&&this._sectionCanBeRenderedByUXRules(i)&&t.indexOfSubSection(i)>=0};M.prototype._restoreScrollPosition=function(){var e=this._isValidStoredSubSectionInfo(),t,i=o.getElementById(this.getSelectedSection()),n=i?.getSelectedSubSection();if(e){t=this._computeScrollPosition(o.getElementById(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(t,0)}else{this.scrollToSection(n||i?.getId(),0)}};M.prototype._storeScrollLocation=function(){var e=this.getDomRef()&&this.$().width()&&this.$().height();if(!e||!this._bDomReady||!this._oScroller){return false}this.triggerPendingLayoutUpdates();var t=this._$opWrapper.scrollTop(),i=this._getClosestScrolledSectionBaseId(this._oScroller.getScrollTop(),this.iScreenHeight,true),n;if(i){n=t-this._computeScrollPosition(o.getElementById(i))}this._iStoredScrollTop=t;this._oStoredScrolledSubSectionInfo={sSubSectionId:i,iOffset:n};this._oCurrentTabSection=null;return this._oStoredScrolledSubSectionInfo};M.prototype.onkeyup=function(e){var t;if(e.which===m.TAB){t=o.getActiveElement();if(t&&this._isFirstSection(t)){this._scrollTo(0,0)}}};M.prototype.setShowFooter=function(e){var t=this.setProperty("showFooter",e,true);this._toggleFooter(e);this.$().toggleClass("sapUxAPObjectPageLayoutFooterVisible",e);return t};M.prototype.destroyFooter=function(){this._destroyInvisibleText();return this.destroyAggregation("footer")};M.prototype._toggleFooter=function(e){var o,n=this.getFooter(),r=i.getAnimationMode();if(!k(n)||!k(this._$footerWrapper)){return}o=r!==t.none&&r!==t.minimal;if(o){this._toggleFooterAnimation(e,n)}else{this._$footerWrapper.toggleClass("sapUiHidden",!e)}this._requestAdjustLayout()};M.prototype._toggleFooterAnimation=function(e,t){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,t));this._bIsFooterAanimationGoing=true;if(e){this._$footerWrapper.removeClass("sapUiHidden")}t.toggleStyleClass(M.SHOW_FOOTER_CLASS_NAME,e);t.toggleStyleClass(M.HIDE_FOOTER_CLASS_NAME,!e)};M.prototype._onToggleFooterAnimationEnd=function(e){this._$footerWrapper.off("webkitAnimationEnd animationend");if(e.hasStyleClass(M.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");e.removeStyleClass(M.HIDE_FOOTER_CLASS_NAME)}else{e.removeStyleClass(M.SHOW_FOOTER_CLASS_NAME)}this._bIsFooterAanimationGoing=false};M.prototype.clone=function(){var e,t,i;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);e=c.prototype.clone.apply(this,arguments);t=this._getHeaderContent();i=e._getHeaderContent();if(i){i.destroy()}if(t){e.setAggregation("_headerContent",t.clone(),true)}return e};M.prototype._cloneProxiedAggregations=function(e){var t=this.mAggregations[e];if(Array.isArray(t)&&t.length===0){t=this["get"+e.charAt(0).toUpperCase()+e.slice(1)]()}this.mAggregations[e]=t};M.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader()};M.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader()};M.prototype._headerBiggerThanAllowedToBeFixed=function(){var e=this._getOwnHeight();return this._getEntireHeaderHeight()>M.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*e};M.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight()};M.prototype._getOwnHeight=function(){return this._getHeight(this)};M.prototype._getHeight=function(e){return!(e instanceof c)?0:e.$().outerHeight()||0};M.prototype._getEntireHeaderHeight=function(){var e=0,t=0,i=this.getHeaderTitle(),o=this._getHeaderContent();if(k(i)){e=i.$().outerHeight()}if(k(o)){t=o.$().outerHeight()}return e+t};M.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin(true)}else{this._pin(true);this._restorePinButtonFocus()}};M.prototype._restorePinButtonFocus=function(){var e=this._getHeaderContent();if(k(e)&&e.supportsPinUnpin()){e._focusPinButton()}};M.prototype._pin=function(e){if(this._bPinned){return}this._bPinned=true;if(e){this.setProperty("headerContentPinned",true,true);this.fireEvent("headerContentPinnedStateChange",{pinned:true})}this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._updateToggleHeaderVisualIndicators();this.addStyleClass("sapUxAPObjectPageLayoutHeaderPinned")};M.prototype._unPin=function(e){if(!this._bPinned){return}this._bPinned=false;if(e){this.setProperty("headerContentPinned",false,true);this.fireEvent("headerContentPinnedStateChange",{pinned:false})}this._updateToggleHeaderVisualIndicators();this.removeStyleClass("sapUxAPObjectPageLayoutHeaderPinned")};M.prototype._isHeaderPinnable=function(){var e=this._getHeaderContent();return e&&e.supportsPinUnpin()&&e.getPinnable()};M.prototype._shouldPinUnpinHeader=function(){return this._bHeaderExpanded&&!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()};M.prototype._updatePinButtonState=function(){var e=this._isHeaderPinnable(),t=e&&this.getHeaderContentPinned()&&this._shouldPinUnpinHeader(),i=this._getHeaderContent();i._togglePinButton(t);this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",e);i._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());if(t){this._pin()}else{this._unPin()}};M.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight};M.prototype._overridePreserveHeaderStateOnScroll=function(){var e=this._bHeaderBiggerThanAllowedHeight,t;this._bHeaderBiggerThanAllowedHeight=this._headerBiggerThanAllowedToBeFixed();t=e!==this._bHeaderBiggerThanAllowedHeight;if(!this._bHeaderBiggerThanAllowedHeight||!t){return}if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true)}else{this._snapHeader(true)}this._adjustHeaderHeights();this._requestAdjustLayout()};M.prototype._hasDynamicTitle=function(){var e=this.getHeaderTitle();return e&&e.isDynamic()};M.prototype._attachVisualIndicatorsPressHandlers=function(e,t){var i=this.getHeaderTitle(),o=this._getHeaderContent();if(k(i)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){i.attachEvent(M.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){e.call(t);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator()}this._focusCollapseVisualIndicator()},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true}if(k(o)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){o.attachEvent(M.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){e.call(t);this._focusExpandVisualIndicator()},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true}};M.prototype._hasVisibleDynamicTitleAndHeader=function(){var e=this.getHeaderTitle(),t=this.getHeaderContent();return this._hasVisibleDynamicTitle(e)&&this._hasVisibleHeaderContent(t)};M.prototype._hasVisibleDynamicTitle=function(e){return k(e)&&e.isDynamic()&&e.getVisible()};M.prototype._hasVisibleHeaderContent=function(e){return k(e)&&e.length>0&&this.getShowHeaderContent()};M.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var e=this.getHeaderTitle();return k(e)&&e.isDynamic()&&!!e.getSnappedTitleOnMobile()&&g.system.phone};M.prototype._updateToggleHeaderVisualIndicators=function(){var e,t,i,o=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!o){t=false;i=false}else{e=this._bHeaderExpanded;t=e;i=!e&&!this._hasDynamicTitleWithSnappedTitleOnMobile()}this._toggleCollapseVisualIndicator(t);this._toggleExpandVisualIndicator(i)};M.prototype._updateTitleVisualState=function(){var e=this.getHeaderTitle(),t=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",t);if(k(e)){e._toggleFocusableState(t)}};M.prototype._focusCollapseVisualIndicator=function(){var e=this._getHeaderContent();if(k(e)){e._focusCollapseButton()}};M.prototype._focusExpandVisualIndicator=function(){var e=this.getHeaderTitle();if(k(e)){e._focusExpandButton()}};M.prototype._toggleExpandVisualIndicator=function(e){var t=this.getHeaderTitle();if(k(t)){t._toggleExpandButton(e)}};M.prototype._toggleCollapseVisualIndicator=function(e){var t=this._getHeaderContent();if(k(t)){t._toggleCollapseButton(e)}};M.prototype._attachVisualIndicatorMouseOverHandlers=function(e,t,i){var o=this._getHeaderContent();if(k(o)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){o.attachEvent(M.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,e,i);o.attachEvent(M.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,t,i);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true}};M.prototype._attachTitleMouseOverHandlers=function(e,t,i){var o=this.getHeaderTitle();if(k(o)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){o.attachEvent(M.EVENTS.TITLE_MOUSE_OVER,e,i);o.attachEvent(M.EVENTS.TITLE_MOUSE_OUT,t,i);this._bAlreadyAttachedTitleMouseOverOutHandler=true}};M.prototype._suppressScroll=function(){this._bSuppressScroll=true};M.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0)}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}})}};M.prototype._addHoverClass=function(){var e=this.$();if(e){e.addClass("sapUxAPObjectPageLayoutTitleForceHovered")}};M.prototype._removeHoverClass=function(){var e=this.$();if(e){e.removeClass("sapUxAPObjectPageLayoutTitleForceHovered")}};M.prototype._getHeight=function(e){return!(e instanceof c)?0:e.$().outerHeight()||0};M.prototype._getWidth=function(e){var t=e.getDomRef();return!(e instanceof c)?0:t&&t.offsetWidth||0};M.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty};M.prototype._setSectionInfoIsDirty=function(e){this.bSectionInfoIsDirty=e};M.prototype._getAriaLabelText=function(e,t){var i=this.getHeaderTitle(),o=i?i.getTitleText():null,n;if(i&&o&&e!=="ROOT"){n=o;if(t){n+=" "+M._getLibraryResourceBundle().getText(e+"_ARIA_LABEL_WITH_TITLE")}}else{n=M._getLibraryResourceBundle().getText(e+"_ARIA_LABEL_WITHOUT_TITLE")}return n};M.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){var e=this.$("footerWrapper").get(0),t=this._getDOMRefHeight(e),i=e?parseFloat(getComputedStyle(e).marginBottom):0;return t+i}return 0};M.prototype._getDOMRefHeight=function(e){return e&&e.parentElement?e.getBoundingClientRect().height:0};M.prototype._updateAriaLabels=function(){var e=this.getLandmarkInfo(),t=this._getAriaLabelText("ROOT",true),i=this._getAriaLabelText("HEADER",true),o=this._getAriaLabelText("NAVIGATION",false),n=this._getAriaLabelText("NAVTOOLBAR",true),r=e&&e.getHeaderLabel(),s=e&&e.getRootLabel(),a=e&&e.getNavigationLabel();if(!s){this.$().attr("aria-label",t)}if(!r){this.$("headerTitle").attr("aria-label",i)}if(!a){this.$("anchorBar").attr("aria-label",o);this.$("stickyAnchorBar").attr("aria-label",o)}this.$("anchBar").attr("aria-label",n)};M.prototype._formatLandmarkInfo=function(e,t){if(e){var i=e["get"+t+"Role"]()||"",o=e["get"+t+"Label"]()||"";if(i===F.None){i=""}return{role:i.toLowerCase(),label:o}}return{}};M.prototype._getHeaderTag=function(e){if(e&&e.getHeaderRole()!==F.None){return M.DIV}return M.HEADER};M.prototype._getFooterTag=function(e){if(e&&e.getFooterRole()!==F.None){return M.DIV}return M.FOOTER};function k(e){if(arguments.length===1){return Array.isArray(e)?e.length>0:!!e}return Array.prototype.slice.call(arguments).every(function(e){return k(e)})}return M});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageLayoutABHelper", ["sap/ui/core/Element","sap/ui/base/Object","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectObserver","sap/m/IconTabFilter","sap/m/IconTabHeader","sap/m/library","sap/uxap/ObjectPageSection"],function(t,e,o,r,n,a,i,s){"use strict";var c=i.TabsOverflowMode;var g=i.IconTabHeaderMode;var u=e.extend("sap.uxap._helpers.AB",{constructor:function(t){this._oObjectPageLayout=t;this._oObserver=new r(this._proxyStateChanges.bind(this))},getInterface:function(){return this}});u._focusSection=function(t,e){var o=t.getDomRef();if(o){o.focus(e)}};u.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout};u.prototype._getAnchorBar=function(){var t=this.getObjectPageLayout(),e=t.getAggregation("_anchorBar"),r=t.getUpperCaseAnchorBar();if(!e){e=new a({id:t.getId()+"-anchBar",tabsOverflowMode:c.StartAndEnd,backgroundDesign:o.escapeSettingsValue(t.getBackgroundDesignAnchorBar()),mode:g.Inline});e.attachSelect(function(e){var o=e.getParameter("key");this._moveFocusOnSection(o);t.onAnchorBarTabPress(o)}.bind(this));e.addEventDelegate({onAfterRendering:function(){t._adjustTitlePositioning();this._clearAnchorBarFixedHeight(e)}.bind(this)});if(r){e.addStyleClass("sapUxAPAnchorBarUpperCase")}this.getObjectPageLayout().setAggregation("_anchorBar",e,true)}return e};u.prototype._fixAnchorBarHeight=function(t){var e=t.getDomRef()?.parentNode;if(e){e.style.height=e.clientHeight+"px"}};u.prototype._clearAnchorBarFixedHeight=function(t){var e=t.getDomRef()?.parentNode;if(e){e.style.height="auto"}};u.prototype._buildAnchorBar=function(){var t=this.getObjectPageLayout(),e=this._getAnchorBar(),r=t.getUpperCaseAnchorBar();this.resetControl();this._oObserver.disconnect();t._getVisibleSections().forEach(function(a){var i=e.getId()+"-"+a.getId()+"-anchor",s=new n(i,{text:o.escapeSettingsValue(a._getTitle()),key:a.getId(),iconColor:o.escapeSettingsValue(a.getAnchorBarButtonColor())}),c=a._getVisibleSubSections();this._setupCustomButtonForwarding(a,s,r);if(t.getShowAnchorBarPopover()){if(c.length>1){c.forEach(function(t){var r=e.getId()+"-"+t.getId()+"-anchor",a=new n(r,{text:o.escapeSettingsValue(t._getTitle()),key:t.getId()});s.addItem(a);this._setupCustomButtonForwarding(t,a)},this)}else if(c.length===1&&!a.getCustomAnchorBarButton()&&c[0]._getTitle()?.trim()){s.setText(c[0]._getTitle());this._setupCustomButtonForwarding(c[0],s,r)}}e.addItem(s)},this);t.setAggregation("_anchorBar",e)};u.prototype._setupCustomButtonForwarding=function(t,e,o){var r=t.getCustomAnchorBarButton();if(!r){return}e.setText(r.getText());e.setIcon(r.getIcon());this._oObserver.observe(r,{properties:true});this._getAnchorBar().attachSelect(function(t){this._forwardPressToCustomButton(t.getParameter("item"))},this)};u.prototype._forwardPressToCustomButton=function(e){var o=e.getKey(),r=t.getElementById(o),n=r?.getCustomAnchorBarButton();if(n){n.firePress()}};u.prototype.resetControl=function(){var t=this._getAnchorBar();this._fixAnchorBarHeight(t);t.destroyItems()};u.prototype.selectAnchorForSection=function(t){var e=sap.ui.getCore().byId(t),o;if(!e){return}o=e.isA("sap.uxap.ObjectPageSubSection");if(o){t=e.getParent().getId()}this._getAnchorBar().setSelectedKey(t)};u.prototype._setAnchorButtonsTabFocusValues=function(t){var e=this._getAnchorBar().getItems(),o,r="0",n="-1",a="tabIndex";e.forEach(function(e){o=e.$();if(e.getKey()===t){o.attr(a,r)}else{o.attr(a,n)}})};u.prototype._moveFocusOnSection=function(e){var o=t.getElementById(e),r,n,a={preventScroll:true},i;if(!o){return}if(!o.isActive()){i={onAfterRendering:function(){o.removeEventDelegate(i);u._focusSection(o,a)}};o.addEventDelegate(i);return}r=s._getClosestSection(o);n=this._getAnchorBar().getItems().find(t=>t.getKey()===r.getId());if(document.activeElement!==n.getDomRef()){i={onfocusin:function(){n.removeEventDelegate(i);u._focusSection(o,a)}};n.addEventDelegate(i)}u._focusSection(o,a)};u.prototype._proxyStateChanges=function(t){var e=t.object,o=e.getParent(),r=this._findAnchorForSectionBase(o),n=t.name,a=t.current,i="set"+h(n);if(r){r[i].call(r,a)}};u.prototype._findAnchorForSectionBase=function(t){var e=t?.getId(),o=this._getAnchorBar(),r=o.getItems(),n,a=function(t){return t.some(function(t){if(t.getKey()===e){n=t;return true}return a(t.getItems())})};a(r);return n};function h(t){return t.substring(0,1).toUpperCase()+t.substring(1)}return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageLayoutRenderer", ["sap/ui/core/Lib"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,a){var r,n=a.getHeaderTitle(),o=null,s=e.getResourceBundleFor("sap.uxap"),i=a.getHeaderContent()&&a.getHeaderContent().length>0&&a.getShowHeaderContent(),l=a.getShowTitleInHeaderContent()&&a.getShowHeaderContent(),c=i||l,d=a.getUseIconTabBar(),g=a.getToggleHeaderOnTitleClick()&&a.getHeaderTitle()&&a.getHeaderTitle().supportsToggleHeaderOnTitleClick(),p=a._getAriaLabelText("ROOT",true),f=a._getAriaLabelText("HEADER",true),u=a.getBackgroundDesignAnchorBar(),C=a.getLandmarkInfo(),P=a._getHeaderTag(C),A=a._getFooterTag(C),h=C&&C.getHeaderRole(),b=C&&C.getHeaderLabel(),I=C&&C.getRootRole(),O=C&&C.getRootLabel(),T=a.getShowFooter();if(a.getShowAnchorBar()&&a._getInternalAnchorBarVisible()){o=a.getAggregation("_anchorBar")}t.openStart("div",a);if(!I){t.attr("role","main")}t.attr("aria-roledescription",s.getText("ROOT_ROLE_DESCRIPTION"));if(!O){t.attr("aria-label",p)}t.class("sapUxAPObjectPageLayout");if(T){t.class("sapUxAPObjectPageLayoutFooterVisible")}if(g){t.class("sapUxAPObjectPageLayoutTitleClickEnabled")}if(!c){t.class("sapUxAPObjectPageLayoutNoHeaderContent")}if(!o||!o.getVisible()){t.class("sapUxAPObjectPageLayoutNoAnchorBar")}t.style("height",a.getHeight());t.accessibilityState(a,a._formatLandmarkInfo(C,"Root"));t.openEnd();t.openStart(P,a.getId()+"-headerTitle");if(!h){t.attr("role","banner")}t.attr("aria-roledescription",s.getText("HEADER_ROLE_DESCRIPTION"));if(!b){t.attr("aria-label",f)}t.attr("data-sap-ui-customfastnavgroup",true).class("sapUxAPObjectPageHeaderTitle").class("sapContrastPlus").accessibilityState(a,a._formatLandmarkInfo(C,"Header")).openEnd();if(n){t.renderControl(n)}this._renderHeaderContentDOM(t,a,a._bHeaderInTitleArea,"-stickyHeaderContent");t.openStart("div",a.getId()+"-stickyAnchorBar");t.attr("data-sap-ui-customfastnavgroup",true);t.attr("aria-roledescription",s.getText("NAVIGATION_ROLE_DESCRIPTION"));if(!a._bHeaderInTitleArea){t.attr("aria-hidden","true")}t.class("sapUxAPObjectPageStickyAnchorBar").class("sapUxAPObjectPageNavigation").class("ui-helper-clearfix");if(u){t.class("sapUxAPObjectPageNavigation"+u)}t.accessibilityState(a,a._formatLandmarkInfo(C,"Navigation"));t.openEnd();this._renderAnchorBar(t,a,o,a._bHeaderInTitleArea);t.close("div");t.close(P);t.openStart("div",a.getId()+"-opwrapper").class("sapUxAPObjectPageWrapper");if(n&&(!n.supportsTitleInHeaderContent()||!(a.getShowTitleInHeaderContent()&&n.getShowTitleSelector()))){t.class("sapUxAPObjectPageWrapperWillChangeScrollTop")}t.openEnd();t.openStart("div",a.getId()+"-scroll").class("sapUxAPObjectPageScroll").openEnd();this._renderHeaderContentDOM(t,a,!a._bHeaderInTitleArea,"-headerContent",true);t.openStart("section",a.getId()+"-anchorBar");t.attr("data-sap-ui-customfastnavgroup",true);t.attr("aria-roledescription",s.getText("NAVIGATION_ROLE_DESCRIPTION"));t.class("sapUxAPObjectPageNavigation").class("ui-helper-clearfix").class("sapContrastPlus");if(u){t.class("sapUxAPObjectPageNavigation"+u)}t.accessibilityState(a,a._formatLandmarkInfo(C,"Navigation"));t.openEnd();this._renderAnchorBar(t,a,o,!a._bHeaderInTitleArea);t.close("section");t.openStart("section",a.getId()+"-sectionsContainer");t.class("sapUxAPObjectPageContainer");t.class("ui-helper-clearfix");if(!o){t.class("sapUxAPObjectPageContainerNoBar")}t.accessibilityState(a,a._formatLandmarkInfo(C,"Content"));t.openEnd();r=a._getSectionsToRender();if(Array.isArray(r)){r.forEach(function(e){t.renderControl(e);if(d){a._oCurrentTabSection=e}})}t.close("section");this.renderFooterContent(t,a);t.openStart("div",a.getId()+"-spacer").openEnd().close("div");t.close("div");t.close("div");this._renderFooterContentInternal(t,a,A,C,s);t.close("div")};t._renderAnchorBar=function(e,t,a,r){var n=t.getAggregation("sections"),o;if(r){o=t._getHeaderContent();if(t.getIsChildPage()&&o&&o.supportsChildPageDesign()){e.openStart("div",t.getId()+"-childPageBar");if(Array.isArray(n)&&n.length>1){e.class("sapUxAPObjectChildPage")}e.openEnd();e.close("div")}if(a){e.renderControl(a)}}};t._renderHeaderContentDOM=function(e,t,a,r,n){e.openStart("header",t.getId()+r).class("ui-helper-clearfix").class("sapUxAPObjectPageHeaderDetails");e.class("sapUxAPObjectPageHeaderDetailsDesign-"+t._getHeaderDesign());if(n){e.class("sapContrastPlus")}e.attr("data-sap-ui-customfastnavgroup",true).openEnd();if(a){this.renderHeaderContent(e,t)}e.close("header")};t.renderHeaderContent=function(e,t){e.renderControl(t._getHeaderContent())};t.renderFooterContent=function(e,t){};t._renderFooterContentInternal=function(e,t,a,r,n){var o=t.getFooter(),s=r&&r.getFooterRole();if(!o){return}e.openStart(a,t.getId()+"-footerWrapper");e.class("sapUxAPObjectPageFooter").class("sapMFooter-CTX").class("sapContrast").class("sapContrastPlus");if(!t.getShowFooter()){e.class("sapUiHidden")}if(!s){e.attr("role","region")}e.attr("aria-roledescription",n.getText("FOOTER_ROLE_DESCRIPTION"));e.accessibilityState(t,t._formatLandmarkInfo(r,"Footer"));e.openEnd();o.addStyleClass("sapUxAPObjectPageFloatingFooter");e.renderControl(o);e.close(a)};t._rerenderHeaderContentArea=function(e,t){var a=t._bHeaderInTitleArea?"stickyHeaderContent":"headerContent",r;this.renderHeaderContent(e,t);r=t.$(a)[0];if(r){e.flush(r)}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageLazyLoader", ["./library","sap/ui/core/Element","sap/ui/core/StashedControlSupport","sap/base/assert","sap/ui/base/Object"],function(e,t,a,n,r){"use strict";var s=t.extend("sap.uxap.ObjectPageLazyLoader",{metadata:{library:"sap.uxap",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},defaultAggregation:"content"}});a.mixInto(s);s.prototype.setParent=function(e){if(!(e===null||r.isObjectA(e,"sap.uxap.ObjectPageSubSection"))){n(false,"setParent(): oParent must be an instance of sap.uxap.ObjectPageSubSection or null")}return t.prototype.setParent.apply(this,arguments)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSection", ["./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/ResizeHandler","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","./ObjectPageSubSection","./library","sap/m/library","./ObjectPageSectionRenderer","sap/ui/core/library"],function(t,e,i,o,n,s,r,a,u,l,p,h,d){"use strict";var c=p.ButtonType;var g=d.IconColor;var _=t.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true},wrapTitle:{type:"boolean",group:"Appearance",defaultValue:false},anchorBarButtonColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:g.Default}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection",forwarding:{getter:"_getGrid",aggregation:"content"}},heading:{type:"sap.ui.core.Control",multiple:false},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}},designtime:"sap/uxap/designtime/ObjectPageSection.designtime"},renderer:h});_.MEDIA_RANGE=e.media.RANGESETS.SAP_STANDARD;_._getClosestSection=function(t){var e=typeof t==="string"&&o.getElementById(t)||t;return e instanceof u?e.getParent():e};_._getLibraryResourceBundle=function(){return n.getResourceBundleFor("sap.uxap")};_.prototype.getSectionText=function(t){return _._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME")};_.prototype._expandSection=function(){t.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections())};_.prototype.init=function(){t.prototype.init.call(this);this._sContainerSelector=".sapUxAPObjectPageSectionContainer";this._onResizeRef=this._onResize.bind(this);this._oGridContentObserver=new a(this._onGridContentChange.bind(this))};_.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this);if(this._iResizeHandlerId){s.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}if(t.prototype.exit){t.prototype.exit.call(this)}};_.prototype._onResize=function(){this._updateMultilineContent()};_.prototype._getImportanceLevelToHide=function(t){var e=this._getObjectPageLayout(),i=t||this._getCurrentMediaContainerRange(),o=e&&e.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(i.name,o)};_.prototype._updateImportance=function(t){var e=this._getObjectPageLayout(),i=this._getImportanceLevelToHide(t),o=this.bOutput&&this.getDomRef("header");this.getSubSections().forEach(function(t){t._applyImportanceRules(i)});this._applyImportanceRules(i);this._updateShowHideAllButton(false);o&&o.classList.toggle("sapUxAPObjectPageSectionHeaderHidden",!this._isTitleVisible());o&&o.setAttribute("aria-hidden",!this._isTitleAriaVisible());if(e&&this.getDomRef()){e._requestAdjustLayout()}};_.prototype._updateMultilineContent=function(){var t=this.getSubSections(),e=t.find(function(t){return t.getVisible()});if(e&&e.getDomRef()){var i=e._getTitleDomId(),o,n,s,r,a;if(!i){return}a=document.getElementById(e._getTitleDomId());o=a?a.offsetWidth:0;n=this.$().find(".sapUxAPObjectPageSubSectionHeaderActions").width();s=this.$("header").width();r=o+n>s;e._toggleMultiLineSectionContent(r)}};_.prototype._determineTheLowestLevelOfImportanceToShow=function(t,e){if(e||t==="Phone"){return l.Importance.High}if(t==="Tablet"){return l.Importance.Medium}return l.Importance.Low};_.prototype.connectToModels=function(){this.getSubSections().forEach(function(t){t.connectToModels()})};_.prototype.connectToModelsAsync=function(){var t=[];this.getSubSections().forEach(function(e){t.push(e.connectToModelsAsync())});return Promise.all(t)};_.prototype._allowPropagationToLoadedViews=function(t){this.getSubSections().forEach(function(e){e._allowPropagationToLoadedViews(t)})};_.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.call(this);this._detachMediaContainerWidthChange(this._updateImportance,this);this._updateImportance();this._applyLayout()};_.prototype.onAfterRendering=function(){this._updateMultilineContent();this._attachMediaContainerWidthChange(this._updateImportance,this);this._iResizeHandlerId=s.register(this,this._onResizeRef)};_.prototype._applyLayout=function(){var t={M:2,L:3,XL:4},e=this.getSubSections();this._resetLayoutData(e);this._assignLayoutData(e,t);return this};_.prototype.setAnchorBarButtonColor=function(t){if(t!==this.getProperty("anchorBarButtonColor")){this.setProperty("anchorBarButtonColor",t,true);this._notifyObjectPageLayout()}return this};_.prototype._getMinRequiredColspanForChild=function(t){return t?t._getMinRequiredColspan():0};_.prototype._allowAutoextendColspanForChild=function(t){return true};_.prototype._onGridContentChange=function(t){var e;if(t.type==="aggregation"&&["content","subSections"].indexOf(t.name)>-1){this.invalidate();e=t.mutation;if(e==="add"||e==="insert"){this._oGridContentObserver.observe(t.child,{properties:["visible","importance"]})}else if(t.mutation==="remove"){this._oGridContentObserver.unobserve(t.child)}}if(t.type==="property"){if(t.name==="visible"){this.invalidate()}else if(t.name==="importance"){this.setTitleVisible()}}};_.prototype._isTitleVisible=function(){return this.getShowTitle()&&this._getInternalTitleVisible()||this._getInternalTitleForceVisible()};_.prototype._isTitleAriaVisible=function(){return this.getShowTitle()||this._getInternalTitleForceVisible()};_.prototype._getInternalTitleForceVisible=function(){return this._getShouldDisplayExpandCollapseButton()||this._getShouldDisplayShowHideAllButton()};_.prototype._setSubSectionsFocusValues=function(){var t=this._getVisibleSubSections()||[],e=this.getSelectedSubSection(),i;if(t.length===0){return this}if(t.length===1){t[0]._setToFocusable(false);return this}t.forEach(function(t){if(e===t.getId()&&t._shouldBeFocusable()){t._setToFocusable(true);i=true}else{t._setToFocusable(false)}});if(!i){var o=t.find(function(t){return t._shouldBeFocusable()});if(o){o._setToFocusable(true)}}return this};_.prototype._disableSubSectionsFocus=function(){var t=this.getSubSections()||[];t.forEach(function(t){t._setToFocusable(false)});return this};_.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(t){return t._getIsHidden()})};_.prototype._updateShowHideSubSections=function(t){this.getSubSections().forEach(function(e){if(t&&e._shouldBeHidden()){e._updateShowHideState(true)}else if(!t){e._updateShowHideState(false)}})};_.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(t){return t._shouldBeHidden()})};_.prototype._getShouldDisplayExpandCollapseButton=function(){return this._getIsHidden()};_.prototype._showHideContentAllContent=function(){var t=this._thereAreHiddenSubSections();if(this._getIsHidden()&&t){this._updateShowHideState(false)}this._updateShowHideSubSections(!t);this._updateShowHideAllButton(t)};_.prototype._updateShowHideState=function(e){if(this._getIsHidden()===e){return this}this._updateShowHideButton(e);this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return t.prototype._updateShowHideState.call(this,e)};_.prototype._updateShowHideAllButton=function(t){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(t))};_.prototype._getVisibleSubSections=function(){return this.getSubSections().filter(function(t){return t.getVisible()&&t._getInternalVisible()})};_.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new i({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true)}return this.getAggregation("_showHideAllButton")};_.prototype._getShowHideButtonText=function(t){return _._getLibraryResourceBundle().getText(t?"HIDE":"SHOW")};_.prototype._getShowHideAllButtonText=function(t){return _._getLibraryResourceBundle().getText(t?"HIDE_ALL":"SHOW_ALL")};_.prototype._updateShowHideButton=function(t){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!t))};_.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new i({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true)}return this.getAggregation("_showHideButton")};r.mixInto(_);return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSectionBase", ["sap/base/i18n/Localization","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","./library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/dom/jquery/Focusable"],function(t,e,i,jQuery,n,o,r,a,s,l,u){"use strict";var p=o.TitleLevel;var c=n.extend("sap.uxap.ObjectPageSectionBase",{metadata:{abstract:true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:p.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},titleVisible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:r.Importance.High}},aggregations:{ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},customAnchorBarButton:{type:"sap.m.Button",multiple:false},_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:null});c.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=p.Auto;this._isHidden=false;this._oGridContentObserver=null;this._bRtl=t.getRTL()};c.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){a.debug("ObjectPageSectionBase :: cannot adjustLayout",this)});this._getObjectPageLayout()._setSectionsFocusValues()}};c.prototype.onBeforeRendering=function(){var t="ariaLabelledBy";if(!this.getAggregation(t)){this.setAggregation(t,this._getAriaLabelledBy(),true)}else{this.updateInvisibleTextLabelValue()}this._getObjectPageLayout()?._setSectionInfoIsDirty(true)};c.prototype.exit=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};c.prototype.setShowTitle=function(t){this.setProperty("showTitle",t);this.setTitleVisible();return this};c.prototype.getEffectiveTitleLevel=function(){return this._getTitleLevel()};c.prototype.setTitleVisible=function(t){return this.setProperty("titleVisible",this._isTitleVisible(),true)};c.prototype._getGrid=function(){if(!this.getAggregation("_grid")&&!this._bIsBeingDestroyed){this.setAggregation("_grid",new l({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);if(this._oGridContentObserver){this._oGridContentObserver.observe(this.getAggregation("_grid"),{aggregations:["content","subSections"]})}}return this.getAggregation("_grid")};c.prototype._resetLayoutData=function(t){t.forEach(function(t){if(t?.getLayoutData?.()){t.destroyLayoutData()}},this)};c.prototype._assignLayoutData=function(t,e){var i=12,n=[],o=[],r,a,s,l;r={iRemaining:e.M,iColumnConfig:e.M};a={iRemaining:e.L,iColumnConfig:e.L};s={iRemaining:e.XL,iColumnConfig:e.XL};l=[s,a,r];t.forEach(function(t){if(!t){return}if(t.getVisible?.()){n.push(t)}else{o.push(t)}});n.forEach(function(t,e){l.forEach(function(i){i.iCalculatedSize=this._getEffectiveColspanForGridItem(t,i.iRemaining,n,e,i.iColumnConfig)},this);t.setLayoutData(new u({spanS:i,spanM:r.iCalculatedSize*(i/r.iColumnConfig),spanL:a.iCalculatedSize*(i/a.iColumnConfig),spanXL:s.iCalculatedSize*(i/s.iColumnConfig),linebreakM:e>0&&r.iRemaining===r.iColumnConfig,linebreakL:e>0&&a.iRemaining===a.iColumnConfig,linebreakXL:e>0&&s.iRemaining===s.iColumnConfig}));if(t.isA("sap.uxap.ObjectPageSubSection")){t._oLayoutConfig={M:r.iCalculatedSize,L:a.iCalculatedSize,XL:s.iCalculatedSize}}l.forEach(function(t){t.iRemaining-=t.iCalculatedSize;if(t.iRemaining<1){t.iRemaining=t.iColumnConfig}})},this);o.forEach(function(t){t.setLayoutData?.(new u({visibleS:false,visibleM:false,visibleL:false,visibleXL:false}))});return n};c.prototype._getEffectiveColspanForGridItem=function(t,e,i,n,o){var r,a=o,s,l=this._getMinRequiredColspanForChild(t);if(!this._allowAutoextendColspanForChild(t)){return Math.min(o,l)}for(s=1;s<=a;s++){r=this._getMinRequiredColspanForChild(i[n+s]);if(r<=e-l){e-=r}else{break}}return e};c.prototype._getMinRequiredColspanForChild=function(t){};c.prototype._allowAutoextendColspanForChild=function(t){};c.prototype.setCustomAnchorBarButton=function(t){var e=this.setAggregation("customAnchorBarButton",t,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation()}return e};c.prototype.getSectionText=function(){return""};c.prototype.updateInvisibleTextLabelValue=function(){var t=this.getAggregation("ariaLabelledBy"),i=this._getAriaLabelledByText();if(t){e.getElementById(t.getId()).setText(i)}return this};c.prototype._getAriaLabelledBy=function(){var t=this._getAriaLabelledByText();return this._getInvisibleText().setText(t)};c.prototype._getAriaLabelledByText=function(){return this._getTitle()};c.prototype._getInvisibleText=function(){if(!this._oInvisibleText){this._oInvisibleText=new i;this._oInvisibleText.toStatic()}return this._oInvisibleText};c.prototype._getShouldLabelTitle=function(){return this.getShowTitle?this.getShowTitle():true};c.prototype._setInternalVisible=function(t,e){if(t!=this._bInternalVisible){this._bInternalVisible=t;if(e){this.invalidate()}}};c.prototype._getInternalVisible=function(){return this._bInternalVisible};c.prototype._setInternalTitleVisible=function(t,e){if(t!=this._bInternalTitleVisible){this._bInternalTitleVisible=t;this.setTitleVisible();if(e){this.invalidate()}}};c.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible};c.prototype._setInternalTitle=function(t,e){if(t!=this._sInternalTitle){this._sInternalTitle=t;if(e){this.invalidate()}}};c.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle()};c.prototype._getInternalTitle=function(){return this._sInternalTitle};c.prototype._getARIALevel=function(){var t=this._getTitleLevel();if(t===p.Auto){t=p.H2}return t.slice(-1)};c.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return t===p.Auto?this._getInternalTitleLevel():t};c.prototype._setInternalTitleLevel=function(t,e){if(t!==this._sInternalTitleLevel){this._sInternalTitleLevel=t;if(e){this.invalidate()}}};c.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel};c.prototype._getObjectPageLayout=function(){return r.Utilities.getClosestOPL(this)};c.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules()}};["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(t){c.prototype[t]=function(e,i,o,r){if(["addAggregation","removeAggregation"].indexOf(t)>-1){r=o}if(["removeAllAggregation","destroyAggregation"].indexOf(t)>-1){r=i}var a=n.prototype[t].apply(this,arguments);if(r!==true){this._notifyObjectPageLayout()}return a}});c.prototype.setVisible=function(t,e){if(this.getVisible()===t){return this}if(!this._getObjectPageLayout()){return this.setProperty("visible",t,e)}this.setProperty("visible",t,true);this._notifyObjectPageLayout();this.invalidate();return this};c.prototype.setTitle=function(t,e){this.setProperty("title",t,e);this._notifyObjectPageLayout();this.updateInvisibleTextLabelValue();return this};c.prototype._shouldBeHidden=function(){return c._importanceMap[this.getImportance()]>c._importanceMap[this._sCurrentLowestImportanceLevelToShow]};c._importanceMap={Low:3,Medium:2,High:1};c.prototype._updateShowHideState=function(t){var e=this._getObjectPageLayout();this._isHidden=t;this.setTitleVisible();this.$().children(this._sContainerSelector).toggle(!t);if(e){e._requestAdjustLayout()}return this};c.prototype._getIsHidden=function(){return this._isHidden};c.prototype._expandSection=function(){return this._updateShowHideState(false)};c.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden())};c.prototype._applyImportanceRules=function(t){this._sCurrentLowestImportanceLevelToShow=t;this.setTitleVisible();if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden())}else{this._isHidden=this._shouldBeHidden();this.setTitleVisible()}};c.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;c.prototype.onkeydown=function(t){if(t.keyCode===s.SPACE&&t.srcControl.isA("sap.uxap.ObjectPageSection")){t.preventDefault()}if(t.keyCode===s.F7){var e=this.getSubSections(),i=e[0],n;if(e.length===1){n=i._oLastFocusedControlF7;if(n){n.$().trigger("focus")}else{i.$().firstFocusableDomRef().focus()}}else{if(i.getActions().length){i.getActions()[0].$().trigger("focus")}}}};c.prototype.onsapdown=function(t){var e=t.currentTarget,i=e.nextSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.nextElementSibling){i=n.nextElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};c.prototype._handleFocusing=function(t,e){var i;if(this._targetIsCorrect(t)&&e){i=jQuery(t.currentTarget).parent().children();t.preventDefault();e.focus();if(i.length>1){this._scrollParent(jQuery(e).attr("id"))}}};c.prototype._targetIsCorrect=function(t){return t.srcControl===this};c.prototype.onsapright=function(t){var e=this._bRtl?"onsapup":"onsapdown";this[e](t)};c.prototype.onsapup=function(t){var e=t.currentTarget,i=e.previousSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.previousElementSibling){i=n.previousElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};c.prototype.onsapleft=function(t){var e=this._bRtl?"onsapdown":"onsapup";this[e](t)};c.prototype.onsaphome=function(t){var e=t.currentTarget,i=e.parentElement.firstChild;if(e.classList.contains("sapUxAPObjectPageSubSection")){i=e.closest(".sapUxAPObjectPageSection").querySelector(".sapUxAPObjectPageSubSection")}this._handleFocusing(t,i)};c.prototype.onsapend=function(t){var e=t.currentTarget,i=e.parentElement.lastChild,n;if(e.classList.contains("sapUxAPObjectPageSubSection")){n=e.closest(".sapUxAPObjectPageSection").querySelectorAll(".sapUxAPObjectPageSubSection");i=n[n.length-1]}this._handleFocusing(t,i)};c.prototype.onsappageup=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i-(c.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[0]){n[0].focus();o=jQuery(n[0]).attr("id")}if(n.length>1){this._scrollParent(o)}};c.prototype.onsappagedown=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i+c.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[n.length-1]){n[n.length-1].focus();o=jQuery(n[n.length-1]).attr("id")}if(n.length>1){this._scrollParent(o)}};c.prototype._scrollParent=function(t){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(t,0,10)}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSectionRenderer", ["sap/ui/core/ControlBehavior"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,i){var a,n,r,s=e.isAccessibilityEnabled(),o=i.getAggregation("ariaLabelledBy"),l=i.getHeading(),c=i.getWrapTitle();if(!i.getVisible()||!i._getInternalVisible()){return}a=i._getTitle();n=i.getTitleVisible();r=!i._isTitleAriaVisible();t.openStart("section",i).class("sapUxAPObjectPageSection");if(!n){t.class("sapUxAPObjectPageSectionNoTitle")}if(c){t.class("sapUxAPObjectPageSectionWrapTitle")}t.attr("role","region");if(s&&o){t.attr("aria-labelledby",o.getId())}t.attr("data-sap-ui-customfastnavgroup",true);t.openEnd();if(l){t.openStart("div").class("sapUxAPObjectPageSectionHeading").openEnd();t.renderControl(l);t.close("div")}t.openStart("div",i.getId()+"-header").attr("role","heading").attr("aria-level",i._getARIALevel()).class("sapUxAPObjectPageSectionHeader").class(n?"":"sapUxAPObjectPageSectionHeaderHidden");if(r){t.attr("aria-hidden","true")}t.openEnd();t.openStart("div",i.getId()+"-title").class("sapUxAPObjectPageSectionTitle");if(i.getTitleUppercase()){t.class("sapUxAPObjectPageSectionTitleUppercase")}t.openEnd();t.text(a);t.close("div");if(n){t.renderControl(i._getShowHideAllButton());t.renderControl(i._getShowHideButton())}t.close("div");t.openStart("div").class("sapUxAPObjectPageSectionContainer");if(i._isHidden){t.style("display","none")}t.openEnd();t.renderControl(i._getGrid());t.close("div");t.close("section")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSubSection", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/thirdparty/jquery","sap/ui/core/ResizeHandler","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","sap/m/TitlePropagationSupport","./library","sap/m/library","./ObjectPageSubSectionRenderer","sap/base/Log","sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(t,e,jQuery,o,i,s,r,n,a,h,l,u,g,c,p,f,d){"use strict";var _=g.ButtonType;var y=u.ObjectPageSubSectionMode;var S=u.ObjectPageSubSectionLayout;var b=i.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},_columnSpan:{type:"string",group:"Appearance",defaultValue:"all",visibility:"hidden"},mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:y.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"},renderer:c});l.call(b.prototype,"blocks",function(){return this._getTitleDomId()});b.FIT_CONTAINER_CLASS="sapUxAPObjectPageSubSectionFitContainer";b.COLUMN_SPAN={all:"all",auto:"auto"};b._getLibraryResourceBundle=function(){return e.getResourceBundleFor("sap.uxap")};b.prototype.init=function(){i.prototype.init.call(this);this._aStashedControls=[];this._aUnStashedControls=[];this._bUnstashed=false;this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._sMoreContainerSelector=".sapUxAPSubSectionSeeMoreContainer";this._oObserver=new h(b.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._oBlocksObserver=new h(this._onBlocksChange.bind(this));this._switchSubSectionMode(this.getMode());this._initTitlePropagationSupport();this._sBorrowedTitleDomId=false;this._height=""};b.prototype.getParent=function(){var t=i.prototype.getParent.apply(this,arguments);if(t&&t.isA("sap.ui.layout.Grid")){t=t.getParent()}return t};b.prototype.setParent=function(){var t=i.prototype.setParent.apply(this,arguments),e=this.getParent();if(e&&e.isA("sap.uxap.ObjectPageSection")&&this.sParentAggregationName!=="subSections"){this.sParentAggregationName="subSections"}return t};b.prototype.setTitle=function(t,e){i.prototype.setTitle.apply(this,arguments);this.setTitleVisible();return this};b.prototype._isTitleVisible=function(){return this._getInternalTitleVisible()&&this.getTitle().trim()!==""&&this.getShowTitle()};b.prototype._getColumnSpan=function(){return this.getProperty("_columnSpan")};b.prototype._setColumnSpan=function(t){var e=this.getProperty("_columnSpan"),o;if(e===t){return}this.setProperty("_columnSpan",t);o=this.getParent();o&&o.invalidate();return this};b.prototype._getHeight=function(){return this._height};b.prototype._setHeight=function(t){var e,o;if(this._height===t){return}e=f.getType("sap.ui.core.CSSSize");if(!e.isValid(t)){throw new Error('"'+t+'" is of type '+typeof t+", expected "+e.getName()+' for property "_height" of '+this)}this._height=t;o=this.getDomRef();if(o){o.style.height=this._height;this._adaptDomHeight()}};b.prototype._toggleContentResizeListener=function(t){if(t&&!this._iResizeId){this._iResizeId=o.register(this._getContentWrapper(),this._adaptDomHeight.bind(this))}if(!t&&this._iResizeId){o.deregister(this._iResizeId);this._iResizeId=null}};b.prototype._getContentWrapper=function(){return this.getAggregation("_grid")};b.prototype.getSectionText=function(t){return b._getLibraryResourceBundle().getText("SUBSECTION_CONTROL_NAME")};b.prototype._getShouldLabelTitle=function(){if(this._getUseTitleOnTheLeft()){return this.getShowTitle()}if(this._sBorrowedTitleDomId){return false}return this.getShowTitle()};b.prototype._getTitleDomId=function(){if(this._sBorrowedTitleDomId){return this._sBorrowedTitleDomId}if(!this.getTitle().trim()){return false}if(this._getInternalTitleVisible()){return this.getId()+"-headerTitle"}return false};b.prototype._setBorrowedTitleDomId=function(t){this._sBorrowedTitleDomId=t};b.prototype._toggleMultiLineSectionContent=function(t){this.toggleStyleClass("sapUxAPObjectPageSectionMultilineContent",t);this._bMultiLine=t};b.prototype._expandSection=function(){i.prototype._expandSection.call(this);var t=this.getParent();t&&typeof t._expandSection==="function"&&t._expandSection();return this};b.prototype._hasVisibleActions=function(){var t=this.getActions()||[];if(t.length===0){return false}return t.filter(function(t){return t.getVisible()}).length>0};b.prototype._observeChanges=function(t){var e=t.object,o=t.name,i=t.mutation,s=t.child,r;if(e===this){if(o==="actions"){if(i==="insert"){this._observeAction(s)}else if(i==="remove"){this._unobserveAction(s)}}}else if(o==="visible"){r=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!r){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions())}}};b.prototype._onBlocksChange=function(){var t=this._getObjectPageLayout();if(!this._bRenderedFirstTime){return}this._applyLayout(t)};b.prototype._observeAction=function(t){this._oObserver.observe(t,{properties:["visible"]})};b.prototype._unobserveAction=function(t){this._oObserver.unobserve(t,{properties:["visible"]})};["addStyleClass","toggleStyleClass","removeStyleClass"].forEach(function(t){b.prototype[t]=function(e,o){if(e===b.FIT_CONTAINER_CLASS){this._notifyObjectPageLayout()}return i.prototype[t].apply(this,arguments)}});b.prototype._unStashControls=function(){var e;this._aStashedControls.forEach(function(o){o.control.unstash();e=t.getElementById(o.control.getId());this.addAggregation(o.aggregationName,e,true)}.bind(this));this._aStashedControls=[]};b.prototype._unStashControlsAsync=function(){var e;if(!this._bUnstashed){this._aStashedControls.forEach(function(o){this._aUnStashedControls.push(o.control.unstash(true).then(function(){e=t.getElementById(o.control.getId());this.addAggregation(o.aggregationName,e,true)}.bind(this)))}.bind(this));this._bUnstashed=true}return Promise.all(this._aUnStashedControls).then(()=>{this._bUnstashed=false;this._aUnStashedControls=[];this._aStashedControls=[]})};b.prototype.connectToModels=function(){var t=this.getBlocks()||[],e=this.getMoreBlocks()||[],o=this.getMode();this._unStashControls();t.forEach(function(t){if(t instanceof r){if(!t.getMode()){t.setMode(o)}t.connectToModels()}});if(e.length>0&&o===y.Expanded){e.forEach(function(t){if(t instanceof r){if(!t.getMode()){t.setMode(o)}t.connectToModels()}})}};b.prototype.connectToModelsAsync=function(){var t=this.getBlocks()||[],e=this.getMoreBlocks()||[],o=this.getMode();return this._unStashControlsAsync().then(function(){t.forEach(function(t){if(t instanceof r){if(!t.getMode()){t.setMode(o)}t.connectToModels()}});if(e.length>0&&o===y.Expanded){e.forEach(function(t){if(t instanceof r){if(!t.getMode()){t.setMode(o)}t.connectToModels()}})}})};b.prototype._allowPropagationToLoadedViews=function(t){var e=this.getBlocks()||[],o=this.getMoreBlocks()||[];e.forEach(function(e){if(e instanceof r){e._allowPropagationToLoadedViews(t)}});o.forEach(function(e){if(e instanceof r){e._allowPropagationToLoadedViews(t)}})};b.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(t){var e=this.mAggregations[t];if(!e||e.length===0){this.mAggregations[t]=this._aAggregationProxy[t]}},this);return i.prototype.clone.apply(this,arguments)};b.prototype._cleanProxiedAggregations=function(){var t=this._aAggregationProxy;Object.keys(t).forEach(function(e){t[e].forEach(function(t){t.destroy()})})};b.prototype._unobserveBlocks=function(){var t=this.getBlocks().concat(this.getMoreBlocks());t.forEach(function(t){t&&this._oBlocksObserver.unobserve(t,{properties:["visible"]})},this)};b.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null}if(this._oSeeLessButton){this._oSeeLessButton.destroy();this._oSeeLessButton=null}this._unobserveBlocks();this._oCurrentlyVisibleSeeMoreLessButton=null;this._cleanProxiedAggregations();if(i.prototype.exit){i.prototype.exit.call(this)}};b.prototype.onAfterRendering=function(){var t=this._getObjectPageLayout(),e=this.getParent();if(i.prototype.onAfterRendering){i.prototype.onAfterRendering.call(this)}if(!t){return}if(this.hasStyleClass(b.FIT_CONTAINER_CLASS)){this._toggleContentResizeListener(true)}this._$spacer=t.$("spacer");if(this._bShouldFocusSeeMoreLessButton&&document.activeElement===document.body){this._oCurrentlyVisibleSeeMoreLessButton.focus()}this._bShouldFocusSeeMoreLessButton=false;if(e&&e.hasStyleClass("sapUiTableOnObjectPageAdjustmentsForSection")&&!this.hasStyleClass("sapUiAdjustedSectionSubsectionWithoutTable")){this.getAggregation("_grid").setProperty("hSpacing",0)}};b.prototype.onBeforeRendering=function(){var t=this._getObjectPageLayout();if(!t){return}if(i.prototype.onBeforeRendering){i.prototype.onBeforeRendering.call(this)}this._toggleContentResizeListener(false);this._setAggregationProxy();this._applyLayout(t);this.refreshSeeMoreVisibility();this.toggleStyleClass("sapUxAPObjectPageSubSectionStashed",this._aStashedControls.length?true:false);this.toggleStyleClass("sapUxAPObjectPageSubSectionFocusable",this.getTitleVisible())};b.prototype._adaptDomHeight=function(){var t=this.getDomRef(),e=this._height,o=this.hasStyleClass(b.FIT_CONTAINER_CLASS);if(!t){return}if(o&&e){var i=t.scrollHeight,s=Math.ceil(parseFloat(e));t.style.height=i>s?"":e;this._height=t.style.height}};b.prototype._hasRestrictedHeight=function(){var t=this.getDomRef();if(!t){return}return parseInt(t.style.height)>0};b.prototype._applyLayout=function(t){var e,o=this.getMode(),i=t.getSubSectionLayout(),s=this._calculateLayoutConfiguration(i,t),r=this.getBlocks(),n=r.concat(this.getMoreBlocks());this._oLayoutConfig=s;this._resetLayoutData(n);if(o===y.Expanded){e=n}else{e=r}this._assignLayoutData(e,s);try{e.forEach(function(t){this._setBlockMode(t,o)},this)}catch(t){p.error("ObjectPageSubSection :: error while building layout "+i+": "+t)}return this};b.prototype._calculateLayoutConfiguration=function(t,e){var o={M:2,L:3,XL:4},i=o.L,s=o.XL,r=t===S.TitleOnLeft,n=e.getUseTwoColumnsForLargeScreen();if(r){i-=1;s-=1}if(n){i-=1}o.L=i;o.XL=s;return o};b.prototype.refreshSeeMoreVisibility=function(){var t=this._getSeeMoreButton(),e=this._getSeeLessButton();this._bBlockHasMore=!!this.getMoreBlocks().length;if(!this._bBlockHasMore){this._bBlockHasMore=this.getBlocks().some(function(t){if(t instanceof r&&t.getVisible()&&t.getShowSubSectionMore()){return true}})}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",this._bBlockHasMore);t.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);e.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);return this._bBlockHasMore};b.prototype.setMode=function(t){if(this.getMode()!==t){this._switchSubSectionMode(t);if(this._bRenderedFirstTime){this.invalidate()}}return this};b.prototype.onkeydown=function(e){if(e.keyCode===d.SPACE&&e.srcControl.isA("sap.uxap.ObjectPageSubSection")){e.preventDefault()}if(e.keyCode===d.F7){e.stopPropagation();var o=t.getElementById(e.target.id);if(o instanceof b){this._handleSubSectionF7()}else if(!e.isMarked()){this._handleInteractiveElF7();this._oLastFocusedControlF7=o}}};b.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().trigger("focus")}else{this.getParent().$().trigger("focus")}};b.prototype._handleSubSectionF7=function(t){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().trigger("focus")}else{this.$().firstFocusableDomRef().focus()}};b.prototype._getMinRequiredColspan=function(){var t=this._getColumnSpan(),e,o,i;if(t===b.COLUMN_SPAN.auto){e=this.getBlocks().concat(this.getMoreBlocks());o=e.filter(function(t){return t.getVisible&&t.getVisible()});return o.reduce(function(t,e){return t+this._getMinRequiredColspanForChild(e)}.bind(this),0)}i=parseInt(t);if(i>0&&i<=4){return i}return 4};b.prototype._getMinRequiredColspanForChild=function(t){var e=1;if(!t){e=0}else if(t instanceof r&&t.getColumnLayout()!="auto"){e=parseInt(t.getColumnLayout())}return e};b.prototype._allowAutoextendColspanForChild=function(t){return this._hasAutoLayout(t)};b.prototype._hasAutoLayout=function(t){return!(t instanceof r)||t.getColumnLayout()=="auto"};b.prototype._setAggregationProxy=function(){var t;if(this._bRenderedFirstTime){return}jQuery.each(this._aAggregationProxy,jQuery.proxy(function(e,o){t=this.removeAllAggregation(e,true);t.forEach(function(t){this._onAddBlock(t,e,true)},this);this._setAggregation(e,t,true)},this));this._bRenderedFirstTime=true};b.prototype.hasProxy=function(t){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(t)};b.prototype._getAggregation=function(t){return this._aAggregationProxy[t]};b.prototype._setAggregation=function(t,e,o){this._aAggregationProxy[t]=e;if(o!==true){this._notifyObjectPageLayout();this.invalidate()}return this._aAggregationProxy[t]};b.prototype.addAggregation=function(t,e,o){var n;if(e instanceof s){if(e.isStashed()){this._aStashedControls.push({aggregationName:t,control:e})}else{e.getContent().forEach(function(e){this.addAggregation(t,e,true)},this);e.removeAllContent();e.destroy();this.invalidate()}}else if(this.hasProxy(t)){n=this._getAggregation(t);n.push(e);if(e instanceof r){e.setParent(this,t)}this._onAddBlock(e,t,o);this._setAggregation(t,n,o)}else{i.prototype.addAggregation.apply(this,arguments)}return this};b.prototype.insertBlock=function(t,e){p.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",t)};b.prototype._onAddBlock=function(t,e,o){if(!t){return}this._oBlocksObserver.observe(t,{properties:["visible"]});if(this._shouldForwardAggregationToGrid(e)){this._addBlockToGrid(t,o)}};b.prototype._shouldForwardAggregationToGrid=function(t){return t==="blocks"||t==="moreBlocks"&&this.getMode()===y.Expanded};b.prototype._addBlockToGrid=function(t,e){var o=this._getGrid();if(o?.indexOfContent(t)<0){o?.addAggregation("content",t,e)}};b.prototype._onRemoveBlock=function(t,e){if(!t){return}this._oBlocksObserver.unobserve(t,{properties:["visible"]});this._removeBlockFromGrid(t,e)};b.prototype._removeBlockFromGrid=function(t,e){var o=this._getGrid();if(o?.indexOfContent(t)>-1){o?.removeAggregation("content",t,e)}};b.prototype.insertMoreBlock=function(t,e){p.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",t)};b.prototype.removeAllAggregation=function(t,e){var o;if(this.hasProxy(t)){o=this._getAggregation(t);this._setAggregation(t,[],e);o.forEach(function(t){this._onRemoveBlock(t)}.bind(this));return o.slice()}return i.prototype.removeAllAggregation.apply(this,arguments)};b.prototype.removeAggregation=function(t,e){var o=false,s;if(this.hasProxy(t)&&typeof e==="object"){s=this._getAggregation(t);s.forEach(function(i,r){if(i.getId()===e.getId()){s.splice(r,1);this._onRemoveBlock(e);this._setAggregation(t,s);o=true}return!o},this);return o?e:null}return i.prototype.removeAggregation.apply(this,arguments)};b.prototype.indexOfAggregation=function(t,e){var o=-1;if(this.hasProxy(t)){this._getAggregation(t).some(function(t,i){if(t.getId()===e.getId()){o=i;return true}},this);return o}return i.prototype.indexOfAggregation.apply(this,arguments)};b.prototype.getAggregation=function(t){if(this.hasProxy(t)){return this._getAggregation(t)}return i.prototype.getAggregation.apply(this,arguments)};b.prototype.destroyAggregation=function(t){if(this.hasProxy(t)){this._getAggregation(t).forEach(function(t){t.destroy()});this._setAggregation(t,[]);return this}return i.prototype.destroyAggregation.apply(this,arguments)};b.prototype.destroy=function(){this._aStashedControls.forEach(function(t){t.control.destroy()});i.prototype.destroy.apply(this,arguments)};b.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new n(this.getId()+"--seeMore",{type:_.Transparent,iconFirst:false,text:b._getLibraryResourceBundle().getText("SHOW_MORE")}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this)}return this._oSeeMoreButton};b.prototype._getSeeLessButton=function(){if(!this._oSeeLessButton){this._oSeeLessButton=new n(this.getId()+"--seeLess",{type:_.Transparent,iconFirst:false,text:b._getLibraryResourceBundle().getText("SHOW_LESS")}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this)}return this._oSeeLessButton};b.prototype._seeMoreLessControlPressHandler=function(t){var e=this.getMode(),o,i=this.getMoreBlocks()||[];if(e===y.Expanded){o=y.Collapsed}else{o=y.Expanded;i.forEach(function(t){if(t instanceof r){t.setMode(e);t.connectToModels()}},this)}this._switchSubSectionMode(o);this._bShouldFocusSeeMoreLessButton=true};b.prototype._switchSubSectionMode=function(t){t=this.validateProperty("mode",t);if(t===y.Collapsed){this.setProperty("mode",y.Collapsed);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeMoreButton().setVisible(true);this._getSeeLessButton().setVisible(false);this.getMoreBlocks().forEach(function(t){this._removeBlockFromGrid(t)},this)}else{this.setProperty("mode",y.Expanded);this._getSeeMoreButton().setVisible(false);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeLessButton().setVisible(true);this.getMoreBlocks().forEach(function(t){this._addBlockToGrid(t)},this)}};b.prototype._setBlockMode=function(t,e){if(t instanceof r){t.setMode(e)}else{p.debug("ObjectPageSubSection :: cannot propagate mode "+e+" to "+t.getMetadata().getName())}};b.prototype._setToFocusable=function(t){if(this._shouldBeFocusable()){this.$().attr("tabindex",t?"0":"-1")}else{this.$().removeAttr("tabindex")}return this};b.prototype._shouldBeFocusable=function(){return this.getTitleVisible()&&this.getTitle().trim()!==""};b.prototype._getUseTitleOnTheLeft=function(){var t=this._getObjectPageLayout();return t&&t.getSubSectionLayout()===S.TitleOnLeft};b.prototype._updateShowHideState=function(t){if(this._getIsHidden()===t){return this}this.$().children(this._sMoreContainerSelector).toggle(!t);return i.prototype._updateShowHideState.call(this,t)};b.prototype.getVisibleBlocksCount=function(){var t=this._aStashedControls.length;(this.getBlocks()||[]).forEach(function(e){if(!e){return}if(e.getVisible&&!e.getVisible()){return true}t++});(this.getMoreBlocks()||[]).forEach(function(e){if(e.getVisible&&!e.getVisible()){return true}t++});return t};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ObjectPageSubSectionRenderer", ["sap/ui/core/ControlBehavior"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,i){var a,s,n,r,o,l,c=e.isAccessibilityEnabled(),d=i.getAggregation("ariaLabelledBy");if(!i.getVisible()||!i._getInternalVisible()){return}a=i.getActions()||[];r=a.length>0;s=i.getTitleVisible();n=s||r;l=i._hasVisibleActions();t.openStart("div",i).style("height",i._getHeight());if(s){t.attr("role","region")}if(i._bBlockHasMore){t.class("sapUxAPObjectPageSubSectionWithSeeMore")}if(i._bMultiLine){t.class("sapUxAPObjectPageSectionMultilineContent")}t.class("sapUxAPObjectPageSubSection").class("ui-helper-clearfix");if(c&&d&&s){t.attr("aria-labelledby",d.getId())}t.openEnd();if(n){t.openStart("div",i.getId()+"-header").class("sapUxAPObjectPageSubSectionHeader");if(!s&&!l){t.class("sapUiHidden")}o=i._getUseTitleOnTheLeft();if(o){t.class("titleOnLeftLayout")}t.openEnd();t.openStart("div",i.getId()+"-headerTitle");if(s){t.attr("role","heading").attr("aria-level",i._getARIALevel())}t.class("sapUxAPObjectPageSubSectionHeaderTitle");if(i.getTitleUppercase()){t.class("sapUxAPObjectPageSubSectionHeaderTitleUppercase")}t.attr("data-sap-ui-customfastnavgroup",true).openEnd();if(s){t.text(i.getTitle())}t.close("div");if(r){t.openStart("div").class("sapUxAPObjectPageSubSectionHeaderActions").attr("data-sap-ui-customfastnavgroup",true).openEnd();a.forEach(t.renderControl,t);t.close("div")}t.close("div")}t.openStart("div").class("ui-helper-clearfix").class("sapUxAPBlockContainer");if(i._isHidden){t.style("display","none")}t.openEnd();t.renderControl(i._getGrid());t.close("div");t.openStart("div").class("sapUxAPSubSectionSeeMoreContainer");if(i._isHidden){t.style("display","none")}t.openEnd();t.renderControl(i._getSeeMoreButton());t.renderControl(i._getSeeLessButton());t.close("div");t.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/ThrottledTaskHelper", ["sap/ui/thirdparty/jquery","sap/ui/base/Object"],function(jQuery,i){"use strict";var t=i.extend("sap.uxap.ThrottledTask",{constructor:function(i,t,s){this._fnTask=i;this._iDelay=t;this._oContext=s;this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._iTimer=null;this._oTaskOptions=null},reSchedule:function(i,t){var s=this._getPromise();if(this._iTimer){clearTimeout(this._iTimer);this._iTimer=null}this._oTaskOptions=this._mergeOptions(this._oTaskOptions||{},t);if(i){var e=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(e);return s}this._iTimer=setTimeout(function(){if(this._oPromise){var i=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(i)}}.bind(this),this._iDelay);return s},isPending:function(){return this._iTimer!=null},_getPromise:function(){if(!this._oPromise){this._oPromise=new Promise(function(i,t){this._fnResolvePromise=i;this._fnRejectPromise=t}.bind(this))}return this._oPromise},_completePromise:function(i){var t=i?this._fnResolvePromise:this._fnRejectPromise;t();this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._oTaskOptions=null},_mergeOptions:function(i,t){var s=jQuery.extend({},i,t);jQuery.each(s,function(e){s[e]=i[e]||t[e]});return s}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/changeHandler/AddIFrameObjectPageLayout", ["sap/ui/core/Lib","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/AddIFrame","sap/ui/fl/changeHandler/common/getTargetAggregationIndex","sap/ui/fl/changeHandler/common/createIFrame"],function(e,t,n,r,a){"use strict";var o=Object.assign({},n);o.applyChange=function(t,o,i){var g=i.modifier;var c=t.getContent();var s=c.targetAggregation;if(s!=="sections"){return Promise.resolve().then(n.applyChange.bind(n,t,o,i))}var u=i.view;var l=i.appComponent;var f=c.selector;var d=e.getResourceBundleFor("sap.uxap").getText("SECTION_TITLE_FOR_IFRAME");var p;var v;return Promise.resolve().then(g.createControl.bind(g,"sap.uxap.ObjectPageSection",l,u,f,{title:d},false)).then(function(e){p=e;var t=Object.create(f);t.id+="-subSection";return g.createControl("sap.uxap.ObjectPageSubSection",l,u,t,{title:d},false)}).then(function(e){v=e;return g.insertAggregation(p,"subSections",v,0,u)}).then(function(){var e=Object.create(f);e.id+="-iframe";var n={sourceControlId:g.getId(v),selectorControlId:g.getId(p),propertyName:"title"};return a(t,i,e,n)}).then(function(e){return g.insertAggregation(v,"blocks",e,0,u)}).then(r.bind(null,t,o,i)).then(function(e){return g.insertAggregation(o,"sections",p,e,u)}).then(function(){t.setRevertData([g.getId(p)])})};o.getCondenserInfo=function(e){var t=Object.assign({},n.getCondenserInfo(e));var r=e.getContent();var a=r.targetAggregation;if(a==="sections"){t.updateControl=Object.assign({},t.affectedControl);t.updateControl.id=t.affectedControl.id+"-iframe"}return t};o.getChangeVisualizationInfo=function(e,n){var r=e.getContent().selector;var a=t.bySelector(r,n);var o=a.getParent().getAggregation("_anchorBar");var i=[r];var g=[r];o.getAggregation("items").forEach(function(e){if(a.getId()===e.getKey()){g.push(e.getId())}});return{affectedControls:i,displayControls:g}};return o},true);
/*!
	* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
	*/
sap.ui.predefine("sap/uxap/changeHandler/MoveObjectPageSection", ["sap/base/util/merge","sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/MoveControls"],function(e,t,r,n){"use strict";var o=Object.assign({},n);o.applyChange=function(e,t,r){var o=r.modifier.targets==="jsControlTree";if(o){t._suppressScroll()}var a=n.applyChange.call(this,e,t,r);if(o){t.attachEventOnce("onAfterRenderingDOMReady",function(){t._resumeScroll(false)})}return a};o.revertChange=function(e,t,r){var o=r.modifier.targets==="jsControlTree";if(o){t._suppressScroll()}var a=n.revertChange.call(this,e,t,r);if(o){t.attachEventOnce("onAfterRenderingDOMReady",function(){t._resumeScroll(false)})}return a};o.completeChangeContent=function(e,r,o){var a=t.getElementById(r.source.id),i=t.getElementById(r.target.id);var s=Promise.resolve();if(a.isA("sap.m.IconTabHeader")&&i.isA("sap.m.IconTabHeader")){s=s.then(this._mapAnchorsToSections.bind(this,r,o))}return s.then(function(){return n.completeChangeContent.apply(this,arguments[0])}.bind(this,arguments))};o._mapAnchorsToSections=function(r,n){return Promise.resolve().then(function(){var o,a;var i=n.modifier;var s=i.bySelector(r.selector,n.appComponent,n.view);var c=s._getVisibleSections();function g(e){var r=t.getElementById(e),n=r.getKey();return t.getElementById(n)}var l=[];r.movedElements.forEach(function(e){var t=c[e.targetIndex];var r=Promise.resolve().then(function(){return i.findIndexInParentAggregation(t)}).then(function(t){e.targetIndex=t;o=g(e.id);if(!o||!o.getParent()){throw new Error("Cannot map anchor to section")}a={id:o.getParent().getId(),aggregation:o.sParentAggregationName};e.id=o.getId()});l.push(r)});return Promise.all(l).then(function(){e(r.source,a);e(r.target,a)})})};o.getChangeVisualizationInfo=function(e,t){var n=e.getContent();var o=e.getRevertData()[0];var a=n.movedElements[0].selector;var i=r.bySelector(a,t);var s=i.getParent().getAggregation("_anchorBar");var c=[a];var g=[a];s.getAggregation("items").forEach(function(e){if(i.getId()===e.getKey()){g.push(e.getId())}});return{affectedControls:c,displayControls:g,dependentControls:[n.source.selector],descriptionPayload:{sourceContainer:o.sourceParent,targetContainer:n.target.selector}}};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/changeHandler/RenameObjectPageSection", ["sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/BaseRename"],function(e,t,r){"use strict";var n={propertyName:"title",changePropertyName:"newText",translationTextType:"XGRP"};var o=r.createRenameChangeHandler(n);o._getControlForRename=function(e,t){var r,n;return Promise.resolve().then(function(){return t.getAggregation(e,"subSections")}).then(function(n){r=n;if(r.length!==1){return[]}return Promise.all([t.getPropertyBindingOrProperty(r[0],"title"),t.getProperty(t.getParent(e),"subSectionLayout")])}).then(function(t){n=t[0];if(r&&r.length===1&&n&&typeof n==="object"||typeof n==="string"&&n.trim()!==""&&t[1]==="TitleOnTop"){return r[0]}return e})};o.applyChange=function(e,t,r){var a=r.modifier;var i=n.propertyName;var g=e.getText(n.changePropertyName);if(g&&typeof g==="string"){return o._getControlForRename(t,a).then(function(t){if(g.trim()===""){throw new Error("Change cannot be applied as ObjectPageSubSection's title cannot be empty")}return a.getPropertyBindingOrProperty(t,i).then(function(r){e.setRevertData(r);a.setPropertyBindingOrProperty(t,i,g);return true})})}};o.revertChange=function(t,r,a){var i=t.getRevertData(),g=a.modifier,u=n.propertyName;return o._getControlForRename(r,g).then(function(r){if(i||i===""){g.setPropertyBindingOrProperty(r,u,i);t.resetRevertData();return true}else{e.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.")}})};o.getChangeVisualizationInfo=function(e,r){var o=e.getTexts()&&e.getTexts()[n.changePropertyName];var a=e.getSelector();var i=t.bySelector(a,r);var g=i.getParent().getAggregation("_anchorBar");var u=[i.getId()];var p=[i.getId()];g.getAggregation("items").forEach(function(e){if(i.getId()===e.getKey()){p.push(e.getId())}});return{descriptionPayload:{originalLabel:e.getRevertData(),newLabel:o&&o.value},affectedControls:u,displayControls:p}};return o},true);
/*!
	* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
	*/
sap.ui.predefine("sap/uxap/changeHandler/UnstashObjectPageSection", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/changeHandler/UnstashControl"],function(e,t){"use strict";var r=Object.assign({},t);r.getChangeVisualizationInfo=function(t,r){var n=t.getSelector();var a=e.bySelector(n,r);var o=a.getParent().getAggregation("_anchorBar");var i=[n];var g=[n];o.getAggregation("items").forEach(function(e){if(a.getId()===e.getKey()){g.push(e.getId())}});return{affectedControls:i,displayControls:g}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/component/Component", ["sap/uxap/library","sap/ui/core/UIComponent","sap/ui/core/library","sap/base/Log","sap/ui/core/mvc/View","sap/ui/core/Component"],function(o,t,e,i,n){"use strict";var a=e.mvc.ViewType;var s=o.ObjectPageConfigurationMode;var r=t.extend("sap.uxap.component.Component",{metadata:{interfaces:["sap.ui.core.IAsyncContentCreation"]},init:function(){this._oModel=null;this._oViewConfig={viewData:{component:this}};switch(this.oComponentData.mode){case s.JsonURL:this._oModel=new t(this.oComponentData.jsonConfigurationURL);this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=a.XML;break;case s.JsonModel:this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=a.XML;break;default:i.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation")}t.prototype.init.call(this)},createContent:function(){var o;var t=n.create(this._oViewConfig);t.then(function(t){this._oView=t;if(this._oModel){o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this._oModel)}this._oView.setModel(this._oModel,"objectPageLayoutMetadata")}}.bind(this));return t},propagateProperties:function(o){if(this.oComponentData.mode===s.JsonModel){var e=this._oView.getController();if(e&&e.connectToComponent){e.connectToComponent(this.getModel("objectPageLayoutMetadata"))}}return t.prototype.propagateProperties.apply(this,arguments)},destroy:function(){if(this._oView){this._oView.destroy();this._oView=null}if(this._oModel){this._oModel.destroy();this._oModel=null}if(t.prototype.destroy){t.prototype.destroy.call(this)}}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/component/ObjectPageComponentContainer", ["sap/ui/core/ComponentContainer","sap/ui/core/ComponentContainerRenderer","sap/base/Log","sap/ui/core/Component"],function(e,n,o,t){"use strict";var r=e.extend("sap.uxap.component.ObjectPageComponentContainer",{metadata:{library:"sap.uxap",properties:{jsonConfigurationURL:{type:"string",group:"Behavior"},mode:{type:"sap.uxap.ObjectPageConfigurationMode",group:"Behavior"}}},init:function(){this.setPropagateModel(true);this.setName("sap.uxap.component")},onBeforeRendering:function(){if(e.prototype.onBeforeRendering){e.prototype.onBeforeRendering.call(this)}},_createComponent:function(){var e;if(!this._oComponent){e=t.create({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}});e.then(function(e){this._oComponent=e}.bind(this));return e}else{return this._oComponent}},getObjectPageLayoutInstance:function(){var e=null;if(this._oComponent&&this._oComponent._oView){e=this._oComponent._oView.byId("ObjectPageLayout")}else{o.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?")}return e},renderer:n});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller", ["sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/base/ManagedObject","sap/ui/core/mvc/Controller","sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject"],function(e,t,r,n,o,a,i){"use strict";return n.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory",{connectToComponent:function(r){var n=i(r.getData());r.setDefaultBindingMode(e.OneWay);var a=function(){if(n){r.detachRequestCompleted(a)}var e=new t(r,"/headerTitle"),i=this.getView().byId("ObjectPageLayout");if(e.getProperty("")){try{this.controlFactoryAsync(i.getId(),e).then(function(e){i.setHeaderTitle(e)})}catch(e){o.error("ObjectPageLayoutFactory :: error in header creation from config: "+e)}}}.bind(this);if(n){r.attachRequestCompleted(a)}else{a()}},controlFactory:function(e,t){var n=t.getProperty(""),i,c,u;try{c=sap.ui.requireSync(n.Type.replace(/\./g,"/"));u=c.getMetadata();a(u._mAllEvents,function(e,t){if(typeof n[e]=="string"){n[e]=this.convertEventHandler(n[e])}}.bind(this));i=r.create(n);a(u._mAllProperties,function(e,r){if(n[e]){i.bindProperty(e,"objectPageLayoutMetadata>"+t.getPath()+"/"+e)}})}catch(e){o.error("ObjectPageLayoutFactory :: error in control creation from config: "+e)}return i},controlFactoryAsync:function(e){var t=e.getProperty(""),n,i;var c=new Promise(function(c,u){try{sap.ui.require([t.Type.replace(/\./g,"/")],function(o){i=o.getMetadata();a(i._mAllEvents,function(e){if(typeof t[e]=="string"){t[e]=this.convertEventHandler(t[e])}}.bind(this));n=r.create(t);a(i._mAllProperties,function(r,o){if(t[r]){n.bindProperty(r,"objectPageLayoutMetadata>"+e.getPath()+"/"+r)}});c(n)})}catch(e){o.error("ObjectPageLayoutFactory :: error in control creation from config: "+e);u()}});return c},convertEventHandler:function(e){var t=window,r=e.split(".");try{a(r,function(e,r){t=t[r]})}catch(r){o.error("ObjectPageLayoutFactory :: undefined event handler: "+e+". Did you forget to require its static class?");t=undefined}return t}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageDynamicHeaderTitle.flexibility", ["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(e,n,a){"use strict";return{hideControl:"default",unhideControl:"default",combineButtons:{changeHandler:e,layers:{CUSTOMER:false}},splitMenuButton:{changeHandler:n,layers:{CUSTOMER:false}},moveActions:{changeHandler:a},moveControls:"default"}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageHeader.flexibility", ["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton"],function(e,n){"use strict";return{combineButtons:{changeHandler:e,layers:{CUSTOMER:false}},moveControls:"default",splitMenuButton:{changeHandler:n,layers:{CUSTOMER:false}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageHeaderActionButton.flexibility", ["sap/ui/fl/changeHandler/BaseRename"],function(e){"use strict";return{hideControl:"default",rename:e.createRenameChangeHandler({propertyName:"text",translationTextType:"XBUT"}),unhideControl:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageLayout.flexibility", ["sap/uxap/changeHandler/MoveObjectPageSection","sap/uxap/changeHandler/AddIFrameObjectPageLayout"],function(e,a){"use strict";return{moveControls:{changeHandler:e,layers:{USER:true}},addIFrame:{changeHandler:a}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageSection.flexibility", ["sap/uxap/changeHandler/RenameObjectPageSection","sap/uxap/changeHandler/UnstashObjectPageSection"],function(e,a){"use strict";return{rename:e,moveControls:"default",hideControl:{changeHandler:"default",layers:{USER:true}},unhideControl:{changeHandler:"default",layers:{USER:true}},stashControl:{changeHandler:"default",layers:{USER:true}},unstashControl:{changeHandler:a,layers:{USER:true}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/flexibility/ObjectPageSubSection.flexibility", ["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/ui/fl/changeHandler/BaseRename"],function(e,n,a){"use strict";return{hideControl:"default",unhideControl:"default",rename:a.createRenameChangeHandler({propertyName:"title",translationTextType:"XGRP"}),combineButtons:{changeHandler:e,layers:{CUSTOMER:false}},moveControls:"default",splitMenuButton:{changeHandler:n,layers:{CUSTOMER:false}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/uxap/library", ["sap/ui/Device","sap/ui/base/DataType","sap/ui/base/Object","sap/ui/core/Lib","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/f/library","sap/m/library","sap/ui/layout/library"],function(e,a,t,i,jQuery){"use strict";var u=i.init({name:"sap.uxap",apiVersion:2,dependencies:["sap.ui.core","sap.f","sap.m","sap.ui.layout"],designtime:"sap/uxap/designtime/library.designtime",types:["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],interfaces:["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"],controls:["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],elements:["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],version:"1.135.0",extensions:{flChangeHandlers:{"sap.uxap.ObjectPageHeader":"sap/uxap/flexibility/ObjectPageHeader","sap.uxap.ObjectPageLayout":"sap/uxap/flexibility/ObjectPageLayout","sap.uxap.ObjectPageSection":"sap/uxap/flexibility/ObjectPageSection","sap.uxap.ObjectPageSubSection":"sap/uxap/flexibility/ObjectPageSubSection","sap.uxap.ObjectPageDynamicHeaderTitle":"sap/uxap/flexibility/ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageHeaderActionButton":"sap/uxap/flexibility/ObjectPageHeaderActionButton","sap.ui.core._StashedControl":{unstashControl:{changeHandler:"default",layers:{USER:true}},stashControl:{changeHandler:"default",layers:{USER:true}}}},"sap.ui.support":{publicRules:true}}});u.BlockBaseColumnLayout=a.createType("sap.uxap.BlockBaseColumnLayout",{isValid:function(e){return/^(auto|[1-4]{1})$/.test(e)}},a.getType("string"));u.BlockBaseFormAdjustment={BlockColumns:"BlockColumns",OneColumn:"OneColumn",None:"None"};a.registerEnum("sap.uxap.BlockBaseFormAdjustment",u.BlockBaseFormAdjustment);u.ObjectPageConfigurationMode={JsonURL:"JsonURL",JsonModel:"JsonModel"};a.registerEnum("sap.uxap.ObjectPageConfigurationMode",u.ObjectPageConfigurationMode);u.ObjectPageHeaderDesign={Light:"Light",Dark:"Dark"};a.registerEnum("sap.uxap.ObjectPageHeaderDesign",u.ObjectPageHeaderDesign);u.ObjectPageHeaderPictureShape={Circle:"Circle",Square:"Square"};a.registerEnum("sap.uxap.ObjectPageHeaderPictureShape",u.ObjectPageHeaderPictureShape);u.ObjectPageSubSectionLayout={TitleOnTop:"TitleOnTop",TitleOnLeft:"TitleOnLeft"};a.registerEnum("sap.uxap.ObjectPageSubSectionLayout",u.ObjectPageSubSectionLayout);u.ObjectPageSubSectionMode={Collapsed:"Collapsed",Expanded:"Expanded"};a.registerEnum("sap.uxap.ObjectPageSubSectionMode",u.ObjectPageSubSectionMode);u.Importance={Low:"Low",Medium:"Medium",High:"High"};a.registerEnum("sap.uxap.Importance",u.Importance);u.Utilities={getClosestOPL:function(e,a){while(e&&!t.isObjectA(e,"sap.uxap.ObjectPageLayout")){e=e.getParent()||a;a=null}return e},isPhoneScenario:function(a){if(e.system.phone){return true}return u.Utilities._isCurrentMediaSize("Phone",a)},isTabletScenario:function(e){return u.Utilities._isCurrentMediaSize("Tablet",e)},_isCurrentMediaSize:function(e,a){return a&&a.name===e},getChildPosition:function(e,a){var t=e instanceof jQuery?e:jQuery(e),i=a instanceof jQuery?a:jQuery(a),u=jQuery(document.documentElement),n=t.position(),s=t.offsetParent(),p;while(!s.is(i)&&!s.is(u)){p=s.position();n.top+=p.top;n.left+=p.left;s=s.offsetParent()}return n}};return u});
sap.ui.require.preload({
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.view.xml":'<mvc:View xmlns:mvc="sap.ui.core.mvc"\n\t\t  xmlns="sap.uxap"\n\t\t  height="100%"\n\t\t  controllerName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory"\n><ObjectPageLayout id="ObjectPageLayout"\n\t\t\t\t\t  subSectionLayout="{objectPageLayoutMetadata>/subSectionLayout}"\n\t\t\t\t\t  showAnchorBar="{objectPageLayoutMetadata>/showAnchorBar}"\n\t\t\t\t\t  height="{objectPageLayoutMetadata>/height}"\n\t\t\t\t\t  enableLazyLoading="{objectPageLayoutMetadata>/enableLazyLoading}"\n\t\t\t\t\t  sections="{path: \'objectPageLayoutMetadata>/sections\', templateShareable: false}"\n\t\t\t\t\t  headerContent="{path:\'objectPageLayoutMetadata>/headerContent\', factory:\'.controlFactory\'}"\n\t\t\t\t\t  showAnchorBarPopover="{objectPageLayoutMetadata>/showAnchorBarPopover}"\n\t\t\t\t\t  upperCaseAnchorBar="{objectPageLayoutMetadata>/upperCaseAnchorBar}"\n\t\t\t\t\t  useIconTabBar="{objectPageLayoutMetadata>/useIconTabBar}"\n\t\t\t\t\t  showHeaderContent="{objectPageLayoutMetadata>/showHeaderContent}"\n\t\t\t\t\t  useTwoColumnsForLargeScreen="{objectPageLayoutMetadata>/useTwoColumnsForLargeScreen}"\n\t\t\t\t\t  showTitleInHeaderContent="{objectPageLayoutMetadata>/showTitleInHeaderContent}"\n\t\t\t\t\t  showOnlyHighImportance="{objectPageLayoutMetadata>/showOnlyHighImportance}"\n\t\t\t\t\t  isChildPage="{objectPageLayoutMetadata>/isChildPage}"\n\t\t\t\t\t  alwaysShowContentHeader="{objectPageLayoutMetadata>/alwaysShowContentHeader}"\n\t\t\t\t\t  showEditHeaderButton="{objectPageLayoutMetadata>/showEditHeaderButton}"\n\t><sections><ObjectPageSection id="ObjectPageSection"\n\t\t\t\t\t\t\t   title="{objectPageLayoutMetadata>title}"\n\t\t\t\t\t\t\t   importance="{objectPageLayoutMetadata>importance}"\n\t\t\t\t\t\t\t   showTitle="{objectPageLayoutMetadata>showTitle}"\n\t\t\t\t\t\t\t   subSections="{path: \'objectPageLayoutMetadata>subSections\', templateShareable: false}"\n\t\t\t\t\t\t\t   visible="{objectPageLayoutMetadata>visible}"><subSections><ObjectPageSubSection id="ObjectPageSubSection"\n\t\t\t\t\t\t\t\t\t\t  title="{objectPageLayoutMetadata>title}"\n\t\t\t\t\t\t\t\t\t\t  visible="{objectPageLayoutMetadata>visible}"\n\t\t\t\t\t\t\t\t\t\t  mode="{objectPageLayoutMetadata>mode}"\n\t\t\t\t\t\t\t\t\t\t  importance="{objectPageLayoutMetadata>importance}"\n\t\t\t\t\t\t\t\t\t\t  actions="{path:\'objectPageLayoutMetadata>actions\', factory:\'.controlFactory\'}"\n\t\t\t\t\t\t\t\t\t\t  blocks="{path:\'objectPageLayoutMetadata>blocks\', factory:\'.controlFactory\'}"\n\t\t\t\t\t\t\t\t\t\t  moreBlocks="{path:\'objectPageLayoutMetadata>moreBlocks\', factory:\'.controlFactory\'}"></ObjectPageSubSection></subSections></ObjectPageSection></sections></ObjectPageLayout></mvc:View>\n',
	"sap/uxap/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.uxap","type":"library","embeds":[],"applicationVersion":{"version":"1.135.0"},"title":"SAP UxAP","description":"SAP UxAP","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.135","libs":{"sap.ui.core":{"minVersion":"1.135.0"},"sap.m":{"minVersion":"1.135.0"},"sap.ui.layout":{"minVersion":"1.135.0"},"sap.f":{"minVersion":"1.135.0","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],"elements":["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],"types":["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],"interfaces":["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
