/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.sdk.WinAppxToolsKt;
import com.jetbrains.python.sdk.WinRegistryService;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.venvReader.ResolveUtilKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class WinPythonSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    @NotNull
    private static final String[] REG_ROOTS = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
    private static final Regex PYTHON_EXE = new Regex("^python[0-9.]*?.exe$");
    private static final String APPX_PRODUCT = "Python";
    private static final Map<String, String> REGISTRY_MAP = ImmutableMap.of((Object)"Python", (Object)"python.exe", (Object)"IronPython", (Object)"ipy.exe");
    @ApiStatus.Internal
    @TestOnly
    public static final String ROOT_TO_SEARCH_PYTHON_IN = "pycharm.root.to.search.python.in";
    @TestOnly
    public static final String DIR_WITH_PYTHON_NAME = "dir_with_python_name";
    @NotNull
    private final SynchronizedClearableLazy<Set<String>> myRegistryCache = new SynchronizedClearableLazy(() -> WinPythonSdkFlavor.findInRegistry(this.getWinRegistryService()));
    @NotNull
    private final SynchronizedClearableLazy<Set<String>> myAppxCache = new SynchronizedClearableLazy(WinPythonSdkFlavor::getPythonsFromStore);

    public static WinPythonSdkFlavor getInstance() {
        return (WinPythonSdkFlavor)((Object)EP_NAME.findExtension(WinPythonSdkFlavor.class));
    }

    public boolean isApplicable() {
        return SystemInfo.isWindows;
    }

    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    protected final @NotNull Collection<@NotNull Path> suggestLocalHomePathsImpl(@Nullable Module module2, @Nullable UserDataHolder context) {
        TreeSet<String> candidates = new TreeSet<String>();
        this.findInCandidatePaths(candidates, "python.exe", "pypy.exe");
        WinPythonSdkFlavor.findInstallations(candidates, "python.exe", PythonHelpersLocator.getCommunityHelpersRoot().getParent().toString());
        List list = ContainerUtil.map(candidates, x$0 -> Path.of(x$0, new String[0]));
        if (list == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    private void findInCandidatePaths(Set<String> candidates, String ... exe_names) {
        String root = System.getProperty(ROOT_TO_SEARCH_PYTHON_IN, "C:\\");
        for (String name2 : exe_names) {
            WinPythonSdkFlavor.findInstallations(candidates, name2, root, "C:\\Program Files\\");
            WinPythonSdkFlavor.findInPath(candidates, name2);
        }
        this.findInRegistry(candidates);
        candidates.addAll((Collection)this.myAppxCache.getValue());
    }

    public final boolean sdkSeemsValid(@NotNull Sdk sdk2, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PyFlavorData.Empty flavorData, @Nullable TargetEnvironmentConfiguration targetConfig) {
        if (sdk2 == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        if (flavorData == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if (super.sdkSeemsValid(sdk2, (PyFlavorData)flavorData, targetConfig) || targetConfig != null) {
            return true;
        }
        String path2 = sdk2.getHomePath();
        return path2 != null && this.isValidSdkPath(path2);
    }

    public final boolean isValidSdkPath(@NotNull String pathStr2) {
        if (pathStr2 == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if (super.isValidSdkPath(pathStr2)) {
            return true;
        }
        Path path2 = ResolveUtilKt.tryResolvePath((String)pathStr2);
        return path2 != null && this.isPythonFromStore(path2);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    private boolean isPythonFromStore(@NotNull Path path2) {
        if (path2 == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(4);
        }
        String pathStr2 = path2.toString();
        if (((Set)this.myAppxCache.getValue()).contains(pathStr2)) {
            return true;
        }
        String product = WinAppxToolsKt.getAppxProduct((Path)path2);
        return product != null && product.contains(APPX_PRODUCT);
    }

    public void dropCaches() {
        this.myRegistryCache.drop();
        this.myAppxCache.drop();
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public void findInRegistry(@NotNull Collection<String> candidates) {
        if (candidates == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(5);
        }
        candidates.addAll((Collection)this.myRegistryCache.getValue());
    }

    @NotNull
    protected WinRegistryService getWinRegistryService() {
        WinRegistryService winRegistryService = (WinRegistryService)ApplicationManager.getApplication().getService(WinRegistryService.class);
        if (winRegistryService == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(6);
        }
        return winRegistryService;
    }

    @RequiresBackgroundThread
    private static void findInstallations(Set<String> candidates, String exe_name, String ... roots) {
        String prefix = System.getProperty(DIR_WITH_PYTHON_NAME, FileUtilRt.getNameWithoutExtension((String)exe_name));
        for (String root : roots) {
            WinPythonSdkFlavor.findSubdirInstallations(candidates, root, prefix, exe_name);
        }
    }

    @RequiresBackgroundThread
    private static void findInPath(@NotNull @NotNull Collection<? super @NotNull String> candidates, @NotNull String exeName) {
        String path2;
        if (candidates == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(7);
        }
        if (exeName == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(8);
        }
        if ((path2 = PathEnvironmentVariableUtil.getPathVariableValue()) == null) {
            return;
        }
        for (String pathEntry : StringUtil.split((String)path2, (String)";")) {
            File f;
            if (pathEntry.startsWith("\"") && pathEntry.endsWith("\"")) {
                if (pathEntry.length() < 2) continue;
                pathEntry = pathEntry.substring(1, pathEntry.length() - 1);
            }
            if (!(f = new File(pathEntry, exeName)).exists()) continue;
            candidates.add(FileUtil.toSystemDependentName((String)f.getPath()));
        }
    }

    private static @Unmodifiable @NotNull Set<String> getPythonsFromStore() {
        Set set = ContainerUtil.map2Set((Collection)WinAppxToolsKt.getAppxFiles((String)APPX_PRODUCT, (Regex)PYTHON_EXE), file -> file.toAbsolutePath().toString());
        if (set == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    private static Set<String> findInRegistry(@NotNull WinRegistryService registryService) {
        if (registryService == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(10);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String regRoot : REG_ROOTS) {
            for (Map.Entry<String, String> entry : REGISTRY_MAP.entrySet()) {
                String productId = entry.getKey();
                String exePath = entry.getValue();
                String companiesPath = String.format("%s\\SOFTWARE\\%s", regRoot, productId);
                String companiesPathWow = String.format("%s\\SOFTWARE\\Wow6432Node\\%s", regRoot, productId);
                for (String path2 : new String[]{companiesPath, companiesPathWow}) {
                    List companies = registryService.listBranches(path2);
                    for (String company : companies) {
                        String pathToCompany = path2 + "\\" + company;
                        List versions2 = registryService.listBranches(pathToCompany);
                        for (String version2 : versions2) {
                            File interpreter;
                            String folder = registryService.getDefaultKey(pathToCompany + "\\" + version2 + "\\InstallPath");
                            if (folder == null || !(interpreter = new File(folder, exePath)).exists()) continue;
                            result2.add(FileUtil.toSystemDependentName((String)interpreter.getPath()));
                        }
                    }
                }
            }
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @RequiresBackgroundThread
    private static void findSubdirInstallations(@NotNull Collection<String> candidates, @NotNull String rootDir, @NotNull String dirPrefix, @NotNull String exeName) {
        if (candidates == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(12);
        }
        if (rootDir == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(13);
        }
        if (dirPrefix == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(14);
        }
        if (exeName == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(15);
        }
        try {
            Path rootDirNio = Path.of(rootDir, new String[0]);
            try (DirectoryStream<Path> f = Files.newDirectoryStream(rootDirNio);){
                for (Path dir : f) {
                    Path pythonExe;
                    if (!Files.isDirectory(dir, new LinkOption[0]) || !StringUtil.toLowerCase((String)dir.getFileName().toString()).startsWith(dirPrefix) || !Files.isExecutable(pythonExe = dir.resolve(exeName))) continue;
                    candidates.add(FileUtil.toSystemDependentName((String)pythonExe.toString()));
                }
            }
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 10, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/WinPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathStr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryService";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePathsImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/WinPythonSdkFlavor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinRegistryService";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonsFromStore";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sdkSeemsValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPythonFromStore";
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInRegistry";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findInPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSubdirInstallations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8, 10, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

