/*
 * Decompiled with CFR 0.152.
 */
package morfologik.speller;

public class HMatrix {
    private int[] p;
    private int rowLength;
    int columnHeight;
    int editDistance;

    public HMatrix(int distance, int maxLength) {
        this.rowLength = maxLength + 2;
        this.columnHeight = 2 * distance + 3;
        this.editDistance = distance;
        int size = this.rowLength * this.columnHeight;
        this.p = new int[size];
        for (int i = 0; i < this.rowLength - distance - 1; ++i) {
            this.p[i] = distance + 1;
            this.p[size - i - 1] = distance + 1;
        }
        for (int j = 0; j < 2 * distance + 1; ++j) {
            this.p[j * this.rowLength] = distance + 1 - j;
            this.p[Math.min((int)(this.p.length - 1), (int)((j + distance + 1) * this.rowLength + j))] = j;
        }
    }

    public int get(int i, int j) {
        return this.p[(j - i + this.editDistance + 1) * this.rowLength + j];
    }

    public void set(int i, int j, int val) {
        this.p[(j - i + this.editDistance + 1) * this.rowLength + j] = val;
    }
}

