/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandGrouping
extends SingleLineCommand2<SequenceDiagram> {
    private static final Pattern TRAILING_BRACKET_CONTENT_PATTERN = Pattern.compile("^(.*\\[\\[.*\\]\\].*?|.*?)\\[(.*)\\]$");

    public CommandGrouping() {
        super(CommandGrouping.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandGrouping.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "PARALLEL", "(&[%s]*)?"), new RegexLeaf(1, "TYPE", "(opt|alt|loop|par|par2|break|critical|else|end|also|group|partition)"), new RegexLeaf(2, "COLORS", "((?<!else)(?<!also)(?<!end)#\\w+)?(?:[%s]+(#\\w+))?"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "COMMENT", "(.*?)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        boolean parallel;
        boolean result;
        HColorSet colorSet = diagram.getSkinParam().getIHtmlColorSet();
        HColor backColorElement = this.getColor(arg.get("COLORS", 0), colorSet);
        HColor backColorGeneral = this.getColor(arg.get("COLORS", 1), colorSet);
        String type = StringUtils.goLowerCase(arg.get("TYPE", 0));
        String comment = arg.get("COMMENT", 0);
        GroupingType groupingType = GroupingType.getType(type);
        if ("group".equals(type)) {
            if (StringUtils.isEmpty(comment)) {
                comment = "group";
            } else {
                Matcher m = TRAILING_BRACKET_CONTENT_PATTERN.matcher(comment);
                if (m.find()) {
                    type = m.group(1);
                    comment = m.group(2);
                }
            }
        }
        if (!(result = diagram.grouping(type, comment, groupingType, backColorGeneral, backColorElement, parallel = arg.get("PARALLEL", 0) != null))) {
            return CommandExecutionResult.error("Cannot create group");
        }
        return CommandExecutionResult.ok();
    }

    private HColor getColor(String color, HColorSet colorSet) throws NoSuchColorException {
        if (color == null) {
            return null;
        }
        return colorSet.getColor(color);
    }
}

