/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ltr;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class StoreStat
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, StoreStat> {
    @Nullable
    private final Integer featureCount;
    @Nullable
    private final Integer featuresetCount;
    @Nullable
    private final Integer modelCount;
    @Nullable
    private final String status;
    public static final JsonpDeserializer<StoreStat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StoreStat::setupStoreStatDeserializer);

    private StoreStat(Builder builder) {
        this.featureCount = builder.featureCount;
        this.featuresetCount = builder.featuresetCount;
        this.modelCount = builder.modelCount;
        this.status = builder.status;
    }

    public static StoreStat of(Function<Builder, ObjectBuilder<StoreStat>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer featureCount() {
        return this.featureCount;
    }

    @Nullable
    public final Integer featuresetCount() {
        return this.featuresetCount;
    }

    @Nullable
    public final Integer modelCount() {
        return this.modelCount;
    }

    @Nullable
    public final String status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.featureCount != null) {
            generator.writeKey("feature_count");
            generator.write(this.featureCount.intValue());
        }
        if (this.featuresetCount != null) {
            generator.writeKey("featureset_count");
            generator.write(this.featuresetCount.intValue());
        }
        if (this.modelCount != null) {
            generator.writeKey("model_count");
            generator.write(this.modelCount.intValue());
        }
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStoreStatDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureCount, JsonpDeserializer.integerDeserializer(), "feature_count");
        op.add(Builder::featuresetCount, JsonpDeserializer.integerDeserializer(), "featureset_count");
        op.add(Builder::modelCount, JsonpDeserializer.integerDeserializer(), "model_count");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.featureCount);
        result = 31 * result + Objects.hashCode(this.featuresetCount);
        result = 31 * result + Objects.hashCode(this.modelCount);
        result = 31 * result + Objects.hashCode(this.status);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreStat other = (StoreStat)o;
        return Objects.equals(this.featureCount, other.featureCount) && Objects.equals(this.featuresetCount, other.featuresetCount) && Objects.equals(this.modelCount, other.modelCount) && Objects.equals(this.status, other.status);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, StoreStat> {
        @Nullable
        private Integer featureCount;
        @Nullable
        private Integer featuresetCount;
        @Nullable
        private Integer modelCount;
        @Nullable
        private String status;

        public Builder() {
        }

        private Builder(StoreStat o) {
            this.featureCount = o.featureCount;
            this.featuresetCount = o.featuresetCount;
            this.modelCount = o.modelCount;
            this.status = o.status;
        }

        private Builder(Builder o) {
            this.featureCount = o.featureCount;
            this.featuresetCount = o.featuresetCount;
            this.modelCount = o.modelCount;
            this.status = o.status;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder featureCount(@Nullable Integer value) {
            this.featureCount = value;
            return this;
        }

        @Nonnull
        public final Builder featuresetCount(@Nullable Integer value) {
            this.featuresetCount = value;
            return this;
        }

        @Nonnull
        public final Builder modelCount(@Nullable Integer value) {
            this.modelCount = value;
            return this;
        }

        @Nonnull
        public final Builder status(@Nullable String value) {
            this.status = value;
            return this;
        }

        @Override
        @Nonnull
        public StoreStat build() {
            this._checkSingleUse();
            return new StoreStat(this);
        }
    }
}

