/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.ApiClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.knn.DeleteModelRequest;
import org.opensearch.client.opensearch.knn.DeleteModelResponse;
import org.opensearch.client.opensearch.knn.GetModelRequest;
import org.opensearch.client.opensearch.knn.GetModelResponse;
import org.opensearch.client.opensearch.knn.KnnStatsRequest;
import org.opensearch.client.opensearch.knn.KnnStatsResponse;
import org.opensearch.client.opensearch.knn.SearchModelsRequest;
import org.opensearch.client.opensearch.knn.SearchModelsResponse;
import org.opensearch.client.opensearch.knn.TrainModelRequest;
import org.opensearch.client.opensearch.knn.TrainModelResponse;
import org.opensearch.client.opensearch.knn.WarmupRequest;
import org.opensearch.client.opensearch.knn.WarmupResponse;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.util.ObjectBuilder;

public class OpenSearchKnnAsyncClient
extends ApiClient<OpenSearchTransport, OpenSearchKnnAsyncClient> {
    public OpenSearchKnnAsyncClient(OpenSearchTransport transport) {
        super(transport, null);
    }

    public OpenSearchKnnAsyncClient(OpenSearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public OpenSearchKnnAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new OpenSearchKnnAsyncClient((OpenSearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest request) throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, DeleteModelRequest._ENDPOINT, this.transportOptions);
    }

    public final CompletableFuture<DeleteModelResponse> deleteModel(Function<DeleteModelRequest.Builder, ObjectBuilder<DeleteModelRequest>> fn) throws IOException, OpenSearchException {
        return this.deleteModel(fn.apply(new DeleteModelRequest.Builder()).build());
    }

    public CompletableFuture<GetModelResponse> getModel(GetModelRequest request) throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, GetModelRequest._ENDPOINT, this.transportOptions);
    }

    public final CompletableFuture<GetModelResponse> getModel(Function<GetModelRequest.Builder, ObjectBuilder<GetModelRequest>> fn) throws IOException, OpenSearchException {
        return this.getModel(fn.apply(new GetModelRequest.Builder()).build());
    }

    public CompletableFuture<SearchModelsResponse> searchModels(SearchModelsRequest request) throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, SearchModelsRequest._ENDPOINT, this.transportOptions);
    }

    public final CompletableFuture<SearchModelsResponse> searchModels(Function<SearchModelsRequest.Builder, ObjectBuilder<SearchModelsRequest>> fn) throws IOException, OpenSearchException {
        return this.searchModels(fn.apply(new SearchModelsRequest.Builder()).build());
    }

    public final CompletableFuture<SearchModelsResponse> searchModels() throws IOException, OpenSearchException {
        return this.searchModels(new SearchModelsRequest.Builder().build());
    }

    public CompletableFuture<KnnStatsResponse> stats(KnnStatsRequest request) throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, KnnStatsRequest._ENDPOINT, this.transportOptions);
    }

    public final CompletableFuture<KnnStatsResponse> stats(Function<KnnStatsRequest.Builder, ObjectBuilder<KnnStatsRequest>> fn) throws IOException, OpenSearchException {
        return this.stats(fn.apply(new KnnStatsRequest.Builder()).build());
    }

    public final CompletableFuture<KnnStatsResponse> stats() throws IOException, OpenSearchException {
        return this.stats(new KnnStatsRequest.Builder().build());
    }

    public CompletableFuture<TrainModelResponse> trainModel(TrainModelRequest request) throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, TrainModelRequest._ENDPOINT, this.transportOptions);
    }

    public final CompletableFuture<TrainModelResponse> trainModel(Function<TrainModelRequest.Builder, ObjectBuilder<TrainModelRequest>> fn) throws IOException, OpenSearchException {
        return this.trainModel(fn.apply(new TrainModelRequest.Builder()).build());
    }

    public CompletableFuture<WarmupResponse> warmup(WarmupRequest request) throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, WarmupRequest._ENDPOINT, this.transportOptions);
    }

    public final CompletableFuture<WarmupResponse> warmup(Function<WarmupRequest.Builder, ObjectBuilder<WarmupRequest>> fn) throws IOException, OpenSearchException {
        return this.warmup(fn.apply(new WarmupRequest.Builder()).build());
    }
}

