/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.enhancedclient;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.LegacyOverride;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.PlaintextOverride;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.Keyring;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;

public class DynamoDbEnhancedTableEncryptionConfig {
    private final String logicalTableName;
    private final List<TableSchema<?>> schemaOnEncrypt;
    private final List<String> allowedUnsignedAttributes;
    private final String allowedUnsignedAttributePrefix;
    private final Keyring keyring;
    private final CryptographicMaterialsManager cmm;
    private final LegacyOverride legacyOverride;
    private final PlaintextOverride plaintextOverride;
    private final DBEAlgorithmSuiteId algorithmSuiteId;

    protected DynamoDbEnhancedTableEncryptionConfig(BuilderImpl builder) {
        this.logicalTableName = builder.logicalTableName();
        this.schemaOnEncrypt = builder.schemaOnEncrypt();
        this.allowedUnsignedAttributes = builder.allowedUnsignedAttributes();
        this.allowedUnsignedAttributePrefix = builder.allowedUnsignedAttributePrefix();
        this.keyring = builder.keyring();
        this.cmm = builder.cmm();
        this.legacyOverride = builder.legacyOverride();
        this.plaintextOverride = builder.plaintextOverride();
        this.algorithmSuiteId = builder.algorithmSuiteId();
    }

    public String logicalTableName() {
        return this.logicalTableName;
    }

    public List<TableSchema<?>> schemaOnEncrypt() {
        return this.schemaOnEncrypt;
    }

    public List<String> allowedUnsignedAttributes() {
        return this.allowedUnsignedAttributes;
    }

    public String allowedUnsignedAttributePrefix() {
        return this.allowedUnsignedAttributePrefix;
    }

    public Keyring keyring() {
        return this.keyring;
    }

    public CryptographicMaterialsManager cmm() {
        return this.cmm;
    }

    public LegacyOverride legacyOverride() {
        return this.legacyOverride;
    }

    public PlaintextOverride plaintextOverride() {
        return this.plaintextOverride;
    }

    public DBEAlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    protected static class BuilderImpl
    implements Builder {
        protected String logicalTableName;
        protected List<TableSchema<?>> schemaOnEncrypt;
        protected List<String> allowedUnsignedAttributes;
        protected String allowedUnsignedAttributePrefix;
        protected Keyring keyring;
        protected CryptographicMaterialsManager cmm;
        protected LegacyOverride legacyOverride;
        protected PlaintextOverride plaintextOverride;
        protected DBEAlgorithmSuiteId algorithmSuiteId;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DynamoDbEnhancedTableEncryptionConfig model) {
            this.logicalTableName = model.logicalTableName();
            this.schemaOnEncrypt = model.schemaOnEncrypt();
            this.allowedUnsignedAttributes = model.allowedUnsignedAttributes();
            this.allowedUnsignedAttributePrefix = model.allowedUnsignedAttributePrefix();
            this.keyring = model.keyring();
            this.cmm = model.cmm();
            this.legacyOverride = model.legacyOverride();
            this.plaintextOverride = model.plaintextOverride();
            this.algorithmSuiteId = model.algorithmSuiteId();
        }

        @Override
        public Builder logicalTableName(String logicalTableName) {
            this.logicalTableName = logicalTableName;
            return this;
        }

        @Override
        public String logicalTableName() {
            return this.logicalTableName;
        }

        @Override
        public Builder schemaOnEncrypt(TableSchema<?> schemaOnEncrypt) {
            if (Objects.isNull(this.schemaOnEncrypt())) {
                this.schemaOnEncrypt = new ArrayList();
            }
            this.schemaOnEncrypt.add(schemaOnEncrypt);
            return this;
        }

        @Override
        public List<TableSchema<?>> schemaOnEncrypt() {
            return this.schemaOnEncrypt;
        }

        @Override
        public Builder allowedUnsignedAttributes(List<String> allowedUnsignedAttributes) {
            this.allowedUnsignedAttributes = allowedUnsignedAttributes;
            return this;
        }

        @Override
        public List<String> allowedUnsignedAttributes() {
            return this.allowedUnsignedAttributes;
        }

        @Override
        public Builder allowedUnsignedAttributePrefix(String allowedUnsignedAttributePrefix) {
            this.allowedUnsignedAttributePrefix = allowedUnsignedAttributePrefix;
            return this;
        }

        @Override
        public String allowedUnsignedAttributePrefix() {
            return this.allowedUnsignedAttributePrefix;
        }

        @Override
        public <I extends IKeyring> Builder keyring(I keyring) {
            this.keyring = Keyring.wrap(keyring);
            return this;
        }

        public Keyring keyring() {
            return this.keyring;
        }

        @Override
        public <I extends ICryptographicMaterialsManager> Builder cmm(I cmm) {
            this.cmm = CryptographicMaterialsManager.wrap(cmm);
            return this;
        }

        public CryptographicMaterialsManager cmm() {
            return this.cmm;
        }

        @Override
        public Builder legacyOverride(LegacyOverride legacyOverride) {
            this.legacyOverride = legacyOverride;
            return this;
        }

        @Override
        public LegacyOverride legacyOverride() {
            return this.legacyOverride;
        }

        @Override
        public Builder plaintextOverride(PlaintextOverride plaintextOverride) {
            this.plaintextOverride = plaintextOverride;
            return this;
        }

        @Override
        public PlaintextOverride plaintextOverride() {
            return this.plaintextOverride;
        }

        @Override
        public Builder algorithmSuiteId(DBEAlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public DBEAlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public DynamoDbEnhancedTableEncryptionConfig build() {
            if (Objects.isNull(this.schemaOnEncrypt())) {
                throw new IllegalArgumentException("Missing value for required field `schemaOnEncrypt`");
            }
            return new DynamoDbEnhancedTableEncryptionConfig(this);
        }
    }

    public static interface Builder {
        public String logicalTableName();

        public Builder logicalTableName(String var1);

        public Builder schemaOnEncrypt(TableSchema<?> var1);

        public List<TableSchema<?>> schemaOnEncrypt();

        public Builder allowedUnsignedAttributes(List<String> var1);

        public List<String> allowedUnsignedAttributes();

        public Builder allowedUnsignedAttributePrefix(String var1);

        public String allowedUnsignedAttributePrefix();

        public <I extends IKeyring> Builder keyring(I var1);

        public <I extends ICryptographicMaterialsManager> Builder cmm(I var1);

        public Builder legacyOverride(LegacyOverride var1);

        public LegacyOverride legacyOverride();

        public Builder plaintextOverride(PlaintextOverride var1);

        public PlaintextOverride plaintextOverride();

        public Builder algorithmSuiteId(DBEAlgorithmSuiteId var1);

        public DBEAlgorithmSuiteId algorithmSuiteId();

        public DynamoDbEnhancedTableEncryptionConfig build();
    }
}

