/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.hooks.HookCallback;
import org.opensearch.ml.common.hooks.HookEvent;

public class HookRegistry {
    @Generated
    private static final Logger log = LogManager.getLogger(HookRegistry.class);
    private final Map<Class<? extends HookEvent>, List<HookCallback<? extends HookEvent>>> callbacks = new ConcurrentHashMap<Class<? extends HookEvent>, List<HookCallback<? extends HookEvent>>>();

    public <T extends HookEvent> void addCallback(Class<T> eventType, HookCallback<T> callback) {
        this.callbacks.computeIfAbsent(eventType, k -> new ArrayList()).add(callback);
        log.debug("Registered callback for event type: {}", (Object)eventType.getSimpleName());
    }

    public <T extends HookEvent> void emit(T event) {
        Class<?> eventType = event.getClass();
        List<HookCallback<? extends HookEvent>> eventCallbacks = this.callbacks.get(eventType);
        log.info("HookRegistry.emit() called for event type: {}, callbacks available: {}", (Object)eventType.getSimpleName(), (Object)(eventCallbacks != null ? eventCallbacks.size() : 0));
        if (eventCallbacks != null) {
            log.info("Emitting {} event to {} callbacks", (Object)eventType.getSimpleName(), (Object)eventCallbacks.size());
            for (HookCallback<? extends HookEvent> callback : eventCallbacks) {
                try {
                    log.info("Executing callback: {}", (Object)callback.getClass().getSimpleName());
                    callback.handle(event);
                }
                catch (Exception e) {
                    log.error("Error executing hook callback for event type {}: {}", (Object)eventType.getSimpleName(), (Object)e.getMessage(), (Object)e);
                }
            }
        } else {
            log.warn("No callbacks registered for event type: {}", (Object)eventType.getSimpleName());
        }
    }

    public int getCallbackCount(Class<? extends HookEvent> eventType) {
        List<HookCallback<? extends HookEvent>> eventCallbacks = this.callbacks.get(eventType);
        return eventCallbacks != null ? eventCallbacks.size() : 0;
    }

    public void clear() {
        this.callbacks.clear();
        log.debug("Cleared all hook callbacks");
    }
}

