/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.SchemaLoader;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;

public class MapSchemaLoader
implements SchemaLoader {
    private final Function<String, String> mappings;

    public MapSchemaLoader(Map<String, String> mappings) {
        this(mappings::get);
    }

    public MapSchemaLoader(Function<String, String> mappings) {
        this.mappings = mappings;
    }

    public <T> MapSchemaLoader(Function<String, T> mapIriToObject, Function<T, String> mapObjectToData) {
        this.mappings = iri -> {
            Object result = mapIriToObject.apply((String)iri);
            if (result != null) {
                return (String)mapObjectToData.apply(result);
            }
            return null;
        };
    }

    @Override
    public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
        try {
            String result = this.mappings.apply(absoluteIri.toString());
            if (result != null) {
                return () -> new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

