RSpec.describe MetasploitDataModels::AutomaticExploitation::Run, type: :model do
  subject(:run) { FactoryBot.create(:automatic_exploitation_run) }


  describe "database" do
    describe "columns" do
      it { is_expected.to have_db_column(:workspace_id).of_type(:integer) }
      it { is_expected.to have_db_index(:workspace_id) }
      it { is_expected.to have_db_column(:user_id).of_type(:integer) }
      it { is_expected.to have_db_index(:user_id) }
    end
  end

  describe "associations" do
    it { is_expected.to belong_to(:match_set).class_name('MetasploitDataModels::AutomaticExploitation::MatchSet') }
    it { is_expected.to belong_to(:workspace).class_name('Mdm::Workspace') }
    it { is_expected.to belong_to(:workspace).inverse_of(:automatic_exploitation_runs) }
    it { is_expected.to belong_to(:user).class_name('Mdm::User') }
    it { is_expected.to belong_to(:user).inverse_of(:automatic_exploitation_runs) }
    it { is_expected.to have_many(:match_results) }
  end

  describe "destroying" do
    describe "associated MatchResults" do
      before(:example) do
        match_set = FactoryBot.create(:automatic_exploitation_match_set)
        match = FactoryBot.create(:automatic_exploitation_match, match_set: match_set)
        run.match_set = match_set
        FactoryBot.create(:automatic_exploitation_match_result, match: match, run: run)
      end

      it 'should happen when you delete the Run' do
        expect { run.destroy }.to change { MetasploitDataModels::AutomaticExploitation::MatchResult.count }.by(-1)
      end
    end

  end
end
