/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterDocIdSetIterator;

public abstract class TwoPhaseIterator {
    protected final DocIdSetIterator approximation;

    protected TwoPhaseIterator(DocIdSetIterator approximation) {
        this.approximation = Objects.requireNonNull(approximation);
    }

    public static DocIdSetIterator asDocIdSetIterator(TwoPhaseIterator twoPhaseIterator) {
        return new TwoPhaseIteratorAsDocIdSetIterator(twoPhaseIterator);
    }

    public static TwoPhaseIterator unwrap(DocIdSetIterator iterator) {
        if (iterator instanceof TwoPhaseIteratorAsDocIdSetIterator) {
            return ((TwoPhaseIteratorAsDocIdSetIterator)iterator).twoPhaseIterator;
        }
        return null;
    }

    public DocIdSetIterator approximation() {
        return this.approximation;
    }

    public abstract boolean matches() throws IOException;

    public abstract float matchCost();

    public int docIDRunEnd() throws IOException {
        return this.approximation().docID();
    }

    private static class TwoPhaseIteratorAsDocIdSetIterator
    extends FilterDocIdSetIterator {
        final TwoPhaseIterator twoPhaseIterator;

        TwoPhaseIteratorAsDocIdSetIterator(TwoPhaseIterator twoPhaseIterator) {
            super(twoPhaseIterator.approximation());
            this.twoPhaseIterator = twoPhaseIterator;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.doNext(this.in.nextDoc());
        }

        @Override
        public int advance(int target) throws IOException {
            return this.doNext(this.in.advance(target));
        }

        private int doNext(int doc) throws IOException {
            while (doc != Integer.MAX_VALUE) {
                if (this.twoPhaseIterator.matches()) {
                    return doc;
                }
                doc = this.in.nextDoc();
            }
            return Integer.MAX_VALUE;
        }
    }
}

