/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.View;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;

public class DatabaseScript {
    public static Result getScript(Database database, boolean bl) {
        String string;
        String string2;
        Result result = Result.newSingleColumnResult("COMMAND", 12);
        result.metaData.tableNames[0] = "SYSTEM_SCRIPT";
        if (database.collation.name != null) {
            string2 = StringConverter.toQuotedString(database.collation.name, '\"', true);
            DatabaseScript.addRow(result, "SET DATABASE COLLATION " + string2);
        }
        Iterator iterator = database.getGranteeManager().getRoleNames().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if ("DBA".equals(string2)) continue;
            DatabaseScript.addRow(result, "CREATE ROLE " + string2);
        }
        HashMap hashMap = database.getAliasMap();
        HashMap hashMap2 = Library.getAliasMap();
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = (String)hashMap.get(string3);
            string = (String)hashMap2.get(string3);
            if (string != null && string.equals(string4)) continue;
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("CREATE").append(' ').append("ALIAS").append(' ');
            stringBuffer.append(string3);
            stringBuffer.append(" FOR \"");
            stringBuffer.append(string4);
            stringBuffer.append('\"');
            DatabaseScript.addRow(result, stringBuffer.toString());
        }
        DatabaseScript.addSchemaStatements(database, result, bl);
        DatabaseScript.addRightsStatements(database, result);
        if (database.logger.hasLog()) {
            boolean bl2;
            int n = database.logger.getWriteDelay();
            boolean bl3 = bl2 = n < 1000;
            if (bl2) {
                if (n != 0 && n < 20) {
                    n = 20;
                }
            } else {
                n /= 1000;
            }
            string = "SET WRITE_DELAY " + n + (bl2 ? " MILLIS" : "");
            DatabaseScript.addRow(result, string);
        }
        return result;
    }

    static void addSchemaStatements(Database database, Result result, boolean bl) {
        Iterator iterator = database.schemaManager.userSchemaNameIterator();
        while (iterator.hasNext()) {
            int n;
            Object object;
            int n2;
            Object object2;
            Object object3;
            Object object4;
            int n3;
            Object object5;
            String string = (String)iterator.next();
            HsqlNameManager.HsqlName hsqlName = database.schemaManager.toSchemaHsqlName(string);
            HashMappedList hashMappedList = database.schemaManager.getTables(hsqlName.name);
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            Object object6 = DatabaseScript.getSchemaCreateDDL(database, hsqlName);
            DatabaseScript.addRow(result, (String)object6);
            object6 = database.schemaManager.sequenceIterator(hsqlName.name);
            while (object6.hasNext()) {
                object5 = (NumberSequence)object6.next();
                StringBuffer stringBuffer = new StringBuffer(128);
                stringBuffer.append("CREATE").append(' ');
                stringBuffer.append("SEQUENCE").append(' ');
                stringBuffer.append(((NumberSequence)object5).getName().statementName).append(' ');
                stringBuffer.append("AS").append(' ');
                stringBuffer.append(Types.getTypeString(((NumberSequence)object5).getType())).append(' ');
                stringBuffer.append("START").append(' ');
                stringBuffer.append("WITH").append(' ');
                stringBuffer.append(((NumberSequence)object5).peek()).append(' ');
                if (((NumberSequence)object5).getIncrement() != 1L) {
                    stringBuffer.append("INCREMENT").append(' ');
                    stringBuffer.append("BY").append(' ');
                    stringBuffer.append(((NumberSequence)object5).getIncrement()).append(' ');
                }
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
            int n4 = hashMappedList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                object4 = (Table)hashMappedList.get(n3);
                if (((Table)object4).isView()) continue;
                object3 = new StringBuffer(128);
                DatabaseScript.getTableDDL(database, (Table)object4, n3, hsqlArrayList, false, (StringBuffer)object3);
                DatabaseScript.addRow(result, ((StringBuffer)object3).toString());
                for (int i = 1; i < ((Table)object4).getIndexCount(); ++i) {
                    object2 = ((Table)object4).getIndex(i);
                    if (HsqlNameManager.HsqlName.isReservedName(((Index)object2).getName().name)) continue;
                    object3 = new StringBuffer(64);
                    ((StringBuffer)object3).append("CREATE").append(' ');
                    if (((Index)object2).isUnique()) {
                        ((StringBuffer)object3).append("UNIQUE").append(' ');
                    }
                    ((StringBuffer)object3).append("INDEX").append(' ');
                    ((StringBuffer)object3).append(((Index)object2).getName().statementName);
                    ((StringBuffer)object3).append(' ').append("ON").append(' ');
                    ((StringBuffer)object3).append(((Table)object4).getName().statementName);
                    int[] nArray = ((Index)object2).getColumns();
                    n2 = ((Index)object2).getVisibleColumns();
                    DatabaseScript.getColumnList((Table)object4, nArray, n2, (StringBuffer)object3);
                    DatabaseScript.addRow(result, ((StringBuffer)object3).toString());
                }
                if (((Table)object4).isText() && ((Table)object4).isConnected() && ((Table)object4).isDataReadOnly()) {
                    object3 = new StringBuffer(64);
                    ((StringBuffer)object3).append("SET").append(' ').append("TABLE").append(' ');
                    ((StringBuffer)object3).append(((Table)object4).getName().statementName);
                    ((StringBuffer)object3).append(' ').append("READONLY").append(' ').append("TRUE");
                    DatabaseScript.addRow(result, ((StringBuffer)object3).toString());
                }
                if ((object = DatabaseScript.getDataSource((Table)object4)) != null) {
                    DatabaseScript.addRow(result, (String)object);
                }
                object2 = DatabaseScript.getDataSourceHeader((Table)object4);
                if (!bl && object2 != null) {
                    DatabaseScript.addRow(result, (String)object2);
                }
                n = 12;
                for (n2 = 0; n2 < n; ++n2) {
                    HsqlArrayList hsqlArrayList2 = ((Table)object4).triggerLists[n2];
                    if (hsqlArrayList2 == null) continue;
                    int n5 = hsqlArrayList2.size();
                    for (int i = 0; i < n5; ++i) {
                        object3 = ((TriggerDef)hsqlArrayList2.get(i)).getDDL();
                        DatabaseScript.addRow(result, ((StringBuffer)object3).toString());
                    }
                }
            }
            n4 = hsqlArrayList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                object4 = (Constraint)hsqlArrayList.get(n3);
                object3 = new StringBuffer(128);
                ((StringBuffer)object3).append("ALTER").append(' ').append("TABLE").append(' ');
                ((StringBuffer)object3).append(((Constraint)object4).getRef().getName().statementName);
                ((StringBuffer)object3).append(' ').append("ADD").append(' ');
                DatabaseScript.getFKStatement((Constraint)object4, (StringBuffer)object3);
                DatabaseScript.addRow(result, ((StringBuffer)object3).toString());
            }
            object5 = database.sessionManager.getSysSession();
            int n6 = hashMappedList.size();
            for (n4 = 0; n4 < n6; ++n4) {
                object3 = (Table)hashMappedList.get(n4);
                if (!bl || !((Table)object3).isIndexCached() || ((Table)object3).isEmpty((Session)object5)) continue;
                DatabaseScript.addRow(result, DatabaseScript.getIndexRootsDDL((Table)hashMappedList.get(n4)));
            }
            n6 = hashMappedList.size();
            for (n4 = 0; n4 < n6; ++n4) {
                object3 = (Table)hashMappedList.get(n4);
                if (((Table)object3).isTemp()) continue;
                object = DatabaseScript.getIdentityUpdateDDL((Table)object3);
                DatabaseScript.addRow(result, (String)object);
            }
            n6 = hashMappedList.size();
            for (n4 = 0; n4 < n6; ++n4) {
                object3 = (Table)hashMappedList.get(n4);
                if (!((Table)object3).isView()) continue;
                object = (View)hashMappedList.get(n4);
                object2 = new StringBuffer(128);
                ((StringBuffer)object2).append("CREATE").append(' ').append("VIEW").append(' ');
                ((StringBuffer)object2).append(((Table)object).getName().statementName).append(' ').append('(');
                n = ((Table)object).getColumnCount();
                for (n2 = 0; n2 < n; ++n2) {
                    ((StringBuffer)object2).append(((Table)object).getColumn((int)n2).columnName.statementName);
                    if (n2 >= n - 1) continue;
                    ((StringBuffer)object2).append(',');
                }
                ((StringBuffer)object2).append(')').append(' ').append("AS").append(' ');
                ((StringBuffer)object2).append(((View)object).getStatement());
                DatabaseScript.addRow(result, ((StringBuffer)object2).toString());
            }
        }
    }

    static String getIdentityUpdateDDL(Table table) {
        if (table.identityColumn == -1) {
            return "";
        }
        String string = table.getName().statementName;
        String string2 = table.getColumn((int)table.identityColumn).columnName.statementName;
        long l = table.identitySequence.peek();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("ALTER").append(' ').append("TABLE").append(' ').append(string).append(' ').append("ALTER").append(' ').append("COLUMN").append(' ').append(string2).append(' ').append("RESTART").append(' ').append("WITH").append(' ').append(l);
        return stringBuffer.toString();
    }

    static String getIndexRootsDDL(Table table) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("INDEX").append('\'');
        stringBuffer.append(table.getIndexRoots());
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    static String getSchemaCreateDDL(Database database, HsqlNameManager.HsqlName hsqlName) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("SCHEMA").append(' ');
        stringBuffer.append(hsqlName.statementName).append(' ');
        stringBuffer.append("AUTHORIZATION").append(' ');
        stringBuffer.append("DBA");
        return stringBuffer.toString();
    }

    static void getTableDDL(Database database, Table table, int n, HsqlArrayList hsqlArrayList, boolean bl, StringBuffer stringBuffer) {
        Object object;
        stringBuffer.append("CREATE").append(' ');
        if (table.isTemp) {
            stringBuffer.append("GLOBAL").append(' ');
            stringBuffer.append("TEMPORARY").append(' ');
        }
        if (table.isText()) {
            stringBuffer.append("TEXT").append(' ');
        } else if (table.isCached()) {
            stringBuffer.append("CACHED").append(' ');
        } else {
            stringBuffer.append("MEMORY").append(' ');
        }
        stringBuffer.append("TABLE").append(' ');
        if (bl) {
            stringBuffer.append(table.getName().schema.statementName).append('.');
        }
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append('(');
        int n2 = table.getColumnCount();
        int[] nArray = table.getPrimaryKey();
        HsqlNameManager.HsqlName hsqlName = null;
        Constraint constraint = table.getPrimaryConstraint();
        if (constraint != null && !constraint.getName().isReservedName()) {
            hsqlName = constraint.getName();
        }
        for (int i = 0; i < n2; ++i) {
            Column column = table.getColumn(i);
            String string = column.columnName.statementName;
            stringBuffer.append(string);
            stringBuffer.append(' ');
            String object2 = Types.getTypeString(column.getType());
            stringBuffer.append(object2);
            boolean nArray2 = false;
            if (column.getType() == 93) {
                if (column.getSize() != 6) {
                    nArray2 = true;
                }
            } else {
                boolean bl2 = nArray2 = column.getSize() > 0;
            }
            if (nArray2) {
                stringBuffer.append('(');
                stringBuffer.append(column.getSize());
                if (column.getScale() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(column.getScale());
                }
                stringBuffer.append(')');
            }
            if ((object = column.getDefaultDDL()) != null) {
                stringBuffer.append(' ').append("DEFAULT").append(' ');
                stringBuffer.append((String)object);
            }
            if (i == table.getIdentityColumn()) {
                stringBuffer.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH ");
                stringBuffer.append(column.identityStart);
                if (column.identityIncrement != 1L) {
                    stringBuffer.append(",").append("INCREMENT").append(' ').append("BY").append(' ');
                    stringBuffer.append(column.identityIncrement);
                }
                stringBuffer.append(")");
            }
            if (!column.isNullable()) {
                stringBuffer.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (nArray.length == 1 && i == nArray[0] && hsqlName == null) {
                stringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
            }
            if (i >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        if (nArray.length > 1 || nArray.length == 1 && hsqlName != null) {
            stringBuffer.append(',');
            if (hsqlName != null) {
                stringBuffer.append("CONSTRAINT").append(' ');
                stringBuffer.append(hsqlName.statementName).append(' ');
            }
            stringBuffer.append("PRIMARY").append(' ').append("KEY");
            DatabaseScript.getColumnList(table, nArray, nArray.length, stringBuffer);
        }
        block8: for (Constraint constraint2 : table.getConstraints()) {
            switch (constraint2.getType()) {
                case 2: {
                    stringBuffer.append(',').append("CONSTRAINT").append(' ');
                    stringBuffer.append(constraint2.getName().statementName);
                    stringBuffer.append(' ').append("UNIQUE");
                    int[] nArray2 = constraint2.getMainColumns();
                    DatabaseScript.getColumnList(constraint2.getMain(), nArray2, nArray2.length, stringBuffer);
                    continue block8;
                }
                case 0: {
                    object = constraint2.getMain();
                    int n3 = database.schemaManager.getTableIndex((Table)object);
                    if (n3 > n) {
                        hsqlArrayList.add(constraint2);
                        continue block8;
                    }
                    stringBuffer.append(',');
                    DatabaseScript.getFKStatement(constraint2, stringBuffer);
                    continue block8;
                }
                case 3: {
                    try {
                        stringBuffer.append(',').append("CONSTRAINT").append(' ');
                        stringBuffer.append(constraint2.getName().statementName);
                        stringBuffer.append(' ').append("CHECK").append('(');
                        stringBuffer.append(constraint2.core.check.getDDL());
                        stringBuffer.append(')');
                        continue block8;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
        }
        stringBuffer.append(')');
        if (table.onCommitPreserve) {
            stringBuffer.append(' ').append("ON").append(' ');
            stringBuffer.append("COMMIT").append(' ').append("PRESERVE");
            stringBuffer.append(' ').append("ROWS");
        }
    }

    static String getDataSource(Table table) {
        String string = table.getDataSource();
        if (string == null) {
            return null;
        }
        boolean bl = table.isDescDataSource();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append(' ').append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(' ').append("DESC");
        }
        return stringBuffer.toString();
    }

    static String getDataSourceHeader(Table table) {
        String string = table.getHeader();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append(' ');
        stringBuffer.append("HEADER").append(' ');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static void getColumnList(Table table, int[] nArray, int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(table.getColumn((int)nArray[i]).columnName.statementName);
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
    }

    private static void getFKStatement(Constraint constraint, StringBuffer stringBuffer) {
        stringBuffer.append("CONSTRAINT").append(' ');
        stringBuffer.append(constraint.getName().statementName);
        stringBuffer.append(' ').append("FOREIGN").append(' ').append("KEY");
        int[] nArray = constraint.getRefColumns();
        DatabaseScript.getColumnList(constraint.getRef(), nArray, nArray.length, stringBuffer);
        stringBuffer.append(' ').append("REFERENCES").append(' ');
        stringBuffer.append(constraint.getMain().getName().statementName);
        nArray = constraint.getMainColumns();
        DatabaseScript.getColumnList(constraint.getMain(), nArray, nArray.length, stringBuffer);
        if (constraint.getDeleteAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getDeleteAction()));
        }
        if (constraint.getUpdateAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getUpdateAction()));
        }
    }

    private static String getFKAction(int n) {
        switch (n) {
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    private static void addRow(Result result, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private static void addRightsStatements(Database database, Result result) {
        String string;
        Object object;
        HashMappedList hashMappedList = database.getUserManager().getUsers();
        Iterator iterator = hashMappedList.values().iterator();
        GranteeManager granteeManager = database.getGranteeManager();
        Iterator iterator2 = granteeManager.getGrantees().iterator();
        while (iterator.hasNext()) {
            object = (User)iterator.next();
            string = ((User)object).getName();
            if (string.equals("PUBLIC")) continue;
            DatabaseScript.addRow(result, ((User)object).getCreateUserDDL());
        }
        while (iterator2.hasNext()) {
            IntValueHashMap intValueHashMap;
            object = (Grantee)iterator2.next();
            string = ((Grantee)object).getName();
            if (string.equals("_SYSTEM") || string.equals("DBA")) continue;
            String string2 = ((Grantee)object).allRolesString();
            if (string2 != null) {
                DatabaseScript.addRow(result, "GRANT " + string2 + " TO " + string);
            }
            if ((intValueHashMap = ((Grantee)object).getRights()) == null) continue;
            Iterator iterator3 = intValueHashMap.keySet().iterator();
            while (iterator3.hasNext()) {
                Object object2 = iterator3.next();
                int n = intValueHashMap.get(object2, 0);
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("GRANT").append(' ');
                stringBuffer.append(GranteeManager.getRightsList(n));
                stringBuffer.append(' ').append("ON").append(' ');
                if (object2 instanceof String) {
                    if (object2.equals("java.lang.Math") || object2.equals("org.hsqldb.Library")) continue;
                    stringBuffer.append("CLASS \"");
                    stringBuffer.append((String)object2);
                    stringBuffer.append('\"');
                } else {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)object2;
                    Table table = database.schemaManager.findUserTable(null, hsqlName.name, hsqlName.schema.name);
                    if (table == null) continue;
                    stringBuffer.append(hsqlName.schema.statementName).append('.').append(hsqlName.statementName);
                }
                stringBuffer.append(' ').append("TO").append(' ');
                stringBuffer.append(((Grantee)object).getName());
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
        }
    }
}

