/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Texture2DGroup extends Resource {

	public Texture2DGroup(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the count of tex2coords in the Texture2DGroup.
	 *
	 * @return returns the count of tex2coords.
	 * @throws Lib3MFException
	 */
	public int getCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2dgroup_getcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * returns all the PropertyIDs of all tex2coords in this Texture2DGroup
	 *
	 * @return PropertyID of the tex2coords in the Texture2DGroup.
	 * @throws Lib3MFException
	 */
	public int[] getAllPropertyIDs() throws Lib3MFException {
		Pointer countNeededPropertyIDs = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2dgroup_getallpropertyids.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededPropertyIDs, Pointer.NULL}));
		long countPropertyIDs = countNeededPropertyIDs.getLong(0);
		Pointer bufferPropertyIDs = new Memory(Math.max(1, 4 * countPropertyIDs));
		mWrapper.checkError(this, mWrapper.lib3mf_texture2dgroup_getallpropertyids.invokeInt(new java.lang.Object[]{mHandle, countPropertyIDs, countNeededPropertyIDs, bufferPropertyIDs}));
		return bufferPropertyIDs.getIntArray(0, (int)countPropertyIDs);
	}

	/**
	 * Adds a new tex2coord to the Texture2DGroup
	 *
	 * @param uVCoordinate The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	 * @return returns new PropertyID of the new tex2coord in the Texture2DGroup.
	 * @throws Lib3MFException
	 */
	public int addTex2Coord(Tex2Coord uVCoordinate) throws Lib3MFException {
		Pointer bufferUVCoordinate = new Memory(Tex2Coord.SIZE);
		uVCoordinate.writeToPointer(bufferUVCoordinate, 0);
		Pointer bufferPropertyID = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2dgroup_addtex2coord.invokeInt(new java.lang.Object[]{mHandle, bufferUVCoordinate, bufferPropertyID}));
		return bufferPropertyID.getInt(0);
	}

	/**
	 * Obtains a tex2coord to the Texture2DGroup
	 *
	 * @param propertyID the PropertyID of the tex2coord in the Texture2DGroup.
	 * @return The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	 * @throws Lib3MFException
	 */
	public Tex2Coord getTex2Coord(int propertyID) throws Lib3MFException {
		Pointer bufferUVCoordinate = new Memory(Tex2Coord.SIZE);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2dgroup_gettex2coord.invokeInt(new java.lang.Object[]{mHandle, propertyID, bufferUVCoordinate}));
		Tex2Coord uVCoordinate = new Tex2Coord();
		uVCoordinate.readFromPointer(bufferUVCoordinate, 0);
		return uVCoordinate;
	}

	/**
	 * Removes a tex2coords from the Texture2DGroup.
	 *
	 * @param propertyID PropertyID of the tex2coords in the Texture2DGroup.
	 * @throws Lib3MFException
	 */
	public void removeTex2Coord(int propertyID) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_texture2dgroup_removetex2coord.invokeInt(new java.lang.Object[]{mHandle, propertyID}));
	}

	/**
	 * Obtains the texture2D instance of this group.
	 *
	 * @return the texture2D instance of this group.
	 * @throws Lib3MFException
	 */
	public Texture2D getTexture2D() throws Lib3MFException {
		Pointer bufferTexture2DInstance = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2dgroup_gettexture2d.invokeInt(new java.lang.Object[]{mHandle, bufferTexture2DInstance}));
		Pointer valueTexture2DInstance = bufferTexture2DInstance.getPointer(0);
		Texture2D texture2DInstance = null;
		if (valueTexture2DInstance == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Texture2DInstance was a null pointer");
		}
		texture2DInstance = mWrapper.PolymorphicFactory(valueTexture2DInstance, Texture2D.class);
		return texture2DInstance;
	}


}

