/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.expiration;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.expiration.ExpirationTask;
import org.keycloak.models.utils.KeycloakModelUtils;

abstract class BaseExpirationTask
implements ExpirationTask {
    protected static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final AtomicReference<PurgeExpiredTask> currentTask = new AtomicReference();
    private final KeycloakSessionFactory factory;
    private final int delaySeconds;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Consumer<Duration> onTaskExecuted;
    private final ExecutorService executorService;

    BaseExpirationTask(KeycloakSessionFactory factory, ScheduledExecutorService scheduledExecutorService, int delaySeconds, Consumer<Duration> onTaskExecuted) {
        this.factory = Objects.requireNonNull(factory);
        this.delaySeconds = delaySeconds;
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService);
        this.onTaskExecuted = Objects.requireNonNullElse(onTaskExecuted, value -> {});
        this.executorService = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("user-session-purge-expired");
            return t;
        });
    }

    @Override
    public void start() {
        this.scheduleNextTask();
    }

    @Override
    public void stop() {
        PurgeExpiredTask existing = this.currentTask.getAndSet(null);
        if (existing == null) {
            return;
        }
        existing.scheduledFuture().cancel(true);
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeExpired() {
        log.debug((Object)"PurgeExpired database sessions started");
        long start = System.nanoTime();
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, session -> {
                UserSessionPersisterProvider provider = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
                if (provider == null) {
                    return;
                }
                session.realms().getRealmsStream().filter(this.realmFilter()).forEach(arg_0 -> ((UserSessionPersisterProvider)provider).removeExpired(arg_0));
            });
        }
        catch (Throwable t) {
            BaseExpirationTask.logUnexpectedErrorDuringDeletion(t);
        }
        finally {
            long duration = System.nanoTime() - start;
            this.onTaskExecuted.accept(Duration.of(duration, ChronoUnit.NANOS));
            log.debugf("PurgeExpired tasks completed in %s seconds", TimeUnit.NANOSECONDS.toSeconds(duration));
        }
    }

    abstract Predicate<RealmModel> realmFilter();

    private void scheduleNextTask() {
        PurgeExpiredTask newTask;
        PurgeExpiredTask existingTask = this.currentTask.get();
        if (this.currentTask.compareAndSet(existingTask, newTask = this.createAndSchedule())) {
            newTask.taskFuture().thenRun(this::scheduleNextTask);
            return;
        }
        newTask.scheduledFuture().cancel(true);
    }

    private PurgeExpiredTask createAndSchedule() {
        CompletableFuture<Void> taskFuture = new CompletableFuture<Void>();
        ScheduledFuture<?> scheduleFuture = this.scheduledExecutorService.schedule(() -> this.runAndComplete(taskFuture), (long)this.delaySeconds, TimeUnit.SECONDS);
        return new PurgeExpiredTask(scheduleFuture, taskFuture);
    }

    private void runAndComplete(CompletableFuture<Void> toComplete) {
        ((CompletableFuture)CompletableFuture.runAsync(this::purgeExpired, this.executorService).exceptionally(throwable -> {
            BaseExpirationTask.logUnexpectedErrorDuringDeletion(throwable);
            return null;
        })).thenApply(toComplete::complete);
    }

    private static void logUnexpectedErrorDuringDeletion(Throwable throwable) {
        log.error((Object)"Unexpected error while removing expired entries from database", throwable);
    }

    private record PurgeExpiredTask(ScheduledFuture<?> scheduledFuture, CompletionStage<Void> taskFuture) {
    }
}

