/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.admin.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;

@Extension(name="x-smallrye-profile-admin", value="")
public class OrganizationIdentityProvidersResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final OrganizationProvider organizationProvider;
    private final OrganizationModel organization;

    public OrganizationIdentityProvidersResource(KeycloakSession session, OrganizationModel organization, AdminEventBuilder adminEvent) {
        this.realm = session == null ? null : session.getContext().getRealm();
        this.session = session;
        this.organizationProvider = session == null ? null : (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        this.organization = organization;
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Adds the identity provider with the specified id to the organization", description="Adds, or associates, an existing identity provider with the organization. If no identity provider is found, or if it is already associated with the organization, an error response is returned")
    @RequestBody(description="Payload should contain only id or alias of the identity provider to be associated with the organization (id or alias with or without quotes). Surrounding whitespace characters will be trimmed.", required=true)
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="409", description="Conflict")})
    public Response addIdentityProvider(String id) {
        id = id.trim().replaceAll("^\"|\"$", "");
        try {
            IdentityProviderModel identityProvider = this.session.identityProviders().getByIdOrAlias(id);
            if (identityProvider == null) {
                throw ErrorResponse.error("Identity provider not found with the given alias", Response.Status.BAD_REQUEST);
            }
            if (this.organizationProvider.addIdentityProvider(this.organization, identityProvider)) {
                return Response.noContent().build();
            }
            throw ErrorResponse.error("Identity provider already associated to the organization", Response.Status.CONFLICT);
        }
        catch (ModelException me) {
            throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns all identity providers associated with the organization")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=IdentityProviderRepresentation.class, type=SchemaType.ARRAY))})})
    public Stream<IdentityProviderRepresentation> getIdentityProviders() {
        return this.organization.getIdentityProviders().map(this::toRepresentation);
    }

    @Path(value="{alias}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns the identity provider associated with the organization that has the specified alias", description="Searches for an identity provider with the given alias. If one is found and is associated with the organization, it is returned. Otherwise, an error response with status NOT_FOUND is returned")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=IdentityProviderRepresentation.class))}), @APIResponse(responseCode="404", description="Not Found")})
    public IdentityProviderRepresentation getIdentityProvider(@PathParam(value="alias") String alias) {
        IdentityProviderModel broker = this.session.identityProviders().getByAlias(alias);
        if (!this.isOrganizationBroker(broker)) {
            throw ErrorResponse.error("Identity provider not associated with the organization", Response.Status.NOT_FOUND);
        }
        return this.toRepresentation(broker);
    }

    @Path(value="{alias}")
    @DELETE
    @Produces(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Removes the identity provider with the specified alias from the organization", description="Breaks the association between the identity provider and the organization. The provider itself is not deleted. If no provider is found, or if it is not currently associated with the org, an error response is returned")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="404", description="Not Found")})
    public Response delete(@PathParam(value="alias") String alias) {
        IdentityProviderModel broker = this.session.identityProviders().getByAlias(alias);
        if (!this.isOrganizationBroker(broker)) {
            throw ErrorResponse.error("Identity provider not found with the given alias", Response.Status.NOT_FOUND);
        }
        if (this.organizationProvider.removeIdentityProvider(this.organization, broker)) {
            return Response.noContent().build();
        }
        throw ErrorResponse.error("Identity provider not associated with the organization", Response.Status.BAD_REQUEST);
    }

    private IdentityProviderRepresentation toRepresentation(IdentityProviderModel idp) {
        return (IdentityProviderRepresentation)StripSecretsUtils.stripSecrets((KeycloakSession)this.session, (Object)ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (IdentityProviderModel)idp));
    }

    private boolean isOrganizationBroker(IdentityProviderModel broker) {
        return broker != null && this.organization.getId().equals(broker.getOrganizationId());
    }
}

