/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.JpaWorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStateProviderFactory;

public class JpaWorkflowStateProviderFactory
implements WorkflowStateProviderFactory {
    public static final String PROVIDER_ID = "jpa";

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(fired -> {
            UserModel.UserRemovedEvent event;
            if (fired instanceof UserModel.UserRemovedEvent) {
                event = (UserModel.UserRemovedEvent)fired;
                this.onUserRemovedEvent(event);
            }
            if (fired instanceof RealmModel.RealmRemovedEvent) {
                event = (RealmModel.RealmRemovedEvent)fired;
                this.onRealmRemovedEvent((RealmModel.RealmRemovedEvent)event);
            }
        });
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public WorkflowStateProvider create(KeycloakSession session) {
        return new JpaWorkflowStateProvider(session);
    }

    public void close() {
    }

    private void onRealmRemovedEvent(RealmModel.RealmRemovedEvent event) {
        KeycloakSession session = event.getKeycloakSession();
        WorkflowStateProvider provider = (WorkflowStateProvider)session.getProvider(WorkflowStateProvider.class);
        provider.removeAll();
    }

    private void onUserRemovedEvent(UserModel.UserRemovedEvent event) {
        KeycloakSession session = event.getKeycloakSession();
        WorkflowStateProvider provider = (WorkflowStateProvider)session.getProvider(WorkflowStateProvider.class);
        provider.removeByResource(event.getUser().getId());
    }
}

