/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.SdJwtCredentialBody;
import org.keycloak.protocol.oid4vc.issuance.signing.AbstractCredentialSigner;
import org.keycloak.protocol.oid4vc.issuance.signing.CredentialSignerException;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;

public class SdJwtCredentialSigner
extends AbstractCredentialSigner<String> {
    private static final Logger LOGGER = Logger.getLogger(SdJwtCredentialSigner.class);

    public SdJwtCredentialSigner(KeycloakSession keycloakSession) {
        super(keycloakSession);
    }

    @Override
    public String signCredential(CredentialBody credentialBody, CredentialBuildConfig credentialBuildConfig) throws CredentialSignerException {
        if (!(credentialBody instanceof SdJwtCredentialBody)) {
            throw new CredentialSignerException("Credential body unexpectedly not of type SdJwtCredentialBody");
        }
        SdJwtCredentialBody sdJwtCredentialBody = (SdJwtCredentialBody)credentialBody;
        LOGGER.debugf("Sign credentials to sd-jwt format.", new Object[0]);
        return sdJwtCredentialBody.sign(this.getSigner(credentialBuildConfig));
    }
}

