/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;

public final class IoUtils {
    public static void safeClose(Closeable ... resources) {
        for (Closeable resource : resources) {
            IoUtils.safeClose(resource);
        }
    }

    public static void safeClose(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException t) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(t);
        }
        catch (Exception t) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(t));
        }
    }
}

