/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.GroupVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ShareVersion;
import org.apache.kafka.server.common.StreamsVersion;
import org.apache.kafka.server.common.TestFeatureVersion;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.common.UnitTestFeatureVersion;

public enum Feature {
    KRAFT_VERSION("kraft.version", KRaftVersion.values(), KRaftVersion.LATEST_PRODUCTION),
    TRANSACTION_VERSION("transaction.version", TransactionVersion.values(), TransactionVersion.LATEST_PRODUCTION),
    GROUP_VERSION("group.version", GroupVersion.values(), GroupVersion.LATEST_PRODUCTION),
    ELIGIBLE_LEADER_REPLICAS_VERSION("eligible.leader.replicas.version", EligibleLeaderReplicasVersion.values(), EligibleLeaderReplicasVersion.LATEST_PRODUCTION),
    SHARE_VERSION("share.version", ShareVersion.values(), ShareVersion.LATEST_PRODUCTION),
    STREAMS_VERSION("streams.version", StreamsVersion.values(), StreamsVersion.LATEST_PRODUCTION),
    TEST_VERSION("test.feature.version", TestFeatureVersion.values(), TestFeatureVersion.LATEST_PRODUCTION),
    UNIT_TEST_VERSION_0("unit.test.feature.version.0", new FeatureVersion[]{UnitTestFeatureVersion.FV0.UT_FV0_0}, UnitTestFeatureVersion.FV0.LATEST_PRODUCTION),
    UNIT_TEST_VERSION_1("unit.test.feature.version.1", UnitTestFeatureVersion.FV1.values(), UnitTestFeatureVersion.FV1.LATEST_PRODUCTION),
    UNIT_TEST_VERSION_2("unit.test.feature.version.2", UnitTestFeatureVersion.FV2.values(), UnitTestFeatureVersion.FV2.LATEST_PRODUCTION),
    UNIT_TEST_VERSION_3("unit.test.feature.version.3", UnitTestFeatureVersion.FV3.values(), UnitTestFeatureVersion.FV3.LATEST_PRODUCTION),
    UNIT_TEST_VERSION_4("unit.test.feature.version.4", UnitTestFeatureVersion.FV4.values(), UnitTestFeatureVersion.FV4.LATEST_PRODUCTION),
    UNIT_TEST_VERSION_5("unit.test.feature.version.5", UnitTestFeatureVersion.FV5.values(), UnitTestFeatureVersion.FV5.LATEST_PRODUCTION),
    UNIT_TEST_VERSION_6("unit.test.feature.version.6", UnitTestFeatureVersion.FV6.values(), UnitTestFeatureVersion.FV6.LATEST_PRODUCTION),
    UNIT_TEST_VERSION_7("unit.test.feature.version.7", UnitTestFeatureVersion.FV7.values(), UnitTestFeatureVersion.FV7.LATEST_PRODUCTION);

    public static final Feature[] FEATURES;
    public static final List<Feature> TEST_AND_PRODUCTION_FEATURES;
    public static final List<Feature> PRODUCTION_FEATURES;
    public static final List<String> PRODUCTION_FEATURE_NAMES;
    private final String name;
    private final FeatureVersion[] featureVersions;
    public final FeatureVersion latestProduction;

    private Feature(String name, FeatureVersion[] featureVersions, FeatureVersion latestProduction) {
        this.name = name;
        this.featureVersions = featureVersions;
        this.latestProduction = latestProduction;
    }

    public String featureName() {
        return this.name;
    }

    public FeatureVersion[] featureVersions() {
        return this.featureVersions;
    }

    public short latestProduction() {
        return this.latestProduction.featureLevel();
    }

    public short minimumProduction() {
        return this.featureVersions[0].featureLevel();
    }

    public short latestTesting() {
        return this.featureVersions[this.featureVersions.length - 1].featureLevel();
    }

    public SupportedVersionRange supportedVersionRange() {
        return new SupportedVersionRange(this.minimumProduction(), this.latestTesting());
    }

    public FeatureVersion fromFeatureLevel(short level, boolean allowUnstableFeatureVersions) {
        return Arrays.stream(this.featureVersions).filter(featureVersion -> featureVersion.featureLevel() == level && (allowUnstableFeatureVersions || level <= this.latestProduction())).findFirst().orElseThrow(() -> new IllegalArgumentException("No feature:" + this.featureName() + " with feature level " + level));
    }

    public static void validateVersion(FeatureVersion feature, Map<String, Short> features) {
        Short metadataVersion = features.get("metadata.version");
        if (feature.featureLevel() >= 1 && (metadataVersion == null || metadataVersion < MetadataVersion.MINIMUM_VERSION.featureLevel())) {
            throw new IllegalArgumentException(feature.featureName() + " could not be set to " + feature.featureLevel() + " because it depends on metadata.version=" + MetadataVersion.MINIMUM_VERSION.featureLevel() + " (" + String.valueOf((Object)MetadataVersion.MINIMUM_VERSION) + ")");
        }
        for (Map.Entry<String, Short> dependency : feature.dependencies().entrySet()) {
            Short featureLevel = features.get(dependency.getKey());
            if (featureLevel != null && featureLevel >= dependency.getValue()) continue;
            throw new IllegalArgumentException(feature.featureName() + " could not be set to " + feature.featureLevel() + " because it depends on " + dependency.getKey() + " level " + String.valueOf(dependency.getValue()));
        }
    }

    public FeatureVersion defaultVersion(MetadataVersion metadataVersion) {
        FeatureVersion version = this.featureVersions[0];
        Iterator it = Arrays.stream(this.featureVersions).iterator();
        while (it.hasNext()) {
            FeatureVersion feature = (FeatureVersion)it.next();
            if (feature.bootstrapMetadataVersion().isLessThan(metadataVersion) || feature.bootstrapMetadataVersion().equals((Object)metadataVersion)) {
                version = feature;
                continue;
            }
            return version;
        }
        return version;
    }

    public short defaultLevel(MetadataVersion metadataVersion) {
        return this.defaultVersion(metadataVersion).featureLevel();
    }

    public static Feature featureFromName(String featureName) {
        for (Feature feature : FEATURES) {
            if (!feature.name.equals(featureName)) continue;
            return feature;
        }
        throw new IllegalArgumentException("Feature " + featureName + " not found.");
    }

    public boolean isProductionReady(short featureVersion) {
        return featureVersion <= this.latestProduction();
    }

    public boolean hasFeatureVersion(FeatureVersion featureVersion) {
        for (FeatureVersion v : this.featureVersions()) {
            if (v != featureVersion) continue;
            return true;
        }
        return false;
    }

    public static void validateDefaultValueAndLatestProductionValue(Feature feature) throws IllegalArgumentException {
        FeatureVersion defaultVersion = feature.defaultVersion(MetadataVersion.LATEST_PRODUCTION);
        FeatureVersion latestProduction = feature.latestProduction;
        if (!feature.hasFeatureVersion(latestProduction)) {
            throw new IllegalArgumentException(String.format("Feature %s has latest production version %s which is not one of its feature versions.", feature.name(), latestProduction));
        }
        if (latestProduction.featureLevel() < defaultVersion.featureLevel()) {
            throw new IllegalArgumentException(String.format("Feature %s has latest production value %s smaller than its default version %s with latest production MV.", feature.name(), latestProduction, defaultVersion));
        }
        for (Map.Entry<String, Short> dependency : latestProduction.dependencies().entrySet()) {
            String dependencyFeatureName = dependency.getKey();
            if (!dependencyFeatureName.equals("metadata.version")) {
                Feature dependencyFeature = Feature.featureFromName(dependencyFeatureName);
                if (dependencyFeature.isProductionReady(dependency.getValue())) continue;
                throw new IllegalArgumentException(String.format("Feature %s has latest production FeatureVersion %s with dependency %s that is not production ready. (%s latest production: %s)", new Object[]{feature.name(), latestProduction, dependencyFeature.fromFeatureLevel(dependency.getValue(), true), dependencyFeature, dependencyFeature.latestProduction}));
            }
            if (dependency.getValue() <= MetadataVersion.LATEST_PRODUCTION.featureLevel()) continue;
            throw new IllegalArgumentException(String.format("Feature %s has latest production FeatureVersion %s with MV dependency %s that is not production ready. (MV latest production: %s)", new Object[]{feature.name(), latestProduction, MetadataVersion.fromFeatureLevel(dependency.getValue()), MetadataVersion.LATEST_PRODUCTION}));
        }
        for (MetadataVersion metadataVersion : MetadataVersion.values()) {
            defaultVersion = feature.defaultVersion(metadataVersion);
            for (Map.Entry<String, Short> dependency : defaultVersion.dependencies().entrySet()) {
                String dependencyFeatureName = dependency.getKey();
                if (!dependencyFeatureName.equals("metadata.version")) {
                    Feature dependencyFeature = Feature.featureFromName(dependencyFeatureName);
                    if (dependency.getValue() <= dependencyFeature.defaultLevel(metadataVersion)) continue;
                    throw new IllegalArgumentException(String.format("Feature %s has default FeatureVersion %s when MV=%s with dependency %s that is behind its default version %s.", new Object[]{feature.name(), defaultVersion, metadataVersion, dependencyFeature.fromFeatureLevel(dependency.getValue(), true), dependencyFeature.defaultVersion(metadataVersion)}));
                }
                if (dependency.getValue() <= defaultVersion.bootstrapMetadataVersion().featureLevel()) continue;
                throw new IllegalArgumentException(String.format("Feature %s has default FeatureVersion %s when MV=%s with MV dependency %s that is behind its bootstrap MV %s.", new Object[]{feature.name(), defaultVersion, metadataVersion, MetadataVersion.fromFeatureLevel(dependency.getValue()), defaultVersion.bootstrapMetadataVersion()}));
            }
        }
    }

    static {
        Feature[] enumValues = Feature.values();
        FEATURES = Arrays.copyOf(enumValues, enumValues.length);
        TEST_AND_PRODUCTION_FEATURES = Arrays.stream(FEATURES).filter(feature -> !feature.name.startsWith("unit.test.feature.version")).toList();
        PRODUCTION_FEATURES = Arrays.stream(FEATURES).filter(feature -> !feature.name.equals(TEST_VERSION.featureName()) && !feature.name.startsWith("unit.test.feature.version")).toList();
        PRODUCTION_FEATURE_NAMES = PRODUCTION_FEATURES.stream().map(feature -> feature.name).toList();
        Feature.validateDefaultValueAndLatestProductionValue(TEST_VERSION);
        for (Feature feature2 : PRODUCTION_FEATURES) {
            Feature.validateDefaultValueAndLatestProductionValue(feature2);
        }
    }
}

