/*
 * Decompiled with CFR 0.152.
 */
package naga.packetreader;

import java.nio.ByteBuffer;
import naga.NIOUtils;
import naga.PacketReader;
import naga.exception.ProtocolViolationException;

public class RegularPacketReader
implements PacketReader {
    private final boolean m_bigEndian;
    private final int m_headerSize;

    public RegularPacketReader(int n, boolean bl) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Header must be between 1 and 4 bytes long.");
        }
        this.m_bigEndian = bl;
        this.m_headerSize = n;
    }

    @Override
    public byte[] nextPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        if (byteBuffer.remaining() < this.m_headerSize) {
            return null;
        }
        byteBuffer.mark();
        int n = NIOUtils.getPacketSizeFromByteBuffer(byteBuffer, this.m_headerSize, this.m_bigEndian);
        if (byteBuffer.remaining() >= n) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return byArray;
        }
        byteBuffer.reset();
        return null;
    }
}

