/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Threshold an image using multiple Otsu Thresholds.


This filter creates a labeled image that separates the input image
into various classes. The filter computes the thresholds using the OtsuMultipleThresholdsCalculator and applies those thresholds to the input image using the ThresholdLabelerImageFilter . The NumberOfHistogramBins and NumberOfThresholds can be set for the
Calculator. The LabelOffset can be set for the ThresholdLabelerImageFilter .

This filter also includes an option to use the valley emphasis
algorithm from H.F. Ng, "Automatic thresholding for defect
detection", Pattern Recognition Letters, (27): 1644-1649, 2006. The
valley emphasis algorithm is particularly effective when the object to
be thresholded is small. See the following tests for examples:
itkOtsuMultipleThresholdsImageFilterTest3 and
itkOtsuMultipleThresholdsImageFilterTest4 To use this algorithm,
simple call the setter: SetValleyEmphasis(true) It is turned off by
default.


See:
 ScalarImageToHistogramGenerator

 OtsuMultipleThresholdsCalculator

 ThresholdLabelerImageFilter

 itk::simple::OtsuMultipleThresholds for the procedural interface

 itk::OtsuMultipleThresholdsImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkOtsuMultipleThresholdsImageFilter.h
*/
public class OtsuMultipleThresholdsImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected OtsuMultipleThresholdsImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.OtsuMultipleThresholdsImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(OtsuMultipleThresholdsImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(OtsuMultipleThresholdsImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::OtsuMultipleThresholdsImageFilter::~OtsuMultipleThresholdsImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_OtsuMultipleThresholdsImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::OtsuMultipleThresholdsImageFilter::OtsuMultipleThresholdsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  OtsuMultipleThresholdsImageFilter() {
    this(SimpleITKJNI.new_OtsuMultipleThresholdsImageFilter(), true);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::SetNumberOfThresholds(uint8_t NumberOfThresholds)

Set/Get the number of thresholds. Default is 1.

*/
public  void setNumberOfThresholds(short NumberOfThresholds) {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_setNumberOfThresholds(swigCPtr, this, NumberOfThresholds);
  }

  /**
uint8_t itk::simple::OtsuMultipleThresholdsImageFilter::GetNumberOfThresholds() const

Set/Get the number of thresholds. Default is 1.

*/
public  short getNumberOfThresholds() {
    return SimpleITKJNI.OtsuMultipleThresholdsImageFilter_getNumberOfThresholds(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::SetLabelOffset(uint8_t LabelOffset)

Set/Get the offset which labels have to start from. Default is 0.

*/
public  void setLabelOffset(short LabelOffset) {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_setLabelOffset(swigCPtr, this, LabelOffset);
  }

  /**
uint8_t itk::simple::OtsuMultipleThresholdsImageFilter::GetLabelOffset() const

Set/Get the offset which labels have to start from. Default is 0.

*/
public  short getLabelOffset() {
    return SimpleITKJNI.OtsuMultipleThresholdsImageFilter_getLabelOffset(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins. Default is 128.

*/
public  void setNumberOfHistogramBins(long NumberOfHistogramBins) {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_setNumberOfHistogramBins(swigCPtr, this, NumberOfHistogramBins);
  }

  /**
uint32_t itk::simple::OtsuMultipleThresholdsImageFilter::GetNumberOfHistogramBins() const

Set/Get the number of histogram bins. Default is 128.

*/
public  long getNumberOfHistogramBins() {
    return SimpleITKJNI.OtsuMultipleThresholdsImageFilter_getNumberOfHistogramBins(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::SetValleyEmphasis(bool ValleyEmphasis)

Set/Get the use of valley emphasis. Default is false.

*/
public  void setValleyEmphasis(boolean ValleyEmphasis) {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_setValleyEmphasis(swigCPtr, this, ValleyEmphasis);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::ValleyEmphasisOn()

Set the value of ValleyEmphasis to true or false respectfully.

*/
public  void valleyEmphasisOn() {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_valleyEmphasisOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::ValleyEmphasisOff()
*/
public  void valleyEmphasisOff() {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_valleyEmphasisOff(swigCPtr, this);
  }

  /**
bool itk::simple::OtsuMultipleThresholdsImageFilter::GetValleyEmphasis() const

Set/Get the use of valley emphasis. Default is false.

*/
public  boolean getValleyEmphasis() {
    return SimpleITKJNI.OtsuMultipleThresholdsImageFilter_getValleyEmphasis(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::SetReturnBinMidpoint(bool ReturnBinMidpoint)

Should the threshold value be mid-point of the bin or the maximum?
Default is to return bin maximum.

*/
public  void setReturnBinMidpoint(boolean ReturnBinMidpoint) {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_setReturnBinMidpoint(swigCPtr, this, ReturnBinMidpoint);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::ReturnBinMidpointOn()

Set the value of ReturnBinMidpoint to true or false respectfully.

*/
public  void returnBinMidpointOn() {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_returnBinMidpointOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuMultipleThresholdsImageFilter::ReturnBinMidpointOff()
*/
public  void returnBinMidpointOff() {
    SimpleITKJNI.OtsuMultipleThresholdsImageFilter_returnBinMidpointOff(swigCPtr, this);
  }

  /**
bool itk::simple::OtsuMultipleThresholdsImageFilter::GetReturnBinMidpoint() const

Should the threshold value be mid-point of the bin or the maximum?
Default is to return bin maximum.

*/
public  boolean getReturnBinMidpoint() {
    return SimpleITKJNI.OtsuMultipleThresholdsImageFilter_getReturnBinMidpoint(swigCPtr, this);
  }

  /**
std::vector&lt;double&gt; itk::simple::OtsuMultipleThresholdsImageFilter::GetThresholds() const

Get the computed threshold.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorDouble getThresholds() {
    return new VectorDouble(SimpleITKJNI.OtsuMultipleThresholdsImageFilter_getThresholds(swigCPtr, this), true);
  }

  /**
std::string itk::simple::OtsuMultipleThresholdsImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.OtsuMultipleThresholdsImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::OtsuMultipleThresholdsImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.OtsuMultipleThresholdsImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::OtsuMultipleThresholdsImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.OtsuMultipleThresholdsImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
