/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.editor;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.editor.MavenModelVersionSynchronizerService;
import org.jetbrains.idea.maven.editor.MavenModelVersionSyncronizerImplKt;
import org.jetbrains.idea.maven.editor.SynchronizationData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0007\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001DB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010&\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010'\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u001c\u0010+\u001a\u0004\u0018\u00010\u001a2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010.\u001a\u0004\u0018\u00010\u001a2\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010!\u001a\u00020\"H\u0002J\"\u00101\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001c2\b\u00102\u001a\u0004\u0018\u00010-2\u0006\u0010!\u001a\u00020\"H\u0002J$\u00103\u001a\u0004\u0018\u0001042\u0006\u00102\u001a\u00020-2\u0006\u00105\u001a\u0002062\b\b\u0002\u00107\u001a\u000206H\u0002J%\u00108\u001a\u00020$2\u000b\u00109\u001a\u000706\u00a2\u0006\u0002\b:2\u0006\u0010;\u001a\u00020$2\u0006\u00107\u001a\u000206H\u0002J\u0010\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020>H\u0002J \u0010?\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010@\u001a\u00020$H\u0002J\u000e\u0010A\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010B\u001a\u00020\u000fJ\u001a\u0010C\u001a\u0004\u0018\u0001062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/idea/maven/editor/MavenModelVersionSyncronizerImpl;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/editor/event/CaretListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/project/Project;)V", "applying", "", "pdm", "Lcom/intellij/psi/impl/PsiDocumentManagerBase;", "listenForDocumentChanges", "", "dispose", "caretRemoved", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "beforeDocumentChange", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "setMarkers", "caret", "Lcom/intellij/openapi/editor/Caret;", "leader", "Lorg/jetbrains/idea/maven/editor/SynchronizationData;", "followers", "", "getMarkers", "createLeaderMarker", "psiFile", "Lcom/intellij/psi/xml/XmlFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "clearMarkers", "findSupports", "same", "Lcom/intellij/psi/PsiElement;", "supporter", "Lcom/intellij/psi/xml/XmlElement;", "fromXmlns", "xmlnsElement", "Lcom/intellij/psi/xml/XmlAttributeValue;", "fromModel", "modelElement", "Lcom/intellij/psi/xml/XmlText;", "fromSchema", "schemaElement", "findRangeAfter", "Lcom/intellij/openapi/util/TextRange;", "prefix", "", "end", "getEndIndex", "value", "Lcom/intellij/openapi/util/NlsSafe;", "startIndex", "isValidModelSymbols", "ch", "", "fitsInLeader", "oldLength", "performReplacement", "beforeCommandFinished", "getValueToReplace", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenModelVersionSyncronizerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenModelVersionSyncronizerImpl.kt\norg/jetbrains/idea/maven/editor/MavenModelVersionSyncronizerImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n4225#2,11:298\n4225#2,11:309\n1#3:320\n1869#4,2:321\n774#4:323\n865#4,2:324\n827#4:326\n855#4,2:327\n1563#4:329\n1634#4,3:330\n1563#4:333\n1634#4,3:334\n1761#4,3:337\n1869#4,2:340\n*S KotlinDebug\n*F\n+ 1 MavenModelVersionSyncronizerImpl.kt\norg/jetbrains/idea/maven/editor/MavenModelVersionSyncronizerImpl\n*L\n137#1:298,11\n156#1:309,11\n163#1:321,2\n164#1:323\n164#1:324,2\n164#1:326\n164#1:327,2\n221#1:329\n221#1:330,3\n223#1:333\n223#1:334,3\n241#1:337,3\n245#1:340,2\n*E\n"})
public final class MavenModelVersionSyncronizerImpl
implements DocumentListener,
Disposable,
CaretListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Project project;
    private boolean applying;
    @NotNull
    private final PsiDocumentManagerBase pdm;
    @NotNull
    private static final Key<List<SynchronizationData>> MARKERS_KEY = new Key("maven.version.synchronizer.markers");

    public MavenModelVersionSyncronizerImpl(@NotNull EditorImpl editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.editor = editor;
        this.project = project;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)psiDocumentManager, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiDocumentManagerBase");
        this.pdm = (PsiDocumentManagerBase)psiDocumentManager;
    }

    public final void listenForDocumentChanges() {
        Disposer.register((Disposable)this.editor.getDisposable(), (Disposable)this);
        this.editor.getDocument().addDocumentListener((DocumentListener)this, (Disposable)this);
        MavenModelVersionSyncronizerImpl prev = (MavenModelVersionSyncronizerImpl)this.editor.getUserData(MavenModelVersionSynchronizerService.SYNCHRONIZER_KEY);
        if (prev != null && prev != this) {
            Disposer.dispose((Disposable)prev);
        }
        this.editor.putUserData(MavenModelVersionSynchronizerService.SYNCHRONIZER_KEY, (Object)this);
    }

    public void dispose() {
        this.editor.putUserData(MavenModelVersionSynchronizerService.SYNCHRONIZER_KEY, null);
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Caret caret = event.getCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCaret(...)");
        Caret caret2 = caret;
        this.clearMarkers(caret2);
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        PsiFile it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Project ideProject = this.project;
        if (this.applying || ideProject.isDefault() || UndoManager.getInstance((Project)ideProject).isUndoInProgress() || document2.isInBulkUpdate()) {
            return;
        }
        if (Intrinsics.areEqual((Object)document2.getUserData(MavenModelVersionSynchronizerService.SKIP_COMMAND_KEY), (Object)true)) {
            return;
        }
        int offset = event.getOffset();
        int oldLen = event.getOldLength();
        CharSequence charSequence = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
        CharSequence fragment = charSequence;
        int newLen = event.getNewLength();
        CaretImpl caretImpl = this.editor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caretImpl, (String)"getCurrentCaret(...)");
        CaretImpl caret = caretImpl;
        PsiFile markers = null;
        PsiFile psiFile = markers = this.getMarkers((Caret)caret);
        if (psiFile != null) {
            it = psiFile;
            boolean bl = false;
            if (!this.fitsInLeader((SynchronizationData)CollectionsKt.first(it), offset, oldLen)) {
                markers = null;
                this.clearMarkers((Caret)caret);
            }
        }
        for (int i2 = 0; i2 < newLen; ++i2) {
            if (this.isValidModelSymbols(fragment.charAt(i2))) continue;
            return;
        }
        if (markers == null) {
            if (this.pdm.getSynchronizer().isInSynchronization(document2)) {
                return;
            }
            it = this.pdm.getPsiFile(document2);
            XmlFile xmlFile = it instanceof XmlFile ? (XmlFile)it : null;
            if (xmlFile == null) {
                return;
            }
            XmlFile psiFile2 = xmlFile;
            SynchronizationData synchronizationData = this.createLeaderMarker(psiFile2, document2, this.editor.getCaretModel().getOffset());
            if (synchronizationData == null) {
                return;
            }
            SynchronizationData leader = synchronizationData;
            if (!this.fitsInLeader(leader, offset, oldLen)) {
                return;
            }
            leader.getRangeMarker().setGreedyToLeft(true);
            leader.getRangeMarker().setGreedyToRight(true);
            if (this.pdm.isUncommited(document2)) {
                this.pdm.commitDocument(document2);
            }
            List<SynchronizationData> list = this.findSupports(leader, psiFile2, document2);
            if (list == null) {
                return;
            }
            List<SynchronizationData> supports = list;
            this.setMarkers((Caret)caret, leader, supports);
        }
    }

    private final void setMarkers(Caret caret, SynchronizationData leader, List<SynchronizationData> followers) {
        if (followers == null) {
            this.clearMarkers(caret);
        } else {
            caret.putUserData(MARKERS_KEY, (Object)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)leader), (Iterable)followers));
        }
    }

    private final List<SynchronizationData> getMarkers(Caret caret) {
        return (List)caret.getUserData(MARKERS_KEY);
    }

    /*
     * WARNING - void declaration
     */
    private final SynchronizationData createLeaderMarker(XmlFile psiFile, Document document, int offset) {
        XmlAttributeValue xmlAttributeValue;
        TextRange modelElement;
        PsiElement[] projectElement;
        PsiElement[] psiElementArray = projectElement = psiFile.getRootTag();
        XmlAttributeValue xmlnsElement = projectElement != null && (psiElementArray = psiElementArray.getAttribute("xmlns")) != null ? psiElementArray.getValueElement() : null;
        PsiElement[] psiElementArray2 = projectElement;
        if (projectElement != null && (psiElementArray2 = psiElementArray2.findSubTags("modelVersion")) != null && (psiElementArray2 = (PsiElement[])ArraysKt.firstOrNull((Object[])psiElementArray2)) != null && (psiElementArray2 = psiElementArray2.getChildren()) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            PsiElement[] $this$filterIsInstance$iv = psiElementArray2;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] psiElementArray3 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof XmlText)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v2 = (XmlText)CollectionsKt.first((List)((List)destination$iv$iv));
        } else {
            v2 = modelElement = null;
        }
        boolean bl = (xmlAttributeValue = xmlnsElement) != null && (xmlAttributeValue = xmlAttributeValue.getTextRange()) != null ? xmlAttributeValue.contains(offset) : false;
        if (bl) {
            return this.fromXmlns(xmlnsElement, document);
        }
        TextRange textRange = modelElement;
        boolean bl2 = textRange != null && (textRange = textRange.getTextRange()) != null ? textRange.contains(offset) : false;
        if (bl2) {
            return this.fromModel((XmlText)modelElement, document);
        }
        return null;
    }

    private final void clearMarkers(Caret caret) {
        caret.putUserData(MARKERS_KEY, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SynchronizationData> findSupports(SynchronizationData leader, XmlFile psiFile, Document document) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterTo$iv$iv;
        Object it;
        XmlText modelElement;
        PsiElement[] projectElement;
        TextRange textRange = leader.getRangeMarker().getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange leaderRange = textRange;
        PsiElement psiElement = psiFile.getViewProvider().findElementAt(leader.getRangeMarker().getStartOffset(), (Language)XMLLanguage.INSTANCE);
        if (psiElement == null) {
            return null;
        }
        PsiElement leaderElement = psiElement;
        PsiElement[] psiElementArray = projectElement = psiFile.getRootTag();
        XmlAttributeValue xmlnsElement = projectElement != null && (psiElementArray = psiElementArray.getAttribute("xmlns")) != null ? psiElementArray.getValueElement() : null;
        PsiElement[] psiElementArray2 = projectElement;
        XmlAttributeValue schemaElement = projectElement != null && (psiElementArray2 = psiElementArray2.getAttribute("xsi:schemaLocation")) != null ? psiElementArray2.getValueElement() : null;
        PsiElement[] psiElementArray3 = projectElement;
        if (projectElement != null && (psiElementArray3 = psiElementArray3.findSubTags("modelVersion")) != null && (psiElementArray3 = (PsiElement[])ArraysKt.firstOrNull((Object[])psiElementArray3)) != null && (psiElementArray3 = psiElementArray3.getChildren()) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            PsiElement[] $this$filterIsInstance$iv = psiElementArray3;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] psiElementArray4 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof XmlText)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v5 = (XmlText)CollectionsKt.first((List)((List)destination$iv$iv));
        } else {
            v5 = modelElement = null;
        }
        if (!(this.same(leaderElement, (XmlElement)xmlnsElement) || this.same(leaderElement, (XmlElement)schemaElement) || this.same(leaderElement, (XmlElement)modelElement))) {
            return null;
        }
        ArrayList result2 = new ArrayList();
        UtilKt.addIfNotNull((List)result2, (Object)this.fromXmlns(xmlnsElement, document));
        List<SynchronizationData> list = this.fromSchema(schemaElement, document);
        if (list != null) {
            it = list;
            boolean bl = false;
            result2.addAll((Collection)it);
        }
        UtilKt.addIfNotNull((List)result2, (Object)this.fromModel(modelElement, document));
        Iterable $this$forEach$iv = result2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SynchronizationData it2 = (SynchronizationData)element$iv;
            boolean bl = false;
            it2.getRangeMarker().setGreedyToLeft(true);
            it2.getRangeMarker().setGreedyToRight(true);
        }
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SynchronizationData it3 = (SynchronizationData)element$iv$iv;
            boolean bl = false;
            if (!it3.getRangeMarker().isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            SynchronizationData it4 = (SynchronizationData)element$iv$iv;
            boolean bl = false;
            if (it4.getRangeMarker().getTextRange().intersects(leaderRange)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return UtilKt.nullize((List)((List)destination$iv$iv));
    }

    private final boolean same(PsiElement leader, XmlElement supporter) {
        if (leader == null || supporter == null) {
            return false;
        }
        return leader == supporter || leader.getParent() == supporter;
    }

    private final SynchronizationData fromXmlns(XmlAttributeValue xmlnsElement, Document document) {
        SynchronizationData synchronizationData;
        TextRange pomRange;
        if (xmlnsElement == null) {
            return null;
        }
        TextRange textRange = pomRange = MavenModelVersionSyncronizerImpl.findRangeAfter$default(this, xmlnsElement, "maven.apache.org/POM/", null, 4, null);
        if (textRange != null) {
            TextRange it = textRange;
            boolean bl = false;
            RangeMarker rangeMarker = document.createRangeMarker(it);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
            synchronizationData = MavenModelVersionSyncronizerImplKt.access$synchronizedDots(rangeMarker);
        } else {
            synchronizationData = null;
        }
        return synchronizationData;
    }

    private final SynchronizationData fromModel(XmlText modelElement, Document document) {
        if (modelElement == null) {
            return null;
        }
        RangeMarker rangeMarker = document.createRangeMarker(modelElement.getTextRange());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        return MavenModelVersionSyncronizerImplKt.access$synchronizedDots(rangeMarker);
    }

    private final List<SynchronizationData> fromSchema(XmlAttributeValue schemaElement, Document document) {
        ArrayList<SynchronizationData> result2;
        block3: {
            TextRange xsdRangeUnderscores;
            TextRange xsdRange;
            TextRange pomRange;
            if (schemaElement == null) {
                return null;
            }
            result2 = new ArrayList<SynchronizationData>(2);
            TextRange textRange = pomRange = MavenModelVersionSyncronizerImpl.findRangeAfter$default(this, schemaElement, "maven.apache.org/POM/", null, 4, null);
            if (textRange != null) {
                TextRange it = textRange;
                boolean bl = false;
                RangeMarker rangeMarker = document.createRangeMarker(it);
                Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
                result2.add(MavenModelVersionSyncronizerImplKt.access$synchronizedDots(rangeMarker));
            }
            TextRange textRange2 = xsdRange = this.findRangeAfter(schemaElement, "maven.apache.org/xsd/maven-", ".xsd");
            if (textRange2 != null) {
                TextRange it = textRange2;
                boolean bl = false;
                RangeMarker rangeMarker = document.createRangeMarker(it);
                Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
                result2.add(MavenModelVersionSyncronizerImplKt.access$synchronizedDots(rangeMarker));
            }
            TextRange textRange3 = xsdRangeUnderscores = this.findRangeAfter(schemaElement, "maven.apache.org/maven-v", ".xsd");
            if (textRange3 == null) break block3;
            TextRange it = textRange3;
            boolean bl = false;
            RangeMarker rangeMarker = document.createRangeMarker(it);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
            result2.add(MavenModelVersionSyncronizerImplKt.access$synchronizedUnderscore(rangeMarker));
        }
        return UtilKt.nullize((List)result2);
    }

    private final TextRange findRangeAfter(XmlAttributeValue schemaElement, String prefix, String end) {
        String string = schemaElement.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String value = string;
        TextRange schemaTextRange = schemaElement.getValueTextRange();
        int foundIndex = StringsKt.indexOf$default((CharSequence)value, (String)prefix, (int)0, (boolean)false, (int)6, null);
        if (foundIndex != -1) {
            int end2;
            int endIdx = this.getEndIndex(value, foundIndex + prefix.length(), end);
            int start = schemaTextRange.getStartOffset() + foundIndex + prefix.length();
            if (start <= (end2 = schemaTextRange.getStartOffset() + endIdx)) {
                return new TextRange(start, end2);
            }
        }
        return null;
    }

    static /* synthetic */ TextRange findRangeAfter$default(MavenModelVersionSyncronizerImpl mavenModelVersionSyncronizerImpl, XmlAttributeValue xmlAttributeValue, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = " ";
        }
        return mavenModelVersionSyncronizerImpl.findRangeAfter(xmlAttributeValue, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final int getEndIndex(String value, int startIndex, String end) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object[] objectArray = new String[]{end, " ", "\n", "\r\n", "\t", ":", "file:", "http:", "https:", ":", "/"};
        List possibleSuffixes = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = possibleSuffixes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.indexOf((CharSequence)value, (String)it, (int)startIndex, (boolean)true));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it == -1 ? value.length() : it);
        }
        return ((Number)((Object)CollectionsKt.minOrThrow((Iterable)((List)destination$iv$iv)))).intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidModelSymbols(char ch) {
        if (Character.isLetterOrDigit(ch)) return true;
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('_')};
        if (!SetsKt.setOf((Object[])objectArray).contains(Character.valueOf(ch))) return false;
        return true;
    }

    private final boolean fitsInLeader(SynchronizationData leader, int offset, int oldLength) {
        return leader.getRangeMarker().isValid() && offset >= leader.getRangeMarker().getStartOffset() && offset + oldLength <= leader.getRangeMarker().getEndOffset();
    }

    public final void performReplacement(@NotNull Caret caret) {
        boolean bl;
        String name;
        Document document;
        List<SynchronizationData> markers;
        block5: {
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            List<SynchronizationData> list = this.getMarkers(caret);
            if (list == null) {
                return;
            }
            markers = list;
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            document = (Document)documentEx;
            SynchronizationData leader = (SynchronizationData)CollectionsKt.first(markers);
            name = this.getValueToReplace(document, leader);
            Iterable $this$any$iv = markers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SynchronizationData it = (SynchronizationData)element$iv;
                    boolean bl2 = false;
                    if (!(!it.getRangeMarker().isValid())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl || name == null) {
            return;
        }
        Runnable apply = () -> MavenModelVersionSyncronizerImpl.performReplacement$lambda$1(markers, document, name);
        ApplicationManager.getApplication().runWriteAction(() -> MavenModelVersionSyncronizerImpl.performReplacement$lambda$2(this, apply));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeCommandFinished() {
        this.applying = true;
        try {
            if (this.editor.getCaretModel().isIteratingOverCarets()) {
                CaretImpl caretImpl = this.editor.getCaretModel().getCurrentCaret();
                Intrinsics.checkNotNullExpressionValue((Object)caretImpl, (String)"getCurrentCaret(...)");
                this.performReplacement((Caret)caretImpl);
            } else {
                this.editor.getCaretModel().runForEachCaret(this::performReplacement);
            }
        }
        finally {
            this.applying = false;
        }
    }

    private final String getValueToReplace(Document document, SynchronizationData leader) {
        if (document.getTextLength() < leader.getRangeMarker().getEndOffset()) {
            return null;
        }
        return document.getText(leader.getRangeMarker().getTextRange());
    }

    private static final void performReplacement$lambda$1(List $markers, Document $document, String $name) {
        Iterable $this$forEach$iv = UtilKt.tail((List)$markers);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SynchronizationData it = (SynchronizationData)element$iv;
            boolean bl = false;
            $document.replaceString(it.getRangeMarker().getStartOffset(), it.getRangeMarker().getEndOffset(), (CharSequence)it.getTransformation().invoke((Object)$name));
        }
    }

    private static final void performReplacement$lambda$2(MavenModelVersionSyncronizerImpl this$0, Runnable $apply) {
        LookupImpl lookup;
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)((Editor)this$0.editor));
        LookupImpl lookupImpl = lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        if (lookup != null) {
            lookup.performGuardedChange($apply);
        } else {
            $apply.run();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/editor/MavenModelVersionSyncronizerImpl$Companion;", "", "<init>", "()V", "MARKERS_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lorg/jetbrains/idea/maven/editor/SynchronizationData;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

