/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.compose;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.awt.ComposePanel;
import androidx.compose.ui.semantics.CustomAccessibilityAction;
import androidx.compose.ui.semantics.SemanticsNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Pair;
import java.awt.Component;
import java.awt.Container;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.bridge.ComposeSemanticsTreeUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0013\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J,\u0010\u0017\u001a\u001c\u0012\u000b\u0012\t\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001a\u0012\u000b\u0012\t\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001b0\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J,\u0010\u001c\u001a\u001c\u0012\u000b\u0012\t\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001a\u0012\u000b\u0012\t\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001b0\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0012H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006+"}, d2={"Lcom/intellij/platform/compose/ComposeUndoManager;", "Lcom/intellij/openapi/command/undo/UndoManager;", "component", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "getComponent", "()Ljava/awt/Component;", "focusedComponent", "Landroidx/compose/ui/semantics/SemanticsNode;", "getFocusedComponent", "()Landroidx/compose/ui/semantics/SemanticsNode;", "undo", "", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "redo", "isUndoAvailable", "", "isRedoAvailable", "getUndoAction", "Landroidx/compose/ui/semantics/CustomAccessibilityAction;", "getRedoAction", "getUndoActionNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "Lcom/intellij/openapi/util/NlsActions$ActionDescription;", "getRedoActionNameAndDescription", "undoableActionPerformed", "action", "Lcom/intellij/openapi/command/undo/UndoableAction;", "nonundoableActionPerformed", "ref", "Lcom/intellij/openapi/command/undo/DocumentReference;", "isGlobal", "isUndoInProgress", "isRedoInProgress", "getNextUndoNanoTime", "", "getNextRedoNanoTime", "isNextUndoAskConfirmation", "isNextRedoAskConfirmation", "intellij.platform.compose"})
@ApiStatus.Internal
@StabilityInferred(parameters=0)
public final class ComposeUndoManager
extends UndoManager {
    @NotNull
    private final Component component;
    public static final int $stable = 8;

    public ComposeUndoManager(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
    }

    @NotNull
    public final Component getComponent() {
        return this.component;
    }

    @Nullable
    public final SemanticsNode getFocusedComponent() {
        ComposePanel parent;
        Container container = this.component.getParent();
        ComposePanel composePanel = parent = container instanceof ComposePanel ? (ComposePanel)container : null;
        return composePanel != null ? ComposeSemanticsTreeUtils.INSTANCE.findFocusedComponent(composePanel) : null;
    }

    public void undo(@Nullable FileEditor editor) {
        block0: {
            CustomAccessibilityAction customAccessibilityAction = this.getUndoAction();
            if (customAccessibilityAction == null || (customAccessibilityAction = customAccessibilityAction.getAction()) == null) break block0;
            Boolean cfr_ignored_0 = (Boolean)customAccessibilityAction.invoke();
        }
    }

    public void redo(@Nullable FileEditor editor) {
        block0: {
            CustomAccessibilityAction customAccessibilityAction = this.getRedoAction();
            if (customAccessibilityAction == null || (customAccessibilityAction = customAccessibilityAction.getAction()) == null) break block0;
            Boolean cfr_ignored_0 = (Boolean)customAccessibilityAction.invoke();
        }
    }

    public boolean isUndoAvailable(@Nullable FileEditor editor) {
        return this.getUndoAction() != null;
    }

    public boolean isRedoAvailable(@Nullable FileEditor editor) {
        return this.getRedoAction() != null;
    }

    private final CustomAccessibilityAction getUndoAction() {
        SemanticsNode semanticsNode = this.getFocusedComponent();
        return semanticsNode != null ? ComposeSemanticsTreeUtils.INSTANCE.getCustomAction(semanticsNode, "Undo") : null;
    }

    private final CustomAccessibilityAction getRedoAction() {
        SemanticsNode semanticsNode = this.getFocusedComponent();
        return semanticsNode != null ? ComposeSemanticsTreeUtils.INSTANCE.getCustomAction(semanticsNode, "Redo") : null;
    }

    @NotNull
    public Pair<String, String> getUndoActionNameAndDescription(@Nullable FileEditor editor) {
        Object[] objectArray = new Object[]{""};
        String string = ActionsBundle.message((String)"action.undo.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        objectArray = new Object[]{ActionsBundle.message((String)"action.undo.description.empty", (Object[])new Object[0])};
        String string3 = ActionsBundle.message((String)"action.undo.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return new Pair((Object)string2, (Object)((Object)StringsKt.trim((CharSequence)string3)).toString());
    }

    @NotNull
    public Pair<String, String> getRedoActionNameAndDescription(@Nullable FileEditor editor) {
        Object[] objectArray = new Object[]{""};
        String string = ActionsBundle.message((String)"action.redo.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        objectArray = new Object[]{ActionsBundle.message((String)"action.redo.description.empty", (Object[])new Object[0])};
        String string3 = ActionsBundle.message((String)"action.redo.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return new Pair((Object)string2, (Object)((Object)StringsKt.trim((CharSequence)string3)).toString());
    }

    public void undoableActionPerformed(@NotNull UndoableAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
    }

    public void nonundoableActionPerformed(@NotNull DocumentReference ref, boolean isGlobal) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
    }

    public boolean isUndoInProgress() {
        return false;
    }

    public boolean isRedoInProgress() {
        return false;
    }

    public long getNextUndoNanoTime(@NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return -1L;
    }

    public long getNextRedoNanoTime(@NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return -1L;
    }

    public boolean isNextUndoAskConfirmation(@NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return false;
    }

    public boolean isNextRedoAskConfirmation(@NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return false;
    }
}

