/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.suggested.SuggestedRefactoringChangeListener;
import com.intellij.refactoring.suggested.SuggestedRefactoringSignatureWatcher;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\rH\u0014J\b\u0010\u0016\u001a\u00020\rH\u0014J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J/\u0010\u001a\u001a\u00020\r2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001c\"\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001eH\u0004\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\rH\u0004J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0019H\u0004R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringChangeListenerTest;", "Lcom/intellij/testFramework/fixtures/LightJavaCodeInsightFixtureTestCase;", "<init>", "()V", "watcher", "Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringChangeListenerTest$Watcher;", "changeListener", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeListener;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "appendSignature", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "declaration", "Lcom/intellij/psi/PsiElement;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "setUp", "tearDown", "setup", "fileText", "", "perform", "expectedLog", "", "action", "Lkotlin/Function0;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "commitAll", "insertString", "offset", "", "text", "Watcher", "intellij.java.testFramework"})
@SourceDebugExtension(value={"SMAP\nBaseSuggestedRefactoringChangeListenerTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSuggestedRefactoringChangeListenerTest.kt\ncom/intellij/refactoring/suggested/BaseSuggestedRefactoringChangeListenerTest\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,108:1\n7#2,6:109\n7#2,6:115\n*S KotlinDebug\n*F\n+ 1 BaseSuggestedRefactoringChangeListenerTest.kt\ncom/intellij/refactoring/suggested/BaseSuggestedRefactoringChangeListenerTest\n*L\n57#1:109,6\n70#1:115,6\n*E\n"})
public abstract class BaseSuggestedRefactoringChangeListenerTest
extends LightJavaCodeInsightFixtureTestCase {
    @NotNull
    private final Watcher watcher = new Watcher();
    private SuggestedRefactoringChangeListener changeListener;
    @NotNull
    private final Disposable disposable;

    public BaseSuggestedRefactoringChangeListenerTest() {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
    }

    @NotNull
    protected abstract FileType getFileType();

    private final void appendSignature(StringBuilder $this$appendSignature, PsiElement declaration) {
        Language language = declaration.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        SuggestedRefactoringSupport suggestedRefactoringSupport = SuggestedRefactoringSupport.Companion.forLanguage(language);
        Intrinsics.checkNotNull((Object)suggestedRefactoringSupport);
        SuggestedRefactoringSupport refactoringSupport = suggestedRefactoringSupport;
        TextRange textRange = refactoringSupport.signatureRange(declaration);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        $this$appendSignature.append("'");
        String string = declaration.getContainingFile().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = range.getStartOffset();
        int n2 = range.getEndOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String text = StringsKt.replace$default((String)string3, (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
        $this$appendSignature.append(text);
        $this$appendSignature.append("'");
    }

    @Override
    protected void setUp() {
        super.setUp();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SuggestedRefactoringSignatureWatcher suggestedRefactoringSignatureWatcher = this.watcher;
        Disposable disposable = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getTestRootDisposable(...)");
        this.changeListener = new SuggestedRefactoringChangeListener(project, suggestedRefactoringSignatureWatcher, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() {
        try {
            Disposer.dispose((Disposable)this.disposable);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected final void setup(@NotNull String fileText) {
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        this.myFixture.configureByText(this.getFileType(), fileText);
    }

    protected final void perform(@NotNull String[] expectedLog, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)expectedLog, (String)"expectedLog");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.watcher.check("");
        action.invoke();
        Project project$iv = null;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
            final /* synthetic */ BaseSuggestedRefactoringChangeListenerTest this$0;
            {
                this.this$0 = baseSuggestedRefactoringChangeListenerTest;
            }

            public final void run() {
                boolean bl = false;
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ BaseSuggestedRefactoringChangeListenerTest this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void invoke() {
                        PsiDocumentManager.getInstance((Project)BaseSuggestedRefactoringChangeListenerTest.access$getProject(this.this$0)).doPostponedOperationsAndUnblockDocument(BaseSuggestedRefactoringChangeListenerTest.access$getEditor(this.this$0).getDocument());
                    }
                }));
            }
        }, name$iv, groupId$iv);
        this.watcher.check(ArraysKt.joinToString$default((Object[])expectedLog, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    protected final void commitAll() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
    }

    protected final void insertString(int offset, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Project project$iv = null;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this, offset, text){
            final /* synthetic */ BaseSuggestedRefactoringChangeListenerTest this$0;
            final /* synthetic */ int $offset$inlined;
            final /* synthetic */ String $text$inlined;
            {
                this.this$0 = baseSuggestedRefactoringChangeListenerTest;
                this.$offset$inlined = n;
                this.$text$inlined = string;
            }

            public final void run() {
                boolean bl = false;
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.this$0, this.$offset$inlined, this.$text$inlined){
                    final /* synthetic */ BaseSuggestedRefactoringChangeListenerTest this$0;
                    final /* synthetic */ int $offset;
                    final /* synthetic */ String $text;
                    {
                        this.this$0 = $receiver;
                        this.$offset = $offset;
                        this.$text = $text;
                    }

                    public final void invoke() {
                        BaseSuggestedRefactoringChangeListenerTest.access$getEditor(this.this$0).getDocument().insertString(this.$offset, (CharSequence)this.$text);
                    }
                }));
            }
        }, name$iv, groupId$iv);
    }

    public static final /* synthetic */ Project access$getProject(BaseSuggestedRefactoringChangeListenerTest $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ Editor access$getEditor(BaseSuggestedRefactoringChangeListenerTest $this) {
        return $this.getEditor();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringChangeListenerTest$Watcher;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSignatureWatcher;", "<init>", "(Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringChangeListenerTest;)V", "log", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "check", "", "expectedLog", "", "editingStarted", "declaration", "Lcom/intellij/psi/PsiElement;", "refactoringSupport", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "nextSignature", "anchor", "inconsistentState", "reset", "intellij.java.testFramework"})
    private final class Watcher
    implements SuggestedRefactoringSignatureWatcher {
        @NotNull
        private final StringBuilder log = new StringBuilder();

        public final void check(@NotNull String expectedLog) {
            Intrinsics.checkNotNullParameter((Object)expectedLog, (String)"expectedLog");
            String string = this.log.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            TestCase.assertEquals((String)expectedLog, (String)((Object)StringsKt.trim((CharSequence)string)).toString());
            StringsKt.clear((StringBuilder)this.log);
        }

        public void editingStarted(@NotNull PsiElement declaration, @NotNull SuggestedRefactoringSupport refactoringSupport) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)refactoringSupport, (String)"refactoringSupport");
            this.log.append("editingStarted: ");
            BaseSuggestedRefactoringChangeListenerTest.this.appendSignature(this.log, declaration);
            this.log.append("\n");
        }

        public void nextSignature(@NotNull PsiElement anchor, @NotNull SuggestedRefactoringSupport refactoringSupport) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)refactoringSupport, (String)"refactoringSupport");
            if (refactoringSupport.hasSyntaxError(anchor)) {
                return;
            }
            this.log.append("nextSignature: ");
            BaseSuggestedRefactoringChangeListenerTest.this.appendSignature(this.log, anchor);
            this.log.append("\n");
        }

        public void inconsistentState() {
            this.log.append("inconsistentState\n");
        }

        public void reset() {
            this.log.append("reset\n");
        }
    }
}

