/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.patterns.PatternToken;

public class PatternTokenMatcher {
    private final PatternToken basePatternToken;
    private PatternToken patternToken;
    private List<PatternTokenMatcher> andGroup;
    private boolean[] andGroupCheck;

    public PatternTokenMatcher(PatternToken patternToken) {
        this.patternToken = this.basePatternToken = patternToken;
        if (this.basePatternToken.hasAndGroup()) {
            List<PatternToken> patternTokenAndGroup = this.basePatternToken.getAndGroup();
            this.andGroup = new ArrayList<PatternTokenMatcher>(patternTokenAndGroup.size());
            for (PatternToken el : patternTokenAndGroup) {
                PatternTokenMatcher matcher = new PatternTokenMatcher(el);
                this.andGroup.add(matcher);
            }
        }
    }

    public void resolveReference(int firstMatchToken, AnalyzedTokenReadings[] tokens, Language language) throws IOException {
        int refPos;
        if (this.basePatternToken.isReferenceElement() && (refPos = firstMatchToken + this.basePatternToken.getMatch().getTokenRef()) < tokens.length) {
            this.patternToken = this.basePatternToken.compile(tokens[refPos], language.getSynthesizer());
        }
    }

    public PatternToken getPatternToken() {
        return this.basePatternToken;
    }

    public final boolean isMatched(AnalyzedToken token) {
        boolean matched = this.patternToken.isMatched(token);
        if (this.patternToken.hasAndGroup()) {
            this.andGroupCheck[0] = this.andGroupCheck[0] | matched;
        }
        return matched;
    }

    void prepareAndGroup(int firstMatchToken, AnalyzedTokenReadings[] tokens, Language language) throws IOException {
        if (this.basePatternToken.hasAndGroup()) {
            for (PatternTokenMatcher andMatcher : this.andGroup) {
                andMatcher.resolveReference(firstMatchToken, tokens, language);
            }
            this.andGroupCheck = new boolean[this.patternToken.getAndGroup().size() + 1];
            Arrays.fill(this.andGroupCheck, false);
        }
    }

    public final void addMemberAndGroup(AnalyzedToken token) {
        if (this.patternToken.hasAndGroup()) {
            List<PatternTokenMatcher> andGroupList = this.andGroup;
            for (int i = 0; i < andGroupList.size(); ++i) {
                PatternTokenMatcher testAndGroup;
                if (this.andGroupCheck[i + 1] || !(testAndGroup = andGroupList.get(i)).isMatched(token)) continue;
                this.andGroupCheck[i + 1] = true;
            }
        }
    }

    public final boolean checkAndGroup(boolean previousValue) {
        if (this.patternToken.hasAndGroup()) {
            boolean allConditionsMatch = true;
            for (boolean testValue : this.andGroupCheck) {
                allConditionsMatch &= testValue;
            }
            return allConditionsMatch;
        }
        return previousValue;
    }

    public final boolean isMatchedByScopeNextException(AnalyzedToken token) {
        return this.patternToken.isMatchedByScopeNextException(token);
    }

    public final boolean isExceptionMatchedCompletely(AnalyzedToken token) {
        return this.patternToken.isExceptionMatchedCompletely(token);
    }

    public boolean hasPreviousException() {
        return this.patternToken.hasPreviousException();
    }

    public boolean isMatchedByPreviousException(AnalyzedTokenReadings token) {
        return this.patternToken.isMatchedByPreviousException(token);
    }

    public String toString() {
        return "PatternTokenMatcher for " + String.valueOf(this.basePatternToken);
    }
}

