/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.contentAnnotation;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionLineParser;
import com.intellij.execution.filters.ExceptionLineParserFactory;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotation;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationImpl;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

final class VcsContentAnnotationExceptionFilter
implements Filter,
FilterMixin {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(VcsContentAnnotationExceptionFilter.class);
    private final VcsContentAnnotationSettings mySettings;
    private final Map<VirtualFile, VcsRevisionNumber> myRevNumbersCache;
    private final ExceptionInfoCache myCache;

    VcsContentAnnotationExceptionFilter(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            VcsContentAnnotationExceptionFilter.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            VcsContentAnnotationExceptionFilter.$$$reportNull$$$0(1);
        }
        this.myRevNumbersCache = new HashMap<VirtualFile, VcsRevisionNumber>();
        this.myProject = project;
        this.mySettings = VcsContentAnnotationSettings.getInstance((Project)this.myProject);
        this.myCache = new ExceptionInfoCache(project, scope);
    }

    public boolean shouldRunHeavy() {
        return this.mySettings.isShow();
    }

    public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<? super FilterMixin.AdditionalHighlight> consumer) {
        if (copiedFragment == null) {
            VcsContentAnnotationExceptionFilter.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            VcsContentAnnotationExceptionFilter.$$$reportNull$$$0(3);
        }
        VcsContentAnnotation vcsContentAnnotation = VcsContentAnnotationImpl.getInstance((Project)this.myProject);
        LocalChangesCorrector localChangesCorrector = new LocalChangesCorrector(this.myProject);
        LineResult previousLineResult = null;
        for (int i = 0; i < copiedFragment.getLineCount(); ++i) {
            String lineText;
            int lineStartOffset = copiedFragment.getLineStartOffset(i);
            int lineEndOffset = copiedFragment.getLineEndOffset(i);
            ExceptionLineParser worker = ExceptionLineParserFactory.getInstance().create(this.myCache);
            LineResult lineResult = (LineResult)ReadAction.compute(() -> this.lambda$applyHeavyFilter$0(worker, lineText = copiedFragment.getText(new TextRange(lineStartOffset, lineEndOffset)), lineEndOffset));
            if (lineResult != null && lineResult.file() != null) {
                FileStatus status;
                boolean isFileChanged;
                VirtualFile vf = lineResult.file().getVirtualFile();
                if (vf.getFileSystem().isReadOnly()) continue;
                VcsRevisionNumber recentChangeRevision = this.myRevNumbersCache.get(vf);
                if (recentChangeRevision == null) {
                    recentChangeRevision = vcsContentAnnotation.fileRecentlyChanged(vf);
                    if (recentChangeRevision == null) {
                        this.myRevNumbersCache.put(vf, VcsRevisionNumber.NULL);
                    } else {
                        this.myRevNumbersCache.put(vf, recentChangeRevision);
                    }
                }
                if (VcsRevisionNumber.NULL.equals((Object)recentChangeRevision)) {
                    recentChangeRevision = null;
                }
                boolean bl = isFileChanged = FileStatus.NOT_CHANGED.equals((Object)(status = ChangeListManager.getInstance((Project)this.myProject).getStatus(vf))) || FileStatus.UNKNOWN.equals((Object)status) || FileStatus.IGNORED.equals((Object)status);
                if (localChangesCorrector.isFileAlreadyIdentifiedAsChanged(vf) || isFileChanged || recentChangeRevision != null) {
                    List<TextRange> ranges;
                    Document document = VcsContentAnnotationExceptionFilter.getDocumentForFile(worker);
                    if (document == null) {
                        return;
                    }
                    TextRange fileLinkRange = worker.getInfo().fileLineRange;
                    int startFileLinkOffset = fileLinkRange.getStartOffset();
                    int idx = lineText.indexOf(58, startFileLinkOffset);
                    int endFileLinkOffset = idx == -1 ? fileLinkRange.getEndOffset() : idx;
                    consumer.consume((Object)new MyAdditionalHighlight(startOffset + lineStartOffset + startFileLinkOffset, startOffset + lineStartOffset + endFileLinkOffset));
                    if (lineResult.uClass() != null && (ranges = VcsContentAnnotationExceptionFilter.findMethodRange(worker, document, previousLineResult)) != null) {
                        boolean methodChanged = false;
                        for (TextRange range : ranges) {
                            if (localChangesCorrector.isRangeChangedLocally(vf, document, range)) {
                                methodChanged = true;
                                break;
                            }
                            TextRange correctedRange = localChangesCorrector.getCorrectedRange(vf, document, range);
                            if (!vcsContentAnnotation.intervalRecentlyChanged(vf, correctedRange, recentChangeRevision)) continue;
                            methodChanged = true;
                            break;
                        }
                        if (methodChanged) {
                            consumer.consume((Object)new MyAdditionalHighlight(startOffset + lineStartOffset + worker.getInfo().methodNameRange.getStartOffset(), startOffset + lineStartOffset + worker.getInfo().methodNameRange.getEndOffset()));
                        }
                    }
                }
            }
            previousLineResult = worker.getResult() == null ? null : lineResult;
        }
    }

    @NotNull
    public String getUpdateMessage() {
        String string = VcsBundle.message((String)"checking.recent.changes", (Object[])new Object[0]);
        if (string == null) {
            VcsContentAnnotationExceptionFilter.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static Document getDocumentForFile(@NotNull ExceptionLineParser worker) {
        if (worker == null) {
            VcsContentAnnotationExceptionFilter.$$$reportNull$$$0(5);
        }
        return (Document)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(worker.getFile().getVirtualFile());
            if (document == null) {
                LOG.info("can not get document for file: " + String.valueOf(worker.getFile().getVirtualFile()));
                return null;
            }
            return document;
        });
    }

    private static List<TextRange> findMethodRange(ExceptionLineParser worker, Document document, LineResult previousLineResult) {
        return (List)ReadAction.compute(() -> {
            List<TextRange> ranges = VcsContentAnnotationExceptionFilter.getTextRangeForMethod(worker, previousLineResult);
            if (ranges == null) {
                return null;
            }
            ArrayList<TextRange> result = new ArrayList<TextRange>();
            for (TextRange range : ranges) {
                result.add(new TextRange(document.getLineNumber(range.getStartOffset()), document.getLineNumber(range.getEndOffset())));
            }
            return result;
        });
    }

    @Nullable
    private static List<UMethod> selectMethod(List<UMethod> methods, final LineResult previousLineResult) {
        if (previousLineResult == null || previousLineResult.method() == null) {
            return null;
        }
        SmartList result = new SmartList();
        for (UMethod method : methods) {
            PsiElement psi = method.getSourcePsi();
            if (psi == null) continue;
            psi.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)result, method){
                final /* synthetic */ List val$result;
                final /* synthetic */ UMethod val$method;
                {
                    this.val$result = list;
                    this.val$method = uMethod;
                }

                public void visitElement(@NotNull PsiElement element) {
                    PsiMethod resolved;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    UCallExpression call = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
                    if (call != null && (resolved = call.resolve()) != null && resolved.getName().equals(previousLineResult.method())) {
                        this.val$result.add(this.val$method);
                        this.stopWalking();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/contentAnnotation/VcsContentAnnotationExceptionFilter$1", "visitElement"));
                }
            });
        }
        return result;
    }

    private static List<TextRange> getTextRangeForMethod(ExceptionLineParser worker, LineResult previousLineResult) {
        List<UMethod> methods;
        String method = worker.getMethod().replaceFirst("\\$lambda\\$\\d+$", "").replaceFirst("^lambda\\$(.+)\\$\\d+$", "$1");
        UClass psiClass = worker.getUClass();
        if (psiClass == null) {
            return null;
        }
        if (method.contains("<init>")) {
            methods = ContainerUtil.filter((Object[])psiClass.getMethods(), m -> m.isConstructor());
        } else {
            if (method.contains("$")) {
                return null;
            }
            methods = ContainerUtil.filter((Object[])psiClass.getMethods(), m -> method.equals(m.getName()));
        }
        if (!methods.isEmpty()) {
            if (methods.size() == 1) {
                PsiElement psi = ((UMethod)methods.get(0)).getSourcePsi();
                if (psi == null) {
                    return null;
                }
                TextRange range = psi.getTextRange();
                return Collections.singletonList(range);
            }
            List<UMethod> selectedMethods = VcsContentAnnotationExceptionFilter.selectMethod(methods, previousLineResult);
            List<UMethod> toIterate = selectedMethods == null ? methods : selectedMethods;
            ArrayList<TextRange> result = new ArrayList<TextRange>();
            for (UMethod psiMethod : toIterate) {
                PsiElement psi = psiMethod.getSourcePsi();
                if (psi == null) continue;
                result.add(psi.getTextRange());
            }
            return result;
        }
        return null;
    }

    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            VcsContentAnnotationExceptionFilter.$$$reportNull$$$0(6);
        }
        return null;
    }

    private /* synthetic */ LineResult lambda$applyHeavyFilter$0(ExceptionLineParser worker, String lineText, int lineEndOffset) throws RuntimeException {
        if (DumbService.isDumb((Project)this.myProject)) {
            return null;
        }
        Filter.Result result = worker.execute(lineText, lineEndOffset);
        if (result == null) {
            return null;
        }
        return new LineResult(worker.getUClass(), worker.getFile(), worker.getMethod());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFragment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/contentAnnotation/VcsContentAnnotationExceptionFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/contentAnnotation/VcsContentAnnotationExceptionFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyHeavyFilter";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentForFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class LocalChangesCorrector {
        private final Map<VirtualFile, UpToDateLineNumberProvider> myRecentlyChanged;
        private final Project myProject;

        private LocalChangesCorrector(Project project) {
            this.myProject = project;
            this.myRecentlyChanged = new HashMap<VirtualFile, UpToDateLineNumberProvider>();
        }

        boolean isFileAlreadyIdentifiedAsChanged(VirtualFile vf) {
            return this.myRecentlyChanged.containsKey(vf);
        }

        boolean isRangeChangedLocally(@NotNull VirtualFile vf, @NotNull Document document, @NotNull TextRange range) {
            if (vf == null) {
                LocalChangesCorrector.$$$reportNull$$$0(0);
            }
            if (document == null) {
                LocalChangesCorrector.$$$reportNull$$$0(1);
            }
            if (range == null) {
                LocalChangesCorrector.$$$reportNull$$$0(2);
            }
            UpToDateLineNumberProvider provider = this.getProvider(vf, document);
            return (Boolean)ReadAction.compute(() -> provider.isRangeChanged(range.getStartOffset(), range.getEndOffset()));
        }

        TextRange getCorrectedRange(@NotNull VirtualFile vf, @NotNull Document document, @NotNull TextRange range) {
            if (vf == null) {
                LocalChangesCorrector.$$$reportNull$$$0(3);
            }
            if (document == null) {
                LocalChangesCorrector.$$$reportNull$$$0(4);
            }
            if (range == null) {
                LocalChangesCorrector.$$$reportNull$$$0(5);
            }
            UpToDateLineNumberProvider provider = this.getProvider(vf, document);
            return (TextRange)ReadAction.compute(() -> new TextRange(provider.getLineNumber(range.getStartOffset()), provider.getLineNumber(range.getEndOffset())));
        }

        @NotNull
        private UpToDateLineNumberProvider getProvider(@NotNull VirtualFile vf, @NotNull Document document) {
            UpToDateLineNumberProvider provider;
            if (vf == null) {
                LocalChangesCorrector.$$$reportNull$$$0(6);
            }
            if (document == null) {
                LocalChangesCorrector.$$$reportNull$$$0(7);
            }
            if ((provider = this.myRecentlyChanged.get(vf)) == null) {
                provider = new UpToDateLineNumberProviderImpl(document, this.myProject);
                this.myRecentlyChanged.put(vf, provider);
            }
            UpToDateLineNumberProvider upToDateLineNumberProvider = provider;
            if (upToDateLineNumberProvider == null) {
                LocalChangesCorrector.$$$reportNull$$$0(8);
            }
            return upToDateLineNumberProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vf";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/contentAnnotation/VcsContentAnnotationExceptionFilter$LocalChangesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/contentAnnotation/VcsContentAnnotationExceptionFilter$LocalChangesCorrector";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isRangeChangedLocally";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCorrectedRange";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvider";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }

    record LineResult(@Nullable UClass uClass, @Nullable PsiFile file, @Nullable String method) {
    }

    private static final class MyAdditionalHighlight
    extends FilterMixin.AdditionalHighlight {
        private MyAdditionalHighlight(int start, int end) {
            super(start, end);
        }

        @NotNull
        public TextAttributes getTextAttributes(@Nullable TextAttributes source) {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            TextAttributes changedColor = globalScheme.getAttributes(DiffColors.DIFF_MODIFIED);
            if (source == null) {
                TextAttributes attrs = globalScheme.getAttributes(DefaultLanguageHighlighterColors.CLASS_NAME).clone();
                attrs.setBackgroundColor(changedColor.getBackgroundColor());
                TextAttributes textAttributes = attrs;
                if (textAttributes == null) {
                    MyAdditionalHighlight.$$$reportNull$$$0(0);
                }
                return textAttributes;
            }
            TextAttributes clone = source.clone();
            clone.setBackgroundColor(changedColor.getBackgroundColor());
            TextAttributes textAttributes = clone;
            if (textAttributes == null) {
                MyAdditionalHighlight.$$$reportNull$$$0(1);
            }
            return textAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/contentAnnotation/VcsContentAnnotationExceptionFilter$MyAdditionalHighlight", "getTextAttributes"));
        }
    }
}

