/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SelectInChangesViewTarget
implements SelectInTarget,
DumbAware {
    private final Project myProject;

    public SelectInChangesViewTarget(Project project) {
        this.myProject = project;
    }

    public String toString() {
        return ChangesViewManager.getLocalChangesToolWindowName(this.myProject);
    }

    public boolean canSelect(SelectInContext context) {
        VirtualFile file = context.getVirtualFile();
        FileStatus fileStatus = ChangeListManager.getInstance((Project)this.myProject).getStatus(file);
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length != 0 && !fileStatus.equals((Object)FileStatus.NOT_CHANGED);
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        VirtualFile file = context.getVirtualFile();
        Runnable runnable = () -> {
            ChangesViewContentManager.getInstance(this.myProject).selectContent("Local Changes");
            ChangesViewManager.getInstance(this.myProject).selectFile(file);
        };
        if (requestFocus) {
            ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(this.myProject, "Local Changes");
            if (toolWindow != null) {
                toolWindow.activate(runnable);
            }
        } else {
            runnable.run();
        }
    }

    @Nullable
    public String getToolWindowId() {
        return ChangesViewContentManager.getToolWindowIdFor(this.myProject, "Local Changes");
    }

    public float getWeight() {
        return 9.0f;
    }
}

