/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.idea.serialize;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.idea.serialize.IdeaKotlinExtrasSerializer;
import org.jetbrains.kotlin.gradle.idea.serialize.IdeaKotlinSerializationContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/idea/serialize/IdeaKotlinIntExtrasSerializer;", "Lorg/jetbrains/kotlin/gradle/idea/serialize/IdeaKotlinExtrasSerializer;", "", "()V", "deserialize", "context", "Lorg/jetbrains/kotlin/gradle/idea/serialize/IdeaKotlinSerializationContext;", "data", "", "(Lorg/jetbrains/kotlin/gradle/idea/serialize/IdeaKotlinSerializationContext;[B)Ljava/lang/Integer;", "serialize", "value", "kotlin-gradle-plugin-idea"})
public final class IdeaKotlinIntExtrasSerializer
implements IdeaKotlinExtrasSerializer<Integer> {
    @NotNull
    public static final IdeaKotlinIntExtrasSerializer INSTANCE = new IdeaKotlinIntExtrasSerializer();

    private IdeaKotlinIntExtrasSerializer() {
    }

    @Override
    @NotNull
    public byte[] serialize(@NotNull IdeaKotlinSerializationContext context, int value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        byte[] byArray = ByteBuffer.allocate(4).putInt(value).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"allocate(Int.SIZE_BYTES).putInt(value).array()");
        return byArray;
    }

    @Override
    @NotNull
    public Integer deserialize(@NotNull IdeaKotlinSerializationContext context, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return ByteBuffer.wrap(data).getInt();
    }
}

