/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.run.ui.grid.GridModelUpdater;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B7\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0004J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0004J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u001e\u0010%\u001a\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010$\u001a\u00020 H\u0004J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0004R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lcom/intellij/database/datagrid/GridLoaderBase;", "Lcom/intellij/database/datagrid/GridLoader;", "hookUp", "Lcom/intellij/database/datagrid/GridDataHookUpBase;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "pageModel", "Lcom/intellij/database/datagrid/MultiPageModel;", "modelUpdater", "Lcom/intellij/database/run/ui/grid/GridModelUpdater;", "<init>", "(Lcom/intellij/database/datagrid/GridDataHookUpBase;Lcom/intellij/database/datagrid/MultiPageModel;Lcom/intellij/database/run/ui/grid/GridModelUpdater;)V", "getHookUp", "()Lcom/intellij/database/datagrid/GridDataHookUpBase;", "getPageModel", "()Lcom/intellij/database/datagrid/MultiPageModel;", "getModelUpdater", "()Lcom/intellij/database/run/ui/grid/GridModelUpdater;", "reloadCurrentPage", "", "source", "Lcom/intellij/database/datagrid/GridRequestSource;", "loadNextPage", "loadPreviousPage", "loadFirstPage", "updateTotalRowCount", "applyFilterAndSorting", "updateIsTotalRowCountUpdateable", "loadLastPage", "getPositiveOffset", "", "offset", "", "getCount", "positiveOffset", "afterLastRowAdded", "rowsLoaded", "addRows", "rows", "", "loadingStarted", "intellij.grid.core.impl"})
public abstract class GridLoaderBase
implements GridLoader {
    @NotNull
    private final GridDataHookUpBase<GridRow, GridColumn> hookUp;
    @NotNull
    private final MultiPageModel<GridRow, GridColumn> pageModel;
    @NotNull
    private final GridModelUpdater modelUpdater;

    public GridLoaderBase(@NotNull GridDataHookUpBase<GridRow, GridColumn> hookUp, @NotNull MultiPageModel<GridRow, GridColumn> pageModel, @NotNull GridModelUpdater modelUpdater) {
        Intrinsics.checkNotNullParameter(hookUp, (String)"hookUp");
        Intrinsics.checkNotNullParameter(pageModel, (String)"pageModel");
        Intrinsics.checkNotNullParameter((Object)modelUpdater, (String)"modelUpdater");
        this.hookUp = hookUp;
        this.pageModel = pageModel;
        this.modelUpdater = modelUpdater;
    }

    @NotNull
    protected final GridDataHookUpBase<GridRow, GridColumn> getHookUp() {
        return this.hookUp;
    }

    @NotNull
    protected final MultiPageModel<GridRow, GridColumn> getPageModel() {
        return this.pageModel;
    }

    @NotNull
    protected final GridModelUpdater getModelUpdater() {
        return this.modelUpdater;
    }

    @Override
    public void reloadCurrentPage(@NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.load(source, Math.max(0, this.pageModel.getPageStart() - 1));
    }

    @Override
    public void loadNextPage(@NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.load(source, this.pageModel.getPageEnd());
    }

    @Override
    public void loadPreviousPage(@NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.load(source, Math.max(0, this.pageModel.getPageStart() - this.pageModel.getPageSize() - 1));
    }

    @Override
    public void loadFirstPage(@NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.load(source, 0);
    }

    @Override
    public void updateTotalRowCount(@NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.hookUp.notifyRequestFinished(source, false);
    }

    @Override
    public void applyFilterAndSorting(@NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.hookUp.notifyRequestFinished(source, false);
    }

    @Override
    public void updateIsTotalRowCountUpdateable() {
    }

    @Override
    public void loadLastPage(@NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int pageSize = this.pageModel.getPageSize();
        this.load(source, -(pageSize > 0 ? pageSize : 100));
    }

    protected final long getPositiveOffset(int offset) {
        return offset < 0 ? this.pageModel.getTotalRowCount() + (long)offset : (long)offset;
    }

    protected final long getCount(long positiveOffset) {
        return Math.min(this.pageModel.getTotalRowCount(), GridUtilCore.isPageSizeUnlimited(this.pageModel.getPageSize()) ? this.pageModel.getTotalRowCount() - positiveOffset : (long)this.pageModel.getPageSize());
    }

    protected final void afterLastRowAdded(int rowsLoaded, @NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (rowsLoaded >= 0 && rowsLoaded < this.hookUp.getDataModel().getRowCount()) {
            int rowsToRemove = this.hookUp.getDataModel().getRowCount() - rowsLoaded;
            this.modelUpdater.removeRows(this.hookUp.getDataModel().getRowCount() - rowsToRemove, rowsToRemove);
        }
        this.modelUpdater.afterLastRowAdded();
        source.requestComplete(true);
    }

    protected final int addRows(@NotNull List<? extends GridRow> rows, int rowsLoaded) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        if (rows.isEmpty()) {
            return 0;
        }
        if (rowsLoaded == 0) {
            this.pageModel.setPageStart(rows.get(0).getRowNum());
        }
        this.pageModel.setPageEnd(rows.get(rows.size() - 1).getRowNum());
        this.modelUpdater.setRows(rowsLoaded, rows, new GridRequestSource(null));
        return rows.size();
    }

    protected final void loadingStarted(int offset) {
        GridModel gridModel = this.hookUp.getDataModel();
        GridListModelBase gridListModelBase = gridModel instanceof GridListModelBase ? (GridListModelBase)gridModel : null;
        if (gridListModelBase != null) {
            gridListModelBase.setUpdatingNow(true);
        }
        this.pageModel.setPageStart(offset + 1);
        this.pageModel.setPageEnd(offset);
    }
}

