import { jsx } from 'react/jsx-runtime';
import '@grafana/data';
import { GroupByRow } from './GroupByRow.js';
import '../types.js';
import 'lodash';
import { useSqlChange } from '../utils/useSqlChange.js';

function SQLGroupByRow({ fields, query, onQueryChange, db }) {
  const { onSqlChange } = useSqlChange({ query, onQueryChange, db });
  return /* @__PURE__ */ jsx(GroupByRow, { columns: fields, sql: query.sql, onSqlChange });
}

export { SQLGroupByRow };
//# sourceMappingURL=SQLGroupByRow.js.map
