import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useCopyToClipboard } from 'react-use';
import '@grafana/data';
import { useStyles2, IconButton, Field, CodeEditor } from '@grafana/ui';
import { formatSQL } from '../utils/formatSQL.js';

function Preview({ rawSql }) {
  const [_, copyToClipboard] = useCopyToClipboard();
  const styles = useStyles2(getStyles);
  const labelElement = /* @__PURE__ */ jsxs("div", { className: styles.labelWrapper, children: [
    /* @__PURE__ */ jsx("label", { className: styles.label, children: "Preview" }),
    /* @__PURE__ */ jsx(IconButton, { tooltip: "Copy to clipboard", onClick: () => copyToClipboard(rawSql), name: "copy" })
  ] });
  return /* @__PURE__ */ jsx(Field, { label: labelElement, className: styles.grow, children: /* @__PURE__ */ jsx(
    CodeEditor,
    {
      language: "sql",
      height: 80,
      value: formatSQL(rawSql),
      monacoOptions: { scrollbar: { vertical: "hidden" }, scrollBeyondLastLine: false },
      readOnly: true,
      showMiniMap: false
    }
  ) });
}
function getStyles(theme) {
  return {
    grow: css({ flexGrow: 1 }),
    label: css({ fontSize: 12, fontWeight: theme.typography.fontWeightMedium }),
    labelWrapper: css({ display: "flex", justifyContent: "space-between", paddingBottom: theme.spacing(0.5) })
  };
}

export { Preview };
//# sourceMappingURL=Preview.js.map
