import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { useTheme2, InlineFieldRow, InlineField, Input, SecretInput, IconButton } from '@grafana/ui';
import { useCommonStyles } from '../styles.js';

const CustomHeader = ({ header, onChange, onBlur, onDelete, readOnly }) => {
  const { spacing } = useTheme2();
  const commonStyles = useCommonStyles();
  const styles = {
    container: css({
      alignItems: "center"
    }),
    input: css({
      minWidth: "100%"
    }),
    headerNameField: css({
      width: "40%",
      marginRight: 0,
      paddingRight: spacing(1)
    }),
    headerValueField: css({
      width: "45%",
      marginRight: 0
    }),
    removeHeaderBtn: css({
      margin: `0 0 3px 10px`
    })
  };
  return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsxs(InlineFieldRow, { className: styles.container, children: [
    /* @__PURE__ */ jsx(
      InlineField,
      {
        label: "Header",
        labelWidth: 9,
        grow: true,
        className: styles.headerNameField,
        htmlFor: `custom-header-${header.id}-name-input`,
        disabled: readOnly,
        children: /* @__PURE__ */ jsx(
          Input,
          {
            id: `custom-header-${header.id}-name-input`,
            placeholder: "X-Custom-Header",
            value: header.name,
            width: 12,
            onChange: (e) => onChange({ ...header, name: e.currentTarget.value }),
            onBlur,
            className: styles.input
          }
        )
      }
    ),
    /* @__PURE__ */ jsx(
      InlineField,
      {
        label: "Value",
        labelWidth: 9,
        grow: true,
        className: cx(commonStyles.inlineFieldWithSecret, styles.headerValueField),
        htmlFor: `custom-header-${header.id}-value-input`,
        disabled: readOnly,
        children: /* @__PURE__ */ jsx(
          SecretInput,
          {
            id: `custom-header-${header.id}-value-input`,
            isConfigured: header.configured,
            placeholder: "Header value",
            value: header.value,
            width: 12,
            onChange: (e) => onChange({ ...header, value: e.currentTarget.value }),
            onReset: readOnly ? () => {
            } : () => onChange({ ...header, configured: false, value: "" }),
            onBlur,
            className: styles.input
          }
        )
      }
    ),
    /* @__PURE__ */ jsx(
      IconButton,
      {
        name: "trash-alt",
        tooltip: "Remove header",
        tooltipPlacement: "top",
        className: styles.removeHeaderBtn,
        onClick: onDelete,
        type: "button",
        disabled: readOnly
      }
    )
  ] }) });
};

export { CustomHeader };
//# sourceMappingURL=CustomHeader.js.map
