/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.jvm.toolchain.internal.operations.JavaToolchainUsageProgressDetails;

public class DefaultJavaToolchainUsageProgressDetails
implements JavaToolchainUsageProgressDetails {
    private final JavaTool toolName;
    private final JvmInstallationMetadata toolchainMetadata;
    private static final JavaToolchainUsageProgressDetails.JavaToolchain UNKNOWN_TOOLCHAIN = new JavaToolchainUsageProgressDetails.JavaToolchain(){

        public String getJavaVersion() {
            return "unknown";
        }

        public String getJavaVendor() {
            return "unknown";
        }

        public String getRuntimeName() {
            return "unknown";
        }

        public String getRuntimeVersion() {
            return "unknown";
        }

        public String getJvmName() {
            return "unknown";
        }

        public String getJvmVersion() {
            return "unknown";
        }

        public String getJvmVendor() {
            return "unknown";
        }

        public String getArchitecture() {
            return "unknown";
        }
    };

    public DefaultJavaToolchainUsageProgressDetails(JavaTool toolName, JvmInstallationMetadata toolchainMetadata) {
        this.toolName = toolName;
        this.toolchainMetadata = toolchainMetadata;
    }

    public String getToolName() {
        return this.toolName.getToolName();
    }

    public JavaToolchainUsageProgressDetails.JavaToolchain getToolchain() {
        return this.toolchainMetadata.isValidInstallation() ? new ToolchainFromMetadata(this.toolchainMetadata) : UNKNOWN_TOOLCHAIN;
    }

    public static enum JavaTool {
        COMPILER(JavaCompiler.class.getSimpleName()),
        LAUNCHER(JavaLauncher.class.getSimpleName()),
        JAVADOC(JavadocTool.class.getSimpleName());

        private final String toolName;

        private JavaTool(String toolName) {
            this.toolName = toolName;
        }

        public String getToolName() {
            return this.toolName;
        }
    }

    private static class ToolchainFromMetadata
    implements JavaToolchainUsageProgressDetails.JavaToolchain {
        private final JvmInstallationMetadata metadata;

        public ToolchainFromMetadata(JvmInstallationMetadata metadata) {
            this.metadata = metadata;
        }

        public String getJavaVersion() {
            return this.metadata.getJavaVersion();
        }

        public String getJavaVendor() {
            return this.metadata.getVendor().getDisplayName();
        }

        public String getRuntimeName() {
            return this.metadata.getRuntimeName();
        }

        public String getRuntimeVersion() {
            return this.metadata.getRuntimeVersion();
        }

        public String getJvmName() {
            return this.metadata.getJvmName();
        }

        public String getJvmVersion() {
            return this.metadata.getJvmVersion();
        }

        public String getJvmVendor() {
            return this.metadata.getJvmVendor();
        }

        public String getArchitecture() {
            return this.metadata.getArchitecture();
        }
    }
}

