/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.filter;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import org.gradle.api.internal.tasks.testing.filter.ClassTestSelectionMatcher;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
class FileTestSelectionMatcher {
    private final ClassTestSelectionMatcher classTestSelectionMatcher;
    private final Collection<Path> roots;

    FileTestSelectionMatcher(ClassTestSelectionMatcher classTestSelectionMatcher, Collection<Path> roots) {
        this.classTestSelectionMatcher = classTestSelectionMatcher;
        this.roots = roots;
    }

    public boolean matchesFile(File file) {
        try {
            Path path = file.toPath().toRealPath(new LinkOption[0]);
            for (Path root : this.roots) {
                if (!path.startsWith(root)) continue;
                String relativePath = TextUtil.normaliseFileSeparators((String)root.relativize(path).toString());
                String withoutExtension = FileTestSelectionMatcher.removeExtension(relativePath);
                String packagified = withoutExtension.replaceAll("/", ".");
                return this.classTestSelectionMatcher.matchesTest(packagified, "");
            }
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    private static String removeExtension(String relativePath) {
        int lastSlash = relativePath.lastIndexOf(47);
        int lastDot = relativePath.lastIndexOf(46);
        if (lastDot > lastSlash) {
            return relativePath.substring(0, lastDot);
        }
        return relativePath;
    }
}

