/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.Definition;

public interface TargetTypeInformation<T> {

    public static class BuildModelTargetTypeInformation<T extends BuildModel>
    implements TargetTypeInformation<Definition<T>> {
        public final Class<T> buildModelType;

        public BuildModelTargetTypeInformation(Class<T> buildModelType) {
            this.buildModelType = buildModelType;
        }

        public String toString() {
            return "build model type " + this.buildModelType.getSimpleName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildModelTargetTypeInformation that = (BuildModelTargetTypeInformation)o;
            return this.buildModelType.equals(that.buildModelType);
        }

        public int hashCode() {
            return this.buildModelType.hashCode();
        }
    }

    public static class DefinitionTargetTypeInformation<T>
    implements TargetTypeInformation<T> {
        public final Class<T> definitionType;

        public DefinitionTargetTypeInformation(Class<T> definitionType) {
            this.definitionType = definitionType;
        }

        public String toString() {
            return "definition type " + this.definitionType.getSimpleName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefinitionTargetTypeInformation that = (DefinitionTargetTypeInformation)o;
            return this.definitionType.equals(that.definitionType);
        }

        public int hashCode() {
            return this.definitionType.hashCode();
        }
    }
}

