/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.work.ConditionalExecution;

public abstract class AbstractConditionalExecution<T>
implements ConditionalExecution<T> {
    private final CountDownLatch finished = new CountDownLatch(1);
    private final RunnableFuture<T> runnable;

    public AbstractConditionalExecution(Callable<T> callable) {
        this.runnable = new FutureTask<T>(callable);
    }

    @Override
    public Runnable getExecution() {
        return this.runnable;
    }

    @Override
    public T await() {
        boolean interrupted = false;
        while (true) {
            try {
                this.finished.await();
            }
            catch (InterruptedException e) {
                this.cancel();
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        try {
            return (T)this.runnable.get();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw UncheckedException.throwAsUncheckedException((Throwable)(cause != null ? cause : e));
        }
    }

    @Override
    public void complete() {
        this.finished.countDown();
    }

    @Override
    public boolean isComplete() {
        return this.finished.getCount() == 0L;
    }

    @Override
    public void cancel() {
        this.runnable.cancel(true);
    }
}

