/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class DefaultWorkValidationContext
implements WorkValidationContext {
    private final Set<Class<?>> types = new HashSet();
    private final ImmutableList.Builder<InternalProblem> problems = ImmutableList.builder();
    private final WorkValidationContext.TypeOriginInspector typeOriginInspector;
    private final InternalProblems problemsService;

    public DefaultWorkValidationContext(WorkValidationContext.TypeOriginInspector typeOriginInspector, InternalProblems problemsService) {
        this.typeOriginInspector = typeOriginInspector;
        this.problemsService = problemsService;
    }

    @Override
    public InternalProblems getProblemsService() {
        return this.problemsService;
    }

    @Override
    public TypeValidationContext forType(Class<?> type, final boolean cacheable) {
        this.types.add(type);
        Supplier<Optional> pluginId = () -> this.typeOriginInspector.findPluginDefining(type);
        return new ProblemRecordingTypeValidationContext(type, pluginId, this.getProblemsService()){

            protected void recordProblem(InternalProblem problem) {
                if (DefaultTypeValidationContext.onlyAffectsCacheableWork((ProblemId)problem.getDefinition().getId()) && !cacheable) {
                    return;
                }
                DefaultWorkValidationContext.this.problems.add((Object)problem);
            }
        };
    }

    @Override
    public List<InternalProblem> getProblems() {
        return this.problems.build();
    }

    public ImmutableSortedSet<Class<?>> getValidatedTypes() {
        return ImmutableSortedSet.copyOf(Comparator.comparing(Class::getName), this.types);
    }
}

