/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.file.FileCanonicalizer;
import org.gradle.internal.file.FileMetadataAccessor;
import org.gradle.internal.file.FileModeAccessor;
import org.gradle.internal.file.FileModeMutator;
import org.gradle.internal.file.StatStatistics;
import org.gradle.internal.file.nio.Jdk7FileCanonicalizer;
import org.gradle.internal.file.nio.PosixJdk7FilePermissionHandler;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Symlink;
import org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7Symlink;
import org.gradle.internal.nativeintegration.filesystem.jdk7.WindowsJdk7Symlink;
import org.gradle.internal.nativeintegration.filesystem.services.EmptyChmod;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackStat;
import org.gradle.internal.nativeintegration.filesystem.services.GenericFileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;

public class FileSystemServices
implements ServiceRegistrationProvider {
    public void configure(ServiceRegistration registration) {
        registration.add(GenericFileSystem.Factory.class);
        registration.add(StatStatistics.Collector.class);
    }

    @Provides
    FileCanonicalizer createFileCanonicalizer() {
        return new Jdk7FileCanonicalizer();
    }

    @Provides
    Symlink createWindowsJdkSymlink() {
        return new WindowsJdk7Symlink();
    }

    @Provides
    Symlink createJdkSymlink(TemporaryFileProvider temporaryFileProvider) {
        return new Jdk7Symlink(temporaryFileProvider);
    }

    @Provides
    FileSystem createFileSystem(GenericFileSystem.Factory genericFileSystemFactory, OperatingSystem operatingSystem, FileMetadataAccessor metadataAccessor, TemporaryFileProvider temporaryFileProvider) {
        if (operatingSystem.isWindows()) {
            Symlink symlink = this.createWindowsJdkSymlink();
            return genericFileSystemFactory.create(new EmptyChmod(), new FallbackStat(), symlink);
        }
        Symlink symlink = this.createJdkSymlink(temporaryFileProvider);
        PosixJdk7FilePermissionHandler handler = new PosixJdk7FilePermissionHandler();
        return genericFileSystemFactory.create((FileModeMutator)handler, (FileModeAccessor)handler, symlink);
    }
}

